/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.engine.visitor.inspector;

import com.tinkerpop.frames.VertexFrame;
import java.io.Closeable;
import java.io.File;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.inject.Inject;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.jboss.windup.engine.util.ZipUtil;
import org.jboss.windup.engine.visitor.AbstractGraphVisitor;
import org.jboss.windup.engine.visitor.GraphVisitor;
import org.jboss.windup.engine.visitor.VisitorPhase;
import org.jboss.windup.engine.visitor.inspector.BasicVisitor;
import org.jboss.windup.graph.dao.ArchiveDao;
import org.jboss.windup.graph.dao.FileResourceDao;
import org.jboss.windup.graph.dao.TempFileArchiveEntryDao;
import org.jboss.windup.graph.model.resource.ArchiveResource;
import org.jboss.windup.graph.model.resource.FileResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZipArchiveGraphVisitor
extends AbstractGraphVisitor {
    private static final Logger LOG = LoggerFactory.getLogger(ZipArchiveGraphVisitor.class);
    @Inject
    private FileResourceDao fileDao;
    @Inject
    private ArchiveDao archiveDao;
    @Inject
    private TempFileArchiveEntryDao tempFileArchiveEntryDao;

    @Override
    public List<Class<? extends GraphVisitor>> getDependencies() {
        return super.generateDependencies(BasicVisitor.class);
    }

    @Override
    public VisitorPhase getPhase() {
        return VisitorPhase.DISCOVERY;
    }

    private Set<String> getZipExtensions() {
        HashSet<String> extensions = new HashSet<String>();
        extensions.add(".war");
        extensions.add(".ear");
        extensions.add(".jar");
        extensions.add(".sar");
        extensions.add(".rar");
        return extensions;
    }

    private boolean endsWithExtension(String path) {
        for (String extension : this.getZipExtensions()) {
            if (!StringUtils.endsWith((String)path, (String)extension)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void run() {
        for (FileResource file : this.fileDao.findArchiveEntryWithExtension(new String[]{"war", "ear", "jar", "sar", "rar"})) {
            this.visitFile(file);
        }
        this.fileDao.commit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visitFile(FileResource file) {
        String filePath = file.getFilePath();
        if (this.endsWithExtension(filePath)) {
            File reference = new File(filePath);
            ZipFile zipFile = null;
            try {
                zipFile = new ZipFile(reference);
                ArchiveResource archive = (ArchiveResource)this.archiveDao.create();
                archive.setArchiveName(reference.getName());
                archive.setFileResource(file);
                Enumeration<? extends ZipEntry> entries = zipFile.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry entry = entries.nextElement();
                    if (entry.isDirectory() || !this.endsWithExtension(entry.getName())) continue;
                    String subArchiveName = StringUtils.substringAfterLast((String)entry.getName(), (String)"/");
                    File subArchiveTempFile = ZipUtil.unzipToTemp(zipFile, entry);
                    FileResource subArchiveTempFileReference = this.fileDao.getByFilePath(subArchiveTempFile.getAbsolutePath());
                    subArchiveTempFileReference = (FileResource)this.tempFileArchiveEntryDao.castToType((VertexFrame)subArchiveTempFileReference);
                    ArchiveResource subArchive = (ArchiveResource)this.archiveDao.create();
                    subArchive.setArchiveName(subArchiveName);
                    subArchive.setFileResource(subArchiveTempFileReference);
                    archive.addChild(subArchive);
                }
            }
            catch (Exception e) {
                try {
                    LOG.error("Exception creating zip from: " + filePath, (Throwable)e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(zipFile);
                    throw throwable;
                }
                IOUtils.closeQuietly((Closeable)zipFile);
            }
            IOUtils.closeQuietly((Closeable)zipFile);
        }
    }
}

