/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.engine.visitor.reporter;

import javax.inject.Inject;
import org.jboss.windup.engine.visitor.AbstractGraphVisitor;
import org.jboss.windup.engine.visitor.VisitorPhase;
import org.jboss.windup.graph.dao.JarArchiveDao;
import org.jboss.windup.graph.model.resource.JarArchive;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArchiveDependsOnReporter
extends AbstractGraphVisitor {
    private static final Logger LOG = LoggerFactory.getLogger(ArchiveDependsOnReporter.class);
    @Inject
    private JarArchiveDao jarDao;

    @Override
    public VisitorPhase getPhase() {
        return VisitorPhase.REPORTING;
    }

    @Override
    public void run() {
        for (JarArchive archive : this.jarDao.getAll()) {
            LOG.info("Archive: " + archive.getArchiveName() + " - " + archive.asVertex());
            for (JarArchive clz : archive.dependsOnArchives()) {
                LOG.info(" - Depends On: " + clz.getArchiveName());
            }
            for (JarArchive clz : archive.providesForArchives()) {
                LOG.info(" - Provides For: " + clz.getArchiveName());
            }
            for (JarArchive src : this.jarDao.findCircularReferences(archive)) {
                LOG.info(" - Circular with: " + src.getArchiveName());
            }
        }
    }
}

