/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.engine.visitor.reporter;

import java.io.File;
import java.util.HashSet;
import java.util.Set;
import javax.inject.Inject;
import org.apache.commons.io.FileUtils;
import org.jboss.windup.engine.visitor.AbstractGraphVisitor;
import org.jboss.windup.engine.visitor.VisitorPhase;
import org.jboss.windup.graph.dao.JarArchiveDao;
import org.jboss.windup.graph.model.resource.JarArchive;
import org.jboss.windup.graph.renderer.SimpleGraphRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArchiveTransitiveDependsOnReporter
extends AbstractGraphVisitor {
    private static final Logger LOG = LoggerFactory.getLogger(ArchiveTransitiveDependsOnReporter.class);
    @Inject
    private JarArchiveDao jarDao;

    @Override
    public VisitorPhase getPhase() {
        return VisitorPhase.REPORTING;
    }

    @Override
    public void run() {
        this.processDependsOnTransitive();
        this.processProvidesForTransitive();
    }

    public void processDependsOnTransitive() {
        for (JarArchive archive : this.jarDao.getAll()) {
            SimpleGraphRenderer simpleGraph = new SimpleGraphRenderer("depends on");
            SimpleGraphRenderer.RenderableVertex v = (SimpleGraphRenderer.RenderableVertex)simpleGraph.getFramed().addVertex(null, SimpleGraphRenderer.RenderableVertex.class);
            v.setLabel(archive.getArchiveName());
            LOG.info("Archive: " + archive.getArchiveName());
            HashSet<Object> vertexIds = new HashSet<Object>();
            this.profileTransitiveDependsOn(archive, vertexIds);
            vertexIds.remove(archive.asVertex().getId());
            for (Object e : vertexIds) {
                JarArchive dep = (JarArchive)this.jarDao.getById(e);
                LOG.info(" - Depends on: " + dep.getArchiveName());
                SimpleGraphRenderer.RenderableVertex child = (SimpleGraphRenderer.RenderableVertex)simpleGraph.getFramed().addVertex(null, SimpleGraphRenderer.RenderableVertex.class);
                child.setLabel(dep.getArchiveName());
                v.addOut(child);
            }
            File dagre = new File(FileUtils.getTempDirectory(), archive.getArchiveName() + "-depends-dagred3.html");
            File file = new File(FileUtils.getTempDirectory(), archive.getArchiveName() + "-depends-sigmajs.html");
            File vizjs = new File(FileUtils.getTempDirectory(), archive.getArchiveName() + "-depends-vizjs.html");
            simpleGraph.renderDagreD3(dagre);
            simpleGraph.renderSigma(file);
            simpleGraph.renderVizjs(vizjs);
            LOG.info("Created graph: " + dagre.getAbsolutePath());
            LOG.info("Created graph: " + file.getAbsolutePath());
            LOG.info("Created graph: " + vizjs.getAbsolutePath());
        }
    }

    public void processProvidesForTransitive() {
        for (JarArchive archive : this.jarDao.getAll()) {
            SimpleGraphRenderer simpleGraph = new SimpleGraphRenderer("provides for");
            SimpleGraphRenderer.RenderableVertex v = (SimpleGraphRenderer.RenderableVertex)simpleGraph.getFramed().addVertex(null, SimpleGraphRenderer.RenderableVertex.class);
            v.setLabel(archive.getArchiveName());
            LOG.info("Archive: " + archive.getArchiveName());
            HashSet<Object> vertexIds = new HashSet<Object>();
            this.profileTransitiveProvidesFor(archive, vertexIds);
            vertexIds.remove(archive.asVertex().getId());
            for (Object e : vertexIds) {
                JarArchive dep = (JarArchive)this.jarDao.getById(e);
                LOG.info(" - Provides for: " + dep.getArchiveName());
                SimpleGraphRenderer.RenderableVertex child = (SimpleGraphRenderer.RenderableVertex)simpleGraph.getFramed().addVertex(null, SimpleGraphRenderer.RenderableVertex.class);
                child.setLabel(dep.getArchiveName());
                v.addIn(child);
            }
            File dagre = new File(FileUtils.getTempDirectory(), archive.getArchiveName() + "-provides-dagred3.html");
            File file = new File(FileUtils.getTempDirectory(), archive.getArchiveName() + "-provides-sigmajs.html");
            File vizjs = new File(FileUtils.getTempDirectory(), archive.getArchiveName() + "-provides-vizjs.html");
            simpleGraph.renderDagreD3(dagre);
            simpleGraph.renderSigma(file);
            simpleGraph.renderVizjs(vizjs);
            LOG.info("Created graph: " + dagre.getAbsolutePath());
            LOG.info("Created graph: " + file.getAbsolutePath());
            LOG.info("Created graph: " + vizjs.getAbsolutePath());
        }
    }

    public void profileTransitiveDependsOn(JarArchive archive, Set<Object> visited) {
        visited.add(archive.asVertex().getId());
        for (JarArchive clz : archive.dependsOnArchives()) {
            if (visited.contains(clz.asVertex().getId())) continue;
            this.profileTransitiveDependsOn(clz, visited);
        }
    }

    public void profileTransitiveProvidesFor(JarArchive archive, Set<Object> visited) {
        visited.add(archive.asVertex().getId());
        for (JarArchive clz : archive.providesForArchives()) {
            if (visited.contains(clz.asVertex().getId())) continue;
            this.profileTransitiveDependsOn(clz, visited);
        }
    }
}

