/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.engine.visitor.reporter;

import javax.inject.Inject;
import org.jboss.windup.engine.visitor.AbstractGraphVisitor;
import org.jboss.windup.engine.visitor.VisitorPhase;
import org.jboss.windup.graph.dao.EJBConfigurationDao;
import org.jboss.windup.graph.model.meta.javaclass.EjbEntityFacet;
import org.jboss.windup.graph.model.meta.javaclass.EjbSessionBeanFacet;
import org.jboss.windup.graph.model.meta.javaclass.MessageDrivenBeanFacet;
import org.jboss.windup.graph.model.meta.xml.EjbConfigurationFacet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EjbConfigurationReporter
extends AbstractGraphVisitor {
    private static final Logger LOG = LoggerFactory.getLogger(EjbConfigurationReporter.class);
    @Inject
    private EJBConfigurationDao ejbConfigurationDao;

    @Override
    public VisitorPhase getPhase() {
        return VisitorPhase.REPORTING;
    }

    @Override
    public void run() {
        for (EjbConfigurationFacet ejb : this.ejbConfigurationDao.getAll()) {
            String clz;
            String name;
            LOG.info("Ejb Configuration: " + ejb.getXmlFacet());
            LOG.info("  - EJB Specification: " + ejb.getSpecificationVersion());
            LOG.info("  - Ejb Entities: ");
            for (EjbEntityFacet entity : ejb.getEjbEntity()) {
                name = "    - " + entity.getEjbEntityName();
                clz = "";
                if (entity.getJavaClassFacet() != null) {
                    clz = entity.getJavaClassFacet().getQualifiedName();
                }
                LOG.info(name + " - " + clz);
            }
            LOG.info("  - Ejb Session: ");
            for (EjbSessionBeanFacet session : ejb.getEjbSessionBeans()) {
                name = "    - " + session.getSessionBeanName();
                clz = "";
                if (session.getJavaClassFacet() != null) {
                    clz = session.getJavaClassFacet().getQualifiedName();
                }
                LOG.info(name + " - " + clz);
            }
            LOG.info("  - MDBs: ");
            for (MessageDrivenBeanFacet mdb : ejb.getMessageDriven()) {
                name = "    - " + mdb.getMessageDrivenBeanName();
                clz = "";
                if (mdb.getJavaClassFacet() != null) {
                    clz = mdb.getJavaClassFacet().getQualifiedName();
                }
                LOG.info(name + " - " + clz);
            }
        }
    }
}

