/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.engine.visitor.reporter;

import javax.inject.Inject;
import org.jboss.windup.engine.visitor.AbstractGraphVisitor;
import org.jboss.windup.engine.visitor.VisitorPhase;
import org.jboss.windup.graph.dao.JarManifestDao;
import org.jboss.windup.graph.model.meta.JarManifest;
import org.jboss.windup.graph.model.resource.JarArchive;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JarManifestReporter
extends AbstractGraphVisitor {
    private static final Logger LOG = LoggerFactory.getLogger(JarManifestReporter.class);
    @Inject
    private JarManifestDao manifestDao;

    @Override
    public VisitorPhase getPhase() {
        return VisitorPhase.REPORTING;
    }

    @Override
    public void run() {
        for (JarManifest manifest : this.manifestDao.getAll()) {
            JarArchive archive = manifest.getJarArchive();
            LOG.info("Manifest for Archive: " + archive.getArchiveName());
            for (String key : manifest.keySet()) {
                LOG.info("  - " + key + ": " + manifest.getProperty(key));
            }
        }
    }
}

