/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.engine.visitor.reporter;

import javax.inject.Inject;
import org.jboss.windup.engine.visitor.AbstractGraphVisitor;
import org.jboss.windup.engine.visitor.VisitorPhase;
import org.jboss.windup.graph.dao.MavenFacetDao;
import org.jboss.windup.graph.model.meta.xml.MavenFacet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenPomReporter
extends AbstractGraphVisitor {
    private static final Logger LOG = LoggerFactory.getLogger(MavenPomReporter.class);
    @Inject
    private MavenFacetDao mavenDao;

    @Override
    public VisitorPhase getPhase() {
        return VisitorPhase.REPORTING;
    }

    @Override
    public void run() {
        for (MavenFacet facet : this.mavenDao.getAll()) {
            LOG.info("Maven: " + facet.getGroupId() + ":" + facet.getArtifactId() + ":" + facet.getVersion());
            if (facet.getParent() != null) {
                MavenFacet parent = facet.getParent();
                LOG.info(" - Parent: " + parent.getGroupId() + ":" + parent.getArtifactId() + ":" + parent.getVersion());
            }
            for (MavenFacet child : facet.getChildModules()) {
                LOG.info(" - Module: " + child.getGroupId() + ":" + child.getArtifactId() + ":" + child.getVersion());
            }
            for (MavenFacet dep : facet.getDependencies()) {
                LOG.info(" - Dependency: " + dep.getGroupId() + ":" + dep.getArtifactId() + ":" + dep.getVersion());
            }
        }
    }
}

