/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.engine.visitor.reporter;

import javax.inject.Inject;
import org.jboss.windup.engine.visitor.AbstractGraphVisitor;
import org.jboss.windup.engine.visitor.VisitorPhase;
import org.jboss.windup.graph.dao.NamespaceDao;
import org.jboss.windup.graph.model.meta.xml.NamespaceMeta;
import org.jboss.windup.graph.model.resource.ArchiveEntryResource;
import org.jboss.windup.graph.model.resource.Resource;
import org.jboss.windup.graph.model.resource.XmlResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NamespacesFoundReporter
extends AbstractGraphVisitor {
    private static final Logger LOG = LoggerFactory.getLogger(NamespacesFoundReporter.class);
    @Inject
    private NamespaceDao namespaceDao;

    @Override
    public VisitorPhase getPhase() {
        return VisitorPhase.REPORTING;
    }

    @Override
    public void run() {
        for (NamespaceMeta namespace : this.namespaceDao.getAll()) {
            LOG.info("Namespace: ");
            LOG.info("  - URI: " + namespace.getURI());
            LOG.info("  - Loc: " + namespace.getSchemaLocation());
            for (XmlResource xml : namespace.getXmlResources()) {
                Resource resource = xml.getResource();
                if (!(resource instanceof ArchiveEntryResource)) continue;
                ArchiveEntryResource ar = (ArchiveEntryResource)resource;
                LOG.info("   - " + ar.getArchiveEntry());
            }
        }
    }
}

