/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.bootstrap;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.StringUtils;
import org.jboss.forge.furnace.Furnace;
import org.jboss.forge.furnace.impl.addons.AddonRepositoryImpl;
import org.jboss.forge.furnace.repositories.AddonRepository;
import org.jboss.forge.furnace.repositories.AddonRepositoryMode;
import org.jboss.forge.furnace.repositories.MutableAddonRepository;
import org.jboss.forge.furnace.se.FurnaceFactory;
import org.jboss.forge.furnace.spi.ContainerLifecycleListener;
import org.jboss.forge.furnace.versions.EmptyVersion;
import org.jboss.forge.furnace.versions.SingleVersion;
import org.jboss.forge.furnace.versions.Version;
import org.jboss.windup.bootstrap.commands.Command;
import org.jboss.windup.bootstrap.commands.CommandPhase;
import org.jboss.windup.bootstrap.commands.CommandResult;
import org.jboss.windup.bootstrap.commands.FurnaceDependent;
import org.jboss.windup.bootstrap.commands.addons.AddAddonDirectoryCommand;
import org.jboss.windup.bootstrap.commands.addons.AddImmutableAddonDirectoryCommand;
import org.jboss.windup.bootstrap.commands.addons.InstallAddonCommand;
import org.jboss.windup.bootstrap.commands.addons.ListAddonsCommand;
import org.jboss.windup.bootstrap.commands.addons.RemoveAddonCommand;
import org.jboss.windup.bootstrap.commands.windup.DisplayHelpCommand;
import org.jboss.windup.bootstrap.commands.windup.DisplayVersionCommand;
import org.jboss.windup.bootstrap.commands.windup.GenerateCompletionDataCommand;
import org.jboss.windup.bootstrap.commands.windup.ListSourceTechnologiesCommand;
import org.jboss.windup.bootstrap.commands.windup.ListTagsCommand;
import org.jboss.windup.bootstrap.commands.windup.ListTargetTechnologiesCommand;
import org.jboss.windup.bootstrap.commands.windup.RunWindupCommand;
import org.jboss.windup.bootstrap.commands.windup.UpdateRulesetsCommand;
import org.jboss.windup.bootstrap.listener.GreetingListener;

public class Bootstrap {
    public static final String WINDUP_HOME = "windup.home";
    private AtomicBoolean batchMode = new AtomicBoolean(false);
    private Furnace furnace;

    public static void main(String[] args) {
        ArrayList<String> bootstrapArgs = new ArrayList<String>();
        for (String arg : args) {
            if (Bootstrap.handleAsSystemProperty(arg)) continue;
            bootstrapArgs.add(arg);
        }
        File rulesDir = Bootstrap.getUserRulesDir();
        if (!rulesDir.exists()) {
            rulesDir.mkdirs();
        }
        String defaultLog = new File(Bootstrap.getUserWindupDir(), "log/windup.log").getAbsolutePath();
        String logDir = System.getProperty("org.jboss.forge.log.file", defaultLog);
        System.setProperty("org.jboss.forge.log.file", logDir);
        String logManagerName = Bootstrap.getServiceName(Bootstrap.class.getClassLoader(), "java.util.logging.LogManager");
        if (logManagerName != null) {
            System.setProperty("java.util.logging.manager", logManagerName);
        }
        Bootstrap bootstrap = new Bootstrap();
        bootstrap.run(bootstrapArgs);
        bootstrap.stop();
    }

    private static boolean handleAsSystemProperty(String argument) {
        String value;
        String name;
        if (!argument.startsWith("-D")) {
            return false;
        }
        int index = argument.indexOf("=");
        if (index == -1) {
            name = argument.substring(2);
            value = "true";
        } else {
            name = argument.substring(2, index);
            value = argument.substring(index + 1);
        }
        System.setProperty(name, value);
        return true;
    }

    private void run(List<String> args) {
        try {
            this.furnace = FurnaceFactory.getInstance();
            this.furnace.setServerMode(true);
            CopyOnWriteArrayList<Command> commands = new CopyOnWriteArrayList<Command>(this.processArguments(args));
            if (!this.executePhase(CommandPhase.PRE_CONFIGURATION, commands)) {
                return;
            }
            if (!this.executePhase(CommandPhase.CONFIGURATION, commands)) {
                return;
            }
            if (!Bootstrap.containsMutableRepository(this.furnace.getRepositories())) {
                this.furnace.addRepository(AddonRepositoryMode.MUTABLE, Bootstrap.getUserAddonsDir());
            }
            if (commands.isEmpty()) {
                commands.add(new DisplayHelpCommand());
            }
            if (!this.executePhase(CommandPhase.POST_CONFIGURATION, commands) || commands.isEmpty()) {
                return;
            }
            try {
                Future future = this.furnace.startAsync();
                future.get();
            }
            catch (Exception e) {
                System.out.println("Failed to start Windup!");
                if (e.getMessage() != null) {
                    System.out.println("Failure reason: " + e.getMessage());
                }
                e.printStackTrace();
            }
            if (!this.executePhase(CommandPhase.PRE_EXECUTION, commands) || commands.isEmpty()) {
                return;
            }
            this.furnace.addContainerLifecycleListener((ContainerLifecycleListener)new GreetingListener());
            if (!this.executePhase(CommandPhase.EXECUTION, commands) || commands.isEmpty()) {
                return;
            }
            if (!this.executePhase(CommandPhase.POST_EXECUTION, commands) || commands.isEmpty()) {
                return;
            }
        }
        catch (Throwable t) {
            System.err.println("Windup execution failed due to: " + t.getMessage());
            t.printStackTrace();
        }
    }

    private void stop() {
        if (this.furnace != null && !this.furnace.getStatus().isStopped()) {
            this.furnace.stop();
        }
    }

    private List<Command> processArguments(List<String> arguments) {
        String arg;
        int i;
        ArrayList<String> unknownArgs = new ArrayList<String>();
        ArrayList<Command> commands = new ArrayList<Command>();
        for (i = 0; i < arguments.size(); ++i) {
            arg = arguments.get(i);
            if ("--batchMode".equals(arg) || "-b".equals(arg)) {
                this.batchMode.set(true);
                continue;
            }
            if ("--debug".equals(arg) || "-d".equals(arg)) continue;
            if (arg.equals("-help") || arg.equals("--help") || arg.equals("-h") || arg.equals("/?") || arg.equals("/help")) {
                commands.add(new DisplayHelpCommand());
                continue;
            }
            if ("--install".equals(arg) || "-i".equals(arg)) {
                commands.add(new InstallAddonCommand(arguments.get(++i), this.batchMode));
                continue;
            }
            if ("--remove".equals(arg) || "-r".equals(arg)) {
                commands.add(new RemoveAddonCommand(arguments.get(++i), this.batchMode));
                continue;
            }
            if ("--list".equals(arg) || "-l".equals(arg)) {
                commands.add(new ListAddonsCommand());
                continue;
            }
            if ("--addonDir".equals(arg) || "-a".equals(arg)) {
                commands.add(new AddAddonDirectoryCommand(arguments.get(++i)));
                continue;
            }
            if ("--immutableAddonDir".equals(arg) || "-m".equals(arg)) {
                commands.add(new AddImmutableAddonDirectoryCommand(arguments.get(++i)));
                continue;
            }
            if ("--version".equals(arg) || "-v".equals(arg)) {
                commands.add(new DisplayVersionCommand());
                continue;
            }
            if ("--listTags".equals(arg)) {
                commands.add(new ListTagsCommand());
                continue;
            }
            if ("--listSourceTechnologies".equals(arg)) {
                commands.add(new ListSourceTechnologiesCommand());
                continue;
            }
            if ("--listTargetTechnologies".equals(arg)) {
                commands.add(new ListTargetTechnologiesCommand());
                continue;
            }
            if ("--generateCompletionData".equals(arg)) {
                commands.add(new GenerateCompletionDataCommand(true));
                continue;
            }
            if (arg.startsWith("--updateRules")) {
                commands.add(new UpdateRulesetsCommand());
                continue;
            }
            unknownArgs.add(arg);
        }
        for (i = 0; i < arguments.size(); ++i) {
            arg = arguments.get(i);
            if (!unknownArgs.contains(arg)) continue;
            arguments.remove(i);
        }
        ArrayList<String> windupArguments = new ArrayList<String>(unknownArgs);
        if (!windupArguments.isEmpty()) {
            commands.add(new DisplayVersionCommand(CommandResult.CONTINUE));
            commands.add(new RunWindupCommand(windupArguments, this.batchMode));
        }
        return commands;
    }

    private boolean executePhase(CommandPhase phase, CopyOnWriteArrayList<Command> commands) {
        for (Command command : commands) {
            CommandResult result;
            if (!phase.equals((Object)command.getPhase())) continue;
            commands.remove(command);
            if (command instanceof FurnaceDependent) {
                ((FurnaceDependent)((Object)command)).setFurnace(this.furnace);
            }
            if (!CommandResult.EXIT.equals((Object)(result = command.execute()))) continue;
            return false;
        }
        return true;
    }

    private static boolean containsMutableRepository(List<AddonRepository> repositories) {
        boolean result = false;
        for (AddonRepository repository : repositories) {
            if (!(repository instanceof MutableAddonRepository)) continue;
            result = true;
            break;
        }
        return result;
    }

    public static String promptForListItem(String message, Collection<String> items, String defaultValue) {
        while (true) {
            String item2;
            ArrayList<String> sorted = new ArrayList<String>(items);
            Collections.sort(sorted);
            System.out.println();
            System.out.println(message);
            for (String item2 : items) {
                System.out.println("\t" + item2);
            }
            String promptMessage = "Please enter the item you would like to choose[" + defaultValue + "]: ";
            item2 = System.console().readLine(promptMessage, new Object[0]).trim();
            if (StringUtils.isNotBlank((CharSequence)item2)) {
                return item2;
            }
            if (StringUtils.isNotBlank((CharSequence)defaultValue)) {
                return defaultValue;
            }
            System.out.println("A selection is required. Please select one of the available items.");
        }
    }

    public static boolean prompt(String message, boolean defaultValue, boolean batchMode) {
        if (batchMode) {
            return defaultValue;
        }
        String defaultMessage = defaultValue ? " [Y,n] " : " [y,N] ";
        String line = System.console().readLine(message + defaultMessage, new Object[0]).trim();
        if ("y".equalsIgnoreCase(line)) {
            return true;
        }
        if ("n".equalsIgnoreCase(line)) {
            return false;
        }
        return defaultValue;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getServiceName(ClassLoader classLoader, String className) {
        try (InputStream stream = classLoader.getResourceAsStream("META-INF/services/" + className);){
            if (stream == null) {
                String string = null;
                return string;
            }
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(stream));){
                String line;
                do {
                    if ((line = reader.readLine()) == null) return null;
                    int i = line.indexOf(35);
                    if (i == -1) continue;
                    line = line.substring(0, i);
                } while ((line = line.trim()).length() == 0);
                String string = line;
                return string;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public static String getVersion() {
        return Bootstrap.getRuntimeAPIVersion().toString();
    }

    public static String getVersionString() {
        return "> JBoss Windup, version " + Bootstrap.getRuntimeAPIVersion() + ". JBoss Forge, version " + AddonRepositoryImpl.getRuntimeAPIVersion();
    }

    public static Version getRuntimeAPIVersion() {
        String version = Bootstrap.class.getPackage().getImplementationVersion();
        if (version != null) {
            return new SingleVersion(version);
        }
        return EmptyVersion.getInstance();
    }

    private static File getUserRulesDir() {
        return new File(Bootstrap.getUserWindupDir(), "rules");
    }

    public static File getUserWindupDir() {
        String userHome = System.getProperty("user.home");
        if (userHome == null) {
            Path path = new File("").toPath();
            return path.toFile();
        }
        return Paths.get(userHome, new String[0]).resolve(".windup").toFile();
    }

    private static File getUserAddonsDir() {
        return Bootstrap.getUserWindupDir().toPath().resolve(".addons").toFile();
    }

    private File getWindupAddonsDir() {
        return new File(this.getWindupHome(), "addons");
    }

    private File getWindupHome() {
        String windupHome = System.getProperty(WINDUP_HOME);
        if (windupHome == null) {
            Path path = new File("").toPath();
            return path.toFile();
        }
        return Paths.get(windupHome, new String[0]).toFile();
    }
}

