/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.bootstrap.commands.windup;

import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.jboss.forge.furnace.Furnace;
import org.jboss.forge.furnace.repositories.AddonRepository;
import org.jboss.windup.bootstrap.Bootstrap;
import org.jboss.windup.bootstrap.ConsoleProgressMonitor;
import org.jboss.windup.bootstrap.commands.Command;
import org.jboss.windup.bootstrap.commands.CommandPhase;
import org.jboss.windup.bootstrap.commands.CommandResult;
import org.jboss.windup.bootstrap.commands.FurnaceDependent;
import org.jboss.windup.config.ConfigurationOption;
import org.jboss.windup.config.InputType;
import org.jboss.windup.config.ValidationResult;
import org.jboss.windup.config.metadata.RuleProviderRegistryCache;
import org.jboss.windup.exec.WindupProcessor;
import org.jboss.windup.exec.WindupProgressMonitor;
import org.jboss.windup.exec.configuration.WindupConfiguration;
import org.jboss.windup.exec.configuration.options.OutputPathOption;
import org.jboss.windup.graph.GraphContextFactory;
import org.jboss.windup.util.Logging;
import org.jboss.windup.util.exception.WindupException;

public class RunWindupCommand
implements Command,
FurnaceDependent {
    private static final Logger log = Logging.get(RunWindupCommand.class);
    private Furnace furnace;
    private final List<String> arguments;
    private final AtomicBoolean batchMode;

    public RunWindupCommand(List<String> arguments, AtomicBoolean batchMode) {
        this.arguments = arguments;
        this.batchMode = batchMode;
    }

    @Override
    public CommandResult execute() {
        this.runWindup(this.arguments);
        return CommandResult.EXIT;
    }

    @Override
    public void setFurnace(Furnace furnace) {
        this.furnace = furnace;
    }

    @Override
    public CommandPhase getPhase() {
        return CommandPhase.EXECUTION;
    }

    private void runWindup(List<String> arguments) {
        String string;
        boolean validationSuccess;
        Set<String> targets;
        Iterable optionIterable = WindupConfiguration.getWindupConfigurationOptions((Furnace)this.furnace);
        HashMap<String, ConfigurationOption> options = new HashMap<String, ConfigurationOption>();
        for (ConfigurationOption option : optionIterable) {
            options.put(option.getName().toUpperCase(), option);
        }
        HashMap<String, Object> optionValues = new HashMap<String, Object>();
        for (int i = 0; i < arguments.size(); ++i) {
            String argument = arguments.get(i);
            String optionName = this.getOptionName(argument);
            if (optionName == null) {
                System.err.println("WARNING: Unrecognized command-line argument: " + argument);
                continue;
            }
            ConfigurationOption option = (ConfigurationOption)options.get(optionName.toUpperCase());
            if (option == null) {
                System.err.println("WARNING: Unrecognized command-line argument: " + argument);
                continue;
            }
            if (option.getUIType() == InputType.MANY || option.getUIType() == InputType.SELECT_MANY) {
                ArrayList<Object> values = new ArrayList<Object>();
                ++i;
                while (i < arguments.size()) {
                    String arg = arguments.get(i);
                    String name = this.getOptionName(arg);
                    if (name != null) {
                        --i;
                        break;
                    }
                    String string2 = arguments.get(i);
                    for (String value : StringUtils.split((String)string2, (char)' ')) {
                        values.add(this.convertType(option.getType(), value));
                    }
                    ++i;
                }
                if (optionValues.containsKey(option.getName())) {
                    ((List)optionValues.get(option.getName())).addAll(values);
                    continue;
                }
                optionValues.put(option.getName(), values);
                continue;
            }
            if (Boolean.class.isAssignableFrom(option.getType())) {
                optionValues.put(option.getName(), true);
                continue;
            }
            String valueString = arguments.get(++i);
            Object value = this.convertType(option.getType(), valueString);
            optionValues.put(option.getName(), value);
        }
        this.setDefaultOutputPath(optionValues);
        this.setDefaultOptionsValues(options, optionValues);
        RuleProviderRegistryCache ruleProviderRegistryCache = (RuleProviderRegistryCache)this.furnace.getAddonRegistry(new AddonRepository[0]).getServices(RuleProviderRegistryCache.class).get();
        File userProvidedPath = (File)optionValues.get("userRulesDirectory");
        if (userProvidedPath != null) {
            ruleProviderRegistryCache.addUserRulesPath(userProvidedPath.toPath());
        }
        if (((targets = (Set<String>)optionValues.get("target")) == null || targets.isEmpty()) && !this.batchMode.get()) {
            String target = Bootstrap.promptForListItem("Please select a target:", ruleProviderRegistryCache.getAvailableTargetTechnologies(), "eap");
            targets = Collections.singleton(target);
            optionValues.put("target", targets);
        }
        if (!(validationSuccess = this.validateOptionValues(options, optionValues))) {
            return;
        }
        Boolean isExplodedApp = (Boolean)optionValues.get("explodedApp") != false || (Boolean)optionValues.get("sourceMode") != false;
        if (!isExplodedApp.booleanValue()) {
            List<Path> input = (List<Path>)optionValues.get("input");
            input = RunWindupCommand.expandMultiAppInputDirs(input);
            optionValues.put("input", input);
        }
        WindupConfiguration windupConfiguration = new WindupConfiguration();
        for (Map.Entry entry : options.entrySet()) {
            ConfigurationOption option = (ConfigurationOption)entry.getValue();
            windupConfiguration.setOptionValue(option.getName(), optionValues.get(option.getName()));
        }
        if (!this.validateInputAndOutputPath(windupConfiguration.getInputPaths(), windupConfiguration.getOutputDirectory())) {
            return;
        }
        try {
            windupConfiguration.useDefaultDirectories();
        }
        catch (IOException e) {
            System.err.println("ERROR: Failed to create default directories due to: " + e.getMessage());
            return;
        }
        Boolean overwrite = (Boolean)windupConfiguration.getOptionMap().get("overwrite");
        if (overwrite == null) {
            overwrite = false;
        }
        if (!overwrite.booleanValue() && this.pathNotEmpty(windupConfiguration.getOutputDirectory().toFile()) && !Bootstrap.prompt(string = "Overwrite all contents of \"" + windupConfiguration.getOutputDirectory().toString() + "\" (anything already in the directory will be deleted)?", false, this.batchMode.get())) {
            String outputPath = windupConfiguration.getOutputDirectory().toString();
            System.err.println("Files exist in " + (String)outputPath + ", but --overwrite not specified. Aborting!");
            return;
        }
        FileUtils.deleteQuietly((File)windupConfiguration.getOutputDirectory().toFile());
        Path path = windupConfiguration.getOutputDirectory().resolve("graph");
        System.out.println();
        if (windupConfiguration.getInputPaths().size() == 1) {
            System.out.println("Input Application:" + windupConfiguration.getInputPaths().iterator().next());
        } else {
            System.out.println("Input Applications:");
            for (Path inputPath : windupConfiguration.getInputPaths()) {
                System.out.println("\t" + inputPath);
            }
            System.out.println();
        }
        System.out.println("Output Path:" + windupConfiguration.getOutputDirectory());
        System.out.println();
        this.normalizePackagePrefixes(windupConfiguration);
        try {
            ConsoleProgressMonitor progressMonitor = new ConsoleProgressMonitor();
            windupConfiguration.setProgressMonitor((WindupProgressMonitor)progressMonitor);
            this.getWindupProcessor().execute(windupConfiguration);
            Boolean skipReports = (Boolean)windupConfiguration.getOptionMap().get("skipReports");
            if (!skipReports.booleanValue()) {
                Path indexHtmlPath = windupConfiguration.getOutputDirectory().resolve("index.html").normalize().toAbsolutePath();
                System.out.println("Report created: " + indexHtmlPath + System.getProperty("line.separator") + "              Access it at this URL: " + indexHtmlPath.toUri());
            } else {
                System.out.println("Generating reports were disabled by option --skipReports");
                System.out.println("If using that option was unintentional, please run RHAMT again to generate reports.");
            }
        }
        catch (Exception e) {
            System.err.println("Execution failed due to: " + e.getMessage());
            e.printStackTrace();
        }
        this.deleteGraphDataUnlessInhibited(windupConfiguration, path);
    }

    private boolean validateInputAndOutputPath(Collection<Path> inputPaths, Path outputPath) {
        ValidationResult validationResult = OutputPathOption.validateInputsAndOutputPaths(inputPaths, (Path)outputPath);
        switch (validationResult.getLevel()) {
            case ERROR: {
                System.err.println("ERROR: " + validationResult.getMessage());
                return false;
            }
            case WARNING: {
                System.err.println("WARNING: " + validationResult.getMessage());
            }
        }
        return true;
    }

    private boolean validateOptionValues(Map<String, ConfigurationOption> options, Map<String, Object> optionValues) {
        for (Map.Entry<String, ConfigurationOption> optionEntry : options.entrySet()) {
            ConfigurationOption option = optionEntry.getValue();
            ValidationResult result = option.validate(optionValues.get(option.getName()));
            switch (result.getLevel()) {
                case ERROR: {
                    System.err.println("ERROR: " + result.getMessage());
                    return false;
                }
                case PROMPT_TO_CONTINUE: {
                    if (Bootstrap.prompt(result.getMessage(), result.getPromptDefault(), this.batchMode.get())) break;
                    return false;
                }
                case WARNING: {
                    System.err.println("WARNING: " + result.getMessage());
                    break;
                }
            }
        }
        return true;
    }

    private void setDefaultOutputPath(Map<String, Object> optionValues) {
        Iterable paths;
        if (!optionValues.containsKey("output") && (paths = (Iterable)optionValues.get("input")) != null && paths.iterator().hasNext()) {
            try {
                File canonicalInputFile = ((Path)paths.iterator().next()).toFile().getCanonicalFile();
                File outputFile = new File(canonicalInputFile.getParentFile(), canonicalInputFile.getName() + ".report");
                optionValues.put("output", outputFile);
            }
            catch (IOException e) {
                throw new WindupException("Failed to get canonical path for input file: " + ((Path)paths.iterator().next()).toFile());
            }
        }
    }

    private Object convertType(Class<?> type, String input) {
        if (Path.class.isAssignableFrom(type)) {
            return Paths.get(input, new String[0]);
        }
        if (File.class.isAssignableFrom(type)) {
            return new File(input);
        }
        if (Boolean.class.isAssignableFrom(type)) {
            return Boolean.valueOf(input);
        }
        if (String.class.isAssignableFrom(type)) {
            return input;
        }
        throw new RuntimeException("Internal Error! Unrecognized type " + type.getCanonicalName());
    }

    private boolean pathNotEmpty(File f) {
        if (f.exists() && !f.isDirectory()) {
            return true;
        }
        return f.isDirectory() && f.listFiles() != null && f.listFiles().length > 0;
    }

    private WindupProcessor getWindupProcessor() {
        return (WindupProcessor)this.furnace.getAddonRegistry(new AddonRepository[0]).getServices(WindupProcessor.class).get();
    }

    private GraphContextFactory getGraphContextFactory() {
        return (GraphContextFactory)this.furnace.getAddonRegistry(new AddonRepository[0]).getServices(GraphContextFactory.class).get();
    }

    private String getOptionName(String argument) {
        if (argument.startsWith("--")) {
            return argument.substring(2);
        }
        if (argument.startsWith("-")) {
            return argument.substring(1);
        }
        return null;
    }

    private void deleteGraphDataUnlessInhibited(WindupConfiguration windupConfiguration, Path graphPath) {
        Boolean keep = (Boolean)windupConfiguration.getOptionMap().get("keepWorkDirs");
        if (keep == null || !keep.booleanValue()) {
            log.info("Deleting graph directory (see --keepWorkDirs): " + graphPath.toFile().getPath());
            try {
                FileUtils.deleteDirectory((File)graphPath.toFile());
            }
            catch (IOException ex) {
                log.log(Level.WARNING, "Failed deleting graph directory: " + graphPath.toFile().getPath() + "\n\tDue to: " + ex.getMessage(), ex);
            }
        }
    }

    private static List<Path> expandMultiAppInputDirs(List<Path> input) {
        LinkedList<Path> expanded = new LinkedList<Path>();
        for (Path path : input) {
            if (Files.isRegularFile(path, new LinkOption[0])) {
                expanded.add(path);
                continue;
            }
            if (!Files.isDirectory(path, new LinkOption[0])) {
                log.warning("Neither a file or directory found in input: " + path.toString());
                continue;
            }
            try {
                DirectoryStream<Path> directoryStream = Files.newDirectoryStream(path);
                Throwable throwable = null;
                try {
                    for (Path subpath : directoryStream) {
                        expanded.add(subpath);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (directoryStream == null) continue;
                    if (throwable != null) {
                        try {
                            directoryStream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    directoryStream.close();
                }
            }
            catch (IOException e) {
                throw new WindupException("Failed to read directory contents of: " + path);
            }
        }
        return expanded;
    }

    private void setDefaultOptionsValues(Map<String, ConfigurationOption> options, Map<String, Object> optionValues) {
        for (Map.Entry<String, ConfigurationOption> option : options.entrySet()) {
            if (null != optionValues.get(option.getValue().getName())) continue;
            optionValues.put(option.getValue().getName(), option.getValue().getDefaultValue());
        }
    }

    private void normalizePackagePrefixes(WindupConfiguration windupConfiguration) {
        List<String> includePackages = (List<String>)windupConfiguration.getOptionValue("packages");
        includePackages = RunWindupCommand.normalizePackagePrefixes(includePackages);
        windupConfiguration.setOptionValue("packages", includePackages);
        List<String> excludePackages = (List<String>)windupConfiguration.getOptionValue("excludePackages");
        excludePackages = RunWindupCommand.normalizePackagePrefixes(excludePackages);
        windupConfiguration.setOptionValue("excludePackages", excludePackages);
    }

    private static List<String> normalizePackagePrefixes(List<String> packages) {
        if (packages == null) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>(packages.size());
        for (String pkg : packages) {
            if (pkg.endsWith(".*")) {
                System.out.println("Warning: removing the .* suffix from the package prefix: " + pkg);
            }
            result.add(StringUtils.removeEndIgnoreCase((String)pkg, (String)".*"));
        }
        return packages;
    }
}

