/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.bootstrap;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Logger;
import org.jboss.windup.exec.WindupProgressMonitor;

public class ConsoleProgressMonitor
implements WindupProgressMonitor {
    private static final Logger LOG = Logger.getLogger(ConsoleProgressMonitor.class.getName());
    private int totalWork;
    private int currentWork;
    private boolean cancelled;
    private static final DateFormat DATE_FORMATTER = new SimpleDateFormat("yyyy-MM-dd HH:mm");
    private static long lastFormatted = 0L;
    private static String lastFormattedString = "";

    public void beginTask(String name, int totalWork) {
        this.totalWork = totalWork;
        String message = String.format("%s [%d/%d] %s", ConsoleProgressMonitor.getCachedTime(), this.currentWork, totalWork, name);
        System.out.println(message);
        LOG.info(message);
    }

    public void done() {
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void setCancelled(boolean cancelled) {
        this.cancelled = cancelled;
    }

    public void setTaskName(String name) {
        String message = String.format("%s [%d/%d] \t", ConsoleProgressMonitor.getCachedTime(), this.currentWork, this.totalWork, name);
        System.out.println(message);
        LOG.info(message);
    }

    public void subTask(String subTask) {
        String message = String.format("%s [%d/%d] %s", ConsoleProgressMonitor.getCachedTime(), this.currentWork, this.totalWork, subTask);
        if (subTask.endsWith("\r")) {
            System.out.print(message);
        } else {
            System.out.println("\r" + message);
        }
        LOG.info(message);
    }

    public void worked(int work) {
        this.currentWork += work;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getCachedTime() {
        long now = System.currentTimeMillis();
        if (now > lastFormatted + 60000L) {
            Date date = new Date(now);
            DateFormat dateFormat = DATE_FORMATTER;
            synchronized (dateFormat) {
                String format = DATE_FORMATTER.format(date);
                lastFormatted = now;
                lastFormattedString = format;
            }
        }
        return lastFormattedString;
    }
}

