/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.bootstrap.help;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.dom.DOMDocument;
import org.dom4j.dom.DOMElement;
import org.dom4j.io.SAXReader;
import org.jboss.forge.furnace.Furnace;
import org.jboss.windup.bootstrap.help.OptionDescription;
import org.jboss.windup.config.ConfigurationOption;
import org.jboss.windup.exec.configuration.WindupConfiguration;
import org.jboss.windup.util.PathUtil;

public class Help {
    private static final String HELP = "help";
    private static final String OPTION = "option";
    private static final String NAME = "name";
    private static final String DESCRIPTION = "description";
    public static final String TYPE = "type";
    public static final String AVAILABLE_OPTIONS = "available-options";
    public static final String AVAILABLE_OPTION = "option";
    public static final String UI_TYPE = "ui-type";
    private static final String REQUIRED = "required";
    private List<OptionDescription> options = new ArrayList<OptionDescription>();

    public List<OptionDescription> getOptions() {
        return this.options;
    }

    private void addOption(OptionDescription optionDescription) {
        this.options.add(optionDescription);
    }

    private static File getDefaultFile() throws IOException {
        Path helpDirectory = PathUtil.getWindupHome().resolve("cache").resolve(HELP);
        if (!Files.exists(helpDirectory, new LinkOption[0])) {
            Files.createDirectories(helpDirectory, new FileAttribute[0]);
        }
        Path helpPath = helpDirectory.resolve("help.xml");
        return helpPath.toFile();
    }

    public static Help load() {
        Help result = new Help();
        try {
            Document doc = new SAXReader().read(Help.getDefaultFile());
            Iterator optionElementIterator = doc.getRootElement().elementIterator("option");
            while (optionElementIterator.hasNext()) {
                Element optionElement = (Element)optionElementIterator.next();
                String name = optionElement.attributeValue(NAME);
                String description = optionElement.element(DESCRIPTION).getTextTrim();
                String type = optionElement.element(TYPE).getTextTrim();
                String uiType = optionElement.element(UI_TYPE).getTextTrim();
                boolean required = Boolean.valueOf(optionElement.element(REQUIRED).getTextTrim());
                ArrayList<String> availableOptions = null;
                if (optionElement.element(AVAILABLE_OPTIONS) != null) {
                    availableOptions = new ArrayList<String>();
                    for (Element availableOption : optionElement.element(AVAILABLE_OPTIONS).elements("option")) {
                        availableOptions.add(availableOption.getTextTrim());
                    }
                }
                OptionDescription option = new OptionDescription(name, description, type, uiType, availableOptions, required);
                result.addOption(option);
            }
        }
        catch (IOException | DocumentException e) {
            System.err.println("WARNING: Failed to load detailed help information!");
        }
        return result;
    }

    public static void save(Furnace furnace) throws IOException {
        DOMDocument doc = new DOMDocument(new DOMElement(HELP));
        Iterable windupOptions = WindupConfiguration.getWindupConfigurationOptions((Furnace)furnace);
        for (ConfigurationOption option : windupOptions) {
            DOMElement optionElement = new DOMElement("option");
            optionElement.addAttribute(NAME, option.getName());
            DOMElement descriptionElement = new DOMElement(DESCRIPTION);
            descriptionElement.setText(option.getDescription());
            optionElement.add((Element)descriptionElement);
            DOMElement typeElement = new DOMElement(TYPE);
            typeElement.setText(option.getType().getSimpleName());
            optionElement.add((Element)typeElement);
            DOMElement uiTypeElement = new DOMElement(UI_TYPE);
            uiTypeElement.setText(option.getUIType().name());
            optionElement.add((Element)uiTypeElement);
            DOMElement availableOptionsElement = new DOMElement(AVAILABLE_OPTIONS);
            for (Object availableValueObject : option.getAvailableValues()) {
                if (availableValueObject == null) continue;
                DOMElement availableOption = new DOMElement("option");
                availableOption.setText(String.valueOf(availableValueObject));
                availableOptionsElement.add((Element)availableOption);
            }
            if (!availableOptionsElement.elements().isEmpty()) {
                optionElement.add((Element)availableOptionsElement);
            }
            DOMElement required = new DOMElement(REQUIRED);
            required.setText(Boolean.toString(option.isRequired()));
            optionElement.add((Element)required);
            doc.getRootElement().add((Element)optionElement);
        }
        try (FileWriter writer = new FileWriter(Help.getDefaultFile());){
            doc.write((Writer)writer);
        }
    }
}

