/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.windup.WindupEnvironment;
import org.jboss.windup.reporting.ReportEngine;

public class WindupMain {
    private static final Log LOG = LogFactory.getLog(WindupMain.class);
    private static final HelpFormatter HELP_FORMATTER = new HelpFormatter();
    private static final String WINDUP_COMMAND = "java -jar jboss-windup.jar";

    public static void main(String[] args) {
        PosixParser parser = new PosixParser();
        Options options = new Options();
        OptionBuilder.withArgName((String)"file / dir");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired();
        OptionBuilder.withDescription((String)"file to generate windup report (required)");
        Option input = OptionBuilder.create((String)"input");
        OptionBuilder.withArgName((String)"dir");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"directory where to generate windup report (required)");
        Option output = OptionBuilder.create((String)"output");
        OptionBuilder.withArgName((String)"string");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"client Java packages to target for inspection");
        Option javaPkgs = OptionBuilder.create((String)"javaPkgs");
        OptionBuilder.withArgName((String)"string");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"client Java packages to target for inspection");
        Option excludePkgs = OptionBuilder.create((String)"excludePkgs");
        OptionBuilder.withArgName((String)"string");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"log level for root logger (defaults to info)");
        Option logLevel = OptionBuilder.create((String)"logLevel");
        OptionBuilder.withArgName((String)"boolean");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"persist to file");
        Option captureLog = OptionBuilder.create((String)"captureLog");
        OptionBuilder.withArgName((String)"boolean");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"fetch version information from remote repository when not found");
        Option fetchRemote = OptionBuilder.create((String)"fetchRemote");
        OptionBuilder.withArgName((String)"string");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"target platform");
        Option targetPlatform = OptionBuilder.create((String)"targetPlatform");
        OptionBuilder.withArgName((String)"boolean");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"is running on source");
        Option isSource = OptionBuilder.create((String)"source");
        options.addOption(input);
        options.addOption(output);
        options.addOption(javaPkgs);
        options.addOption(logLevel);
        options.addOption(captureLog);
        options.addOption(fetchRemote);
        options.addOption(targetPlatform);
        options.addOption(excludePkgs);
        options.addOption(isSource);
        CommandLine line = null;
        try {
            line = parser.parse(options, args);
            WindupMain cm = new WindupMain();
            cm.processInput(line, options);
        }
        catch (ParseException exp) {
            LOG.error((Object)("Unexpected exception: " + exp.getMessage()), (Throwable)exp);
            HELP_FORMATTER.printHelp(WINDUP_COMMAND, options);
        }
    }

    public void processInput(CommandLine line, Options options) {
        try {
            if (line.getOptions().length < 1) {
                HELP_FORMATTER.printHelp(WINDUP_COMMAND, options);
            } else {
                WindupEnvironment settings = new WindupEnvironment();
                if (line.hasOption("javaPkgs")) {
                    settings.setPackageSignature(line.getOptionValue("javaPkgs"));
                }
                if (line.hasOption("excludePkgs")) {
                    settings.setExcludeSignature(line.getOptionValue("excludePkgs"));
                }
                if (line.hasOption("targetPlatform")) {
                    settings.setTargetPlatform(line.getOptionValue("targetPlatform"));
                }
                if (line.hasOption("fetchRemote")) {
                    settings.setFetchRemote(line.getOptionValue("fetchRemote"));
                }
                String inputLocation = line.getOptionValue("input");
                inputLocation = StringUtils.trim((String)inputLocation);
                File inputPath = new File(inputLocation);
                File outputPath = null;
                String outputLocation = line.getOptionValue("output");
                if (StringUtils.isNotBlank((String)(outputLocation = StringUtils.trim((String)outputLocation)))) {
                    outputPath = new File(outputLocation);
                }
                boolean isSource = false;
                if (BooleanUtils.toBoolean((String)line.getOptionValue("source"))) {
                    isSource = true;
                }
                settings.setSource(isSource);
                boolean captureLog = false;
                if (BooleanUtils.toBoolean((String)line.getOptionValue("captureLog"))) {
                    captureLog = true;
                }
                String logLevel = line.getOptionValue("logLevel");
                logLevel = StringUtils.trim((String)logLevel);
                settings.setCaptureLog(captureLog);
                settings.setLogLevel(logLevel);
                ReportEngine engine = new ReportEngine(settings);
                engine.process(inputPath, outputPath);
            }
        }
        catch (FileNotFoundException e) {
            LOG.error((Object)("Input does not exist:" + e.getMessage()), (Throwable)e);
            HELP_FORMATTER.printHelp(WINDUP_COMMAND, options);
        }
        catch (IOException e) {
            LOG.error((Object)("Exception while writing report: " + e.getMessage()), (Throwable)e);
            HELP_FORMATTER.printHelp(WINDUP_COMMAND, options);
        }
    }
}

