/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.rexster.client;

import com.tinkerpop.rexster.client.RexProException;
import com.tinkerpop.rexster.protocol.msg.ErrorResponseMessage;
import com.tinkerpop.rexster.protocol.msg.RexProMessage;
import com.tinkerpop.rexster.protocol.msg.ScriptRequestMessage;
import com.tinkerpop.rexster.protocol.msg.ScriptResponseMessage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.apache.commons.configuration.Configuration;
import org.apache.log4j.Logger;
import org.glassfish.grizzly.GrizzlyFuture;
import org.glassfish.grizzly.nio.NIOConnection;
import org.glassfish.grizzly.nio.transport.TCPNIOTransport;

public class RexsterClient {
    private static final Logger logger = Logger.getLogger(RexsterClient.class);
    private final NIOConnection[] connections;
    private int currentConnection = 0;
    private final int timeoutConnection;
    private final int timeoutWrite;
    private final int timeoutRead;
    private final int retries;
    private final int waitBetweenRetries;
    private final int asyncWriteQueueMaxBytes;
    private final String language;
    private final String graphName;
    private final String graphObjName;
    private final boolean transaction;
    private volatile boolean closed = false;
    private final TCPNIOTransport transport;
    private final String[] hosts;
    private final int port;
    private byte serializer;
    protected static ConcurrentHashMap<UUID, ArrayBlockingQueue<Object>> responses = new ConcurrentHashMap();

    protected RexsterClient(Configuration configuration, TCPNIOTransport transport) {
        this.timeoutConnection = configuration.getInt("timeout-connection-ms");
        this.timeoutRead = configuration.getInt("timeout-read-ms");
        this.timeoutWrite = configuration.getInt("timeout-write-ms");
        this.retries = configuration.getInt("message-retry-count");
        this.waitBetweenRetries = configuration.getInt("message-retry-wait-ms");
        this.asyncWriteQueueMaxBytes = configuration.getInt("max-async-write-queue-size");
        this.language = configuration.getString("language");
        this.graphName = configuration.getString("graph-name");
        this.graphObjName = configuration.getString("graph-obj-name");
        this.transaction = configuration.getBoolean("transaction");
        this.transport = transport;
        this.port = configuration.getInt("port");
        this.hosts = configuration.getStringArray("hostname");
        this.serializer = configuration.getByte("serializer", (byte)0);
        this.connections = new NIOConnection[this.hosts.length];
    }

    public RexProMessage execute(RexProMessage rawMessage) throws RexProException, IOException {
        Object resultMessage;
        ArrayBlockingQueue responseQueue = new ArrayBlockingQueue(1);
        UUID requestId = rawMessage.requestAsUUID();
        responses.put(requestId, responseQueue);
        try {
            this.sendRequest(rawMessage);
        }
        catch (Throwable t) {
            throw new IOException(t);
        }
        try {
            long beginTime = System.currentTimeMillis();
            resultMessage = responseQueue.poll((long)this.timeoutRead - (System.currentTimeMillis() - beginTime), TimeUnit.MILLISECONDS);
        }
        catch (Exception ex) {
            responses.remove(requestId);
            throw new IOException(ex);
        }
        responses.remove(requestId);
        if (resultMessage == null) {
            throw new IOException(String.format("Message received response timeoutConnection (%s s)", this.timeoutConnection));
        }
        if (!(resultMessage instanceof RexProMessage)) {
            logger.error((Object)String.format("Rexster returned a message of type [%s]", resultMessage.getClass().getName()));
            throw new RexProException("RexsterClient doesn't support the message type returned.");
        }
        return (RexProMessage)resultMessage;
    }

    public <T> List<T> execute(String script) throws RexProException, IOException {
        return this.execute(script, null);
    }

    public <T> List<T> execute(String script, Map<String, Object> scriptArgs) throws RexProException, IOException {
        Object resultMessage;
        ArrayBlockingQueue responseQueue = new ArrayBlockingQueue(1);
        ScriptRequestMessage msgToSend = this.createNoSessionScriptRequest(script, scriptArgs);
        UUID requestId = msgToSend.requestAsUUID();
        responses.put(requestId, responseQueue);
        try {
            this.sendRequest(msgToSend);
        }
        catch (Throwable t) {
            throw new IOException(t);
        }
        try {
            long beginTime = System.currentTimeMillis();
            resultMessage = responseQueue.poll((long)this.timeoutRead - (System.currentTimeMillis() - beginTime), TimeUnit.MILLISECONDS);
        }
        catch (Exception ex) {
            responses.remove(requestId);
            throw new IOException(ex);
        }
        responses.remove(requestId);
        if (resultMessage == null) {
            throw new IOException(String.format("Message received response timeoutConnection (%s s)", this.timeoutConnection));
        }
        if (resultMessage instanceof ScriptResponseMessage) {
            ScriptResponseMessage msg = (ScriptResponseMessage)resultMessage;
            ArrayList<Object> results = new ArrayList<Object>();
            if (msg.Results.get() instanceof Iterable) {
                Iterator itty = ((Iterable)msg.Results.get()).iterator();
                while (itty.hasNext()) {
                    results.add(itty.next());
                }
            } else {
                results.add(msg.Results.get());
            }
            return results;
        }
        if (resultMessage instanceof ScriptResponseMessage) {
            ScriptResponseMessage msg = (ScriptResponseMessage)resultMessage;
            ArrayList<String> results = new ArrayList<String>();
            for (String line : (String[])msg.Results.get()) {
                results.add(line);
            }
            return results;
        }
        if (resultMessage instanceof ErrorResponseMessage) {
            logger.warn((Object)String.format("Rexster returned an error response for [%s] with params [%s]", script, scriptArgs));
            throw new RexProException(((ErrorResponseMessage)resultMessage).ErrorMessage);
        }
        logger.error((Object)String.format("Rexster returned a message of type [%s]", resultMessage.getClass().getName()));
        throw new RexProException("RexsterClient doesn't support the message type returned.");
    }

    static void putResponse(RexProMessage response) throws Exception {
        UUID requestId = response.requestAsUUID();
        if (!responses.containsKey(requestId)) {
            logger.warn((Object)String.format("No queue found in the response map: %s", requestId));
            return;
        }
        try {
            ArrayBlockingQueue<Object> queue = responses.get(requestId);
            if (queue != null) {
                queue.put(response);
            } else {
                logger.error((Object)String.format("No queue found in the response map: %s", requestId));
            }
        }
        catch (InterruptedException e) {
            logger.error((Object)"Error reading the queue in the response map.", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NIOConnection nextConnection() {
        NIOConnection[] nIOConnectionArray = this.connections;
        synchronized (this.connections) {
            if (this.currentConnection == Integer.MAX_VALUE) {
                this.currentConnection = 0;
            }
            this.currentConnection = (this.currentConnection + 1) % this.hosts.length;
            NIOConnection connection = this.connections[this.currentConnection];
            if (connection == null || !connection.isOpen()) {
                this.connections[this.currentConnection] = this.openConnection(this.hosts[this.currentConnection]);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.connections[this.currentConnection];
        }
    }

    private NIOConnection openConnection(String host) {
        try {
            GrizzlyFuture future = this.transport.connect(host, this.port);
            NIOConnection connection = (NIOConnection)future.get(this.timeoutConnection, TimeUnit.MILLISECONDS);
            connection.setMaxAsyncWriteQueueSize(this.asyncWriteQueueMaxBytes);
            return connection;
        }
        catch (Exception e) {
            return null;
        }
    }

    private void sendRequest(RexProMessage toSend) throws Exception {
        boolean sent = false;
        int tries = this.retries;
        while (!this.closed && tries > 0 && !sent) {
            try {
                NIOConnection connection = this.nextConnection();
                if (connection != null && connection.isOpen()) {
                    GrizzlyFuture future = connection.write((Object)new MessageContainer(this.serializer, toSend));
                    future.get((long)this.timeoutWrite, TimeUnit.MILLISECONDS);
                    sent = true;
                    continue;
                }
                throw new Exception("Connection was not open.  Ensure that Rexster Server is running/reachable.");
            }
            catch (Exception ex) {
                logger.error((Object)String.format("Request failed.  Retry attempt [%s]", this.retries - tries + 1), (Throwable)ex);
                UUID requestId = toSend.requestAsUUID();
                if (--tries == 0) {
                    responses.remove(requestId);
                    continue;
                }
                Thread.sleep(this.waitBetweenRetries);
            }
        }
        if (!sent) {
            throw new Exception(this.closed ? "The close() method was called on the client and no more messages can be sent" : "Could not send message.");
        }
    }

    public void close() throws IOException {
        responses.clear();
        this.closed = true;
        for (NIOConnection c : this.connections) {
            if (null == c) continue;
            c.closeSilently();
        }
    }

    private ScriptRequestMessage createNoSessionScriptRequest(String script, Map<String, Object> scriptArguments) throws IOException, RexProException {
        ScriptRequestMessage scriptMessage = new ScriptRequestMessage();
        scriptMessage.Script = script;
        scriptMessage.LanguageName = this.language;
        scriptMessage.metaSetGraphName(this.graphName);
        scriptMessage.metaSetGraphObjName(this.graphObjName);
        scriptMessage.metaSetInSession(false);
        scriptMessage.metaSetTransaction(this.transaction);
        scriptMessage.setRequestAsUUID(UUID.randomUUID());
        scriptMessage.validateMetaData();
        if (scriptArguments != null) {
            scriptMessage.Bindings.putAll((Map<? extends String, ? extends Object>)scriptArguments);
        }
        return scriptMessage;
    }

    public byte getSerializer() {
        return this.serializer;
    }

    public void setSerializer(byte serializer) {
        this.serializer = serializer;
    }

    static class MessageContainer {
        private byte serializer;
        private RexProMessage message;

        MessageContainer(byte serializer, RexProMessage message) {
            this.serializer = serializer;
            this.message = message;
        }

        byte getSerializer() {
            return this.serializer;
        }

        RexProMessage getMessage() {
            return this.message;
        }
    }
}

