/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.rexster.protocol.serializer.msgpack.templates.messages;

import com.tinkerpop.rexster.protocol.msg.SessionResponseMessage;
import com.tinkerpop.rexster.protocol.serializer.msgpack.templates.messages.RexProMessageTemplate;
import java.io.IOException;
import org.msgpack.packer.Packer;
import org.msgpack.unpacker.Unpacker;

public class SessionResponseMessageTemplate
extends RexProMessageTemplate<SessionResponseMessage> {
    @Override
    protected int messageArraySize() {
        return super.messageArraySize() + 1;
    }

    @Override
    protected SessionResponseMessage instantiateMessage() {
        return new SessionResponseMessage();
    }

    @Override
    protected void writeMessageArray(Packer pk, SessionResponseMessage msg) throws IOException {
        super.writeMessageArray(pk, msg);
        pk.writeArrayBegin(msg.Languages.length);
        for (String lang : msg.Languages) {
            pk.write(lang);
        }
        pk.writeArrayEnd();
    }

    @Override
    protected SessionResponseMessage readMessageArray(Unpacker un, SessionResponseMessage msg) throws IOException {
        SessionResponseMessage message = super.readMessageArray(un, msg);
        if (!un.trySkipNil()) {
            message.Languages = new String[un.readArrayBegin()];
            for (int i = 0; i < message.Languages.length; ++i) {
                message.Languages[i] = un.readString();
            }
            un.readArrayEnd();
        }
        return message;
    }
}

