/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.config.parameters;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.forge.furnace.util.Iterators;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.Variables;
import org.jboss.windup.config.condition.GraphCondition;
import org.jboss.windup.config.parameters.FrameContext;
import org.jboss.windup.config.parameters.FrameCreationContext;
import org.jboss.windup.graph.model.WindupVertexFrame;
import org.jboss.windup.util.exception.WindupException;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.param.DefaultParameterStore;
import org.ocpsoft.rewrite.param.DefaultParameterValueStore;
import org.ocpsoft.rewrite.param.ParameterStore;
import org.ocpsoft.rewrite.param.ParameterValueStore;
import org.ocpsoft.rewrite.param.Parameterized;

public abstract class ParameterizedGraphCondition
extends GraphCondition
implements Parameterized {
    static final String PARAM_VALUE_STORE_MAP_KEY = ParameterizedGraphCondition.class.getName() + "_parameterValueStoreMap";
    static final String RESULT_VALUE_STORE_MAP_KEY = ParameterizedGraphCondition.class.getName() + "_resultParameterValueStoreMap";

    protected abstract String getVarname();

    protected abstract boolean evaluateWithValueStore(GraphRewrite var1, EvaluationContext var2, FrameContext var3);

    protected abstract boolean evaluateAndPopulateValueStores(GraphRewrite var1, EvaluationContext var2, FrameCreationContext var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean evaluate(GraphRewrite event, final EvaluationContext context) {
        final Map<ParameterValueStore, Map<String, Iterable<? extends WindupVertexFrame>>> valueStores = ParameterizedGraphCondition.getParameterValueStoreMap(context);
        Map<WindupVertexFrame, ParameterValueStore> resultSetStores = ParameterizedGraphCondition.getResultValueStoreMap(context);
        ParameterValueStore previousValueStore = DefaultParameterValueStore.getInstance((EvaluationContext)context);
        if (valueStores.isEmpty()) {
            FrameCreationContext frameCreationContext = new FrameCreationContext(){
                private ParameterValueStore current;
                private DefaultParameterValueStore original;
                {
                    this.original = (DefaultParameterValueStore)DefaultParameterValueStore.getInstance((EvaluationContext)context);
                }

                @Override
                public void beginNew(Map<String, Iterable<? extends WindupVertexFrame>> variables) {
                    ParameterValueStore clone;
                    this.current = clone = this.clone(this.original);
                    context.put(ParameterValueStore.class, (Object)clone);
                    if (variables == null) {
                        variables = new LinkedHashMap<String, Iterable<? extends WindupVertexFrame>>();
                    }
                    valueStores.put(clone, variables);
                }

                private ParameterValueStore clone(DefaultParameterValueStore instance) {
                    DefaultParameterValueStore clone = new DefaultParameterValueStore(instance);
                    return clone;
                }

                @Override
                public void rollback() {
                    if (this.current != null) {
                        valueStores.remove(this.current);
                    }
                }
            };
            try {
                boolean bl = this.evaluateAndPopulateValueStores(event, context, frameCreationContext);
                return bl;
            }
            finally {
                for (Map.Entry<ParameterValueStore, Map<String, Iterable<? extends WindupVertexFrame>>> entry : valueStores.entrySet()) {
                    ParameterValueStore valueStore = entry.getKey();
                    Map<String, Iterable<? extends WindupVertexFrame>> layer = entry.getValue();
                    if (layer == null) {
                        throw new WindupException("Value store with no associated variables frame. This should not happen");
                    }
                    Iterable<? extends WindupVertexFrame> variable = layer.get(this.getVarname());
                    if (variable == null) continue;
                    for (WindupVertexFrame windupVertexFrame : variable) {
                        ParameterValueStore last = resultSetStores.put(windupVertexFrame, valueStore);
                        if (last == null) continue;
                        System.out.println("DOES THIS STILL HAPPEN?");
                    }
                }
            }
        }
        LinkedHashSet resultSet = new LinkedHashSet();
        boolean result = false;
        DefaultParameterValueStore original = (DefaultParameterValueStore)DefaultParameterValueStore.getInstance((EvaluationContext)context);
        for (Map.Entry<ParameterValueStore, Map<String, Iterable<? extends WindupVertexFrame>>> entry : valueStores.entrySet()) {
            ParameterValueStore valueStore = entry.getKey();
            ParameterStore store = DefaultParameterStore.getInstance((EvaluationContext)context);
            Map<String, Iterable<? extends WindupVertexFrame>> variables = entry.getValue();
            try {
                Variables.instance(event).push(variables);
                final AtomicBoolean atomicBoolean = new AtomicBoolean(false);
                FrameContext frameContext = new FrameContext(){

                    @Override
                    public void reject() {
                        atomicBoolean.set(true);
                    }
                };
                try {
                    context.put(ParameterValueStore.class, (Object)valueStore);
                    if (this.evaluateWithValueStore(event, context, frameContext)) {
                        result = true;
                    }
                    if (!atomicBoolean.get()) continue;
                    valueStores.remove(valueStore);
                }
                finally {
                    context.put(ParameterValueStore.class, (Object)original);
                }
            }
            finally {
                Iterable<? extends WindupVertexFrame> iterable = Variables.instance(event).findVariable(this.getVarname());
                if (iterable != null) {
                    resultSet.addAll(Iterators.asSet(iterable));
                    for (WindupVertexFrame windupVertexFrame : iterable) {
                        ParameterValueStore last = resultSetStores.put(windupVertexFrame, valueStore);
                        if (last == null) continue;
                    }
                }
                Variables.instance(event).pop();
            }
        }
        Variables.instance(event).setVariable(this.getVarname(), resultSet);
        boolean bl = result;
        return bl;
        finally {
            context.put(ParameterValueStore.class, (Object)previousValueStore);
            context.put((Object)PARAM_VALUE_STORE_MAP_KEY, valueStores);
            context.put((Object)RESULT_VALUE_STORE_MAP_KEY, resultSetStores);
        }
    }

    static Map<ParameterValueStore, Map<String, Iterable<? extends WindupVertexFrame>>> getParameterValueStoreMap(EvaluationContext context) {
        ConcurrentHashMap cachedStores = (ConcurrentHashMap)context.get((Object)PARAM_VALUE_STORE_MAP_KEY);
        ConcurrentHashMap valueStores = cachedStores;
        if (valueStores == null) {
            valueStores = new ConcurrentHashMap();
        }
        return valueStores;
    }

    static Map<WindupVertexFrame, ParameterValueStore> getResultValueStoreMap(EvaluationContext context) {
        LinkedHashMap result = (LinkedHashMap)context.get((Object)RESULT_VALUE_STORE_MAP_KEY);
        if (result == null) {
            result = new LinkedHashMap();
        }
        return result;
    }
}

