/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.rexster;

import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Graph;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.rexster.BaseResource;
import com.tinkerpop.rexster.RexsterApplicationGraph;
import com.tinkerpop.rexster.RexsterResourceContext;
import com.tinkerpop.rexster.extension.ExtensionDefinition;
import com.tinkerpop.rexster.extension.ExtensionDescriptor;
import com.tinkerpop.rexster.extension.ExtensionMethod;
import com.tinkerpop.rexster.extension.ExtensionNaming;
import com.tinkerpop.rexster.extension.ExtensionPoint;
import com.tinkerpop.rexster.extension.ExtensionRequestParameter;
import com.tinkerpop.rexster.extension.ExtensionResponse;
import com.tinkerpop.rexster.extension.ExtensionSegmentSet;
import com.tinkerpop.rexster.extension.HttpMethod;
import com.tinkerpop.rexster.extension.RexsterContext;
import com.tinkerpop.rexster.extension.RexsterExtension;
import com.tinkerpop.rexster.server.RexsterApplication;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import org.apache.log4j.Logger;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public abstract class AbstractSubResource
extends BaseResource {
    private static final Logger logger = Logger.getLogger(AbstractSubResource.class);
    protected static final Map<ExtensionSegmentSet, List<RexsterExtension>> extensionCache = new HashMap<ExtensionSegmentSet, List<RexsterExtension>>();

    protected AbstractSubResource(RexsterApplication ra) {
        super(ra);
        try {
            this.resultObject.put("version", (Object)"2.5.0");
        }
        catch (JSONException ex) {
            logger.error((Object)ex);
            JSONObject error = this.generateErrorObjectJsonFail(ex);
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)error).build());
        }
    }

    public RexsterApplicationGraph getRexsterApplicationGraph(String graphName) {
        RexsterApplicationGraph rag = this.getRexsterApplication().getApplicationGraph(graphName);
        if (rag == null) {
            if (!graphName.equals("favicon.ico")) {
                logger.info((Object)("Request for a non-configured graph [" + graphName + "]"));
            }
            JSONObject error = this.generateErrorObject("Graph [" + graphName + "] could not be found");
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)error).build());
        }
        return rag;
    }

    protected static List<RexsterExtension> findExtensionClasses(ExtensionSegmentSet extensionSegmentSet) {
        List<RexsterExtension> extensionsForSegmentSet = extensionCache.get(extensionSegmentSet);
        if (extensionsForSegmentSet == null) {
            ServiceLoader<RexsterExtension> extensions = ServiceLoader.load(RexsterExtension.class);
            extensionsForSegmentSet = new ArrayList<RexsterExtension>();
            for (RexsterExtension extension : extensions) {
                Class<?> clazz = extension.getClass();
                ExtensionNaming extensionNaming = clazz.getAnnotation(ExtensionNaming.class);
                String currentExtensionNamespace = "g";
                String currentExtensionName = clazz.getName();
                if (extensionNaming != null) {
                    if (extensionNaming.name() != null && !extensionNaming.name().isEmpty()) {
                        currentExtensionName = extensionNaming.name();
                    }
                    if (extensionNaming.namespace() != null && !extensionNaming.namespace().isEmpty()) {
                        currentExtensionNamespace = extensionNaming.namespace();
                    }
                }
                if (!extensionSegmentSet.getNamespace().equals(currentExtensionNamespace) || !extensionSegmentSet.getExtension().equals(currentExtensionName)) continue;
                extensionsForSegmentSet.add(extension);
            }
            if (extensionsForSegmentSet.size() == 0) {
                extensionsForSegmentSet = null;
                extensionCache.put(extensionSegmentSet, null);
            } else {
                extensionCache.put(extensionSegmentSet, extensionsForSegmentSet);
            }
        }
        return extensionsForSegmentSet;
    }

    protected ExtensionSegmentSet parseUriForExtensionSegment(String graphName, ExtensionPoint extensionPoint) {
        ExtensionSegmentSet extensionSegmentSet = new ExtensionSegmentSet(this.uriInfo, extensionPoint);
        if (!extensionSegmentSet.isValidFormat()) {
            logger.error((Object)("Tried to parse the extension segments but they appear invalid: " + extensionSegmentSet));
            JSONObject error = this.generateErrorObject("The [" + extensionSegmentSet + "] extension appears invalid for [" + graphName + "]");
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)error).build());
        }
        return extensionSegmentSet;
    }

    protected static ExtensionMethod findExtensionMethod(List<RexsterExtension> rexsterExtensions, ExtensionPoint extensionPoint, String extensionAction, HttpMethod httpMethodRequested) {
        ExtensionMethod methodToCall = null;
        block0: for (RexsterExtension rexsterExtension : rexsterExtensions) {
            ExtensionDescriptor extensionDescriptor;
            ExtensionDefinition extensionDefinition;
            Method[] methods;
            Class<?> rexsterExtensionClass = rexsterExtension.getClass();
            for (Method method : methods = rexsterExtensionClass.getMethods()) {
                extensionDefinition = method.getAnnotation(ExtensionDefinition.class);
                extensionDescriptor = method.getAnnotation(ExtensionDescriptor.class);
                if (extensionDefinition == null || extensionDefinition.extensionPoint() != extensionPoint || extensionDefinition.method() != HttpMethod.ANY && extensionDefinition.method() != httpMethodRequested || (extensionAction.isEmpty() || !extensionDefinition.path().equals(extensionAction)) && (!extensionAction.isEmpty() || !extensionDefinition.path().isEmpty())) continue;
                methodToCall = new ExtensionMethod(method, extensionDefinition, extensionDescriptor, rexsterExtension);
                break;
            }
            if (methodToCall != null) continue;
            for (Method method : methods) {
                extensionDefinition = method.getAnnotation(ExtensionDefinition.class);
                extensionDescriptor = method.getAnnotation(ExtensionDescriptor.class);
                if (extensionDefinition == null || extensionDefinition.extensionPoint() != extensionPoint || extensionDefinition.method() != HttpMethod.ANY && extensionDefinition.method() != httpMethodRequested || extensionAction.isEmpty() || !extensionDefinition.path().isEmpty()) continue;
                methodToCall = new ExtensionMethod(method, extensionDefinition, extensionDescriptor, rexsterExtension);
                continue block0;
            }
        }
        return methodToCall;
    }

    protected Object invokeExtension(RexsterApplicationGraph rexsterApplicationGraph, ExtensionMethod methodToCall) throws IllegalAccessException, InvocationTargetException {
        return this.invokeExtension(rexsterApplicationGraph, methodToCall, null, null);
    }

    protected Object invokeExtension(RexsterApplicationGraph rexsterApplicationGraph, ExtensionMethod methodToCall, Vertex vertexContext) throws IllegalAccessException, InvocationTargetException {
        return this.invokeExtension(rexsterApplicationGraph, methodToCall, null, vertexContext);
    }

    protected Object invokeExtension(RexsterApplicationGraph rexsterApplicationGraph, ExtensionMethod methodToCall, Edge edgeContext) throws IllegalAccessException, InvocationTargetException {
        return this.invokeExtension(rexsterApplicationGraph, methodToCall, edgeContext, null);
    }

    protected Object invokeExtension(RexsterApplicationGraph rexsterApplicationGraph, ExtensionMethod methodToCall, Edge edgeContext, Vertex vertexContext) throws IllegalAccessException, InvocationTargetException {
        RexsterExtension rexsterExtension = methodToCall.getRexsterExtension();
        Method method = methodToCall.getMethod();
        RexsterResourceContext rexsterResourceContext = new RexsterResourceContext(rexsterApplicationGraph, this.uriInfo, this.httpServletRequest, this.getRequestObject(), this.getRequestObjectFlat(), methodToCall, this.securityContext, this.getRexsterApplication().getMetricRegistry());
        Annotation[][] parametersAnnotations = method.getParameterAnnotations();
        ArrayList<Object> methodToCallParams = new ArrayList<Object>();
        for (int ix = 0; ix < parametersAnnotations.length; ++ix) {
            Annotation[] annotation = parametersAnnotations[ix];
            Class<?>[] parameterTypes = method.getParameterTypes();
            if (annotation != null) {
                if (annotation[0] instanceof RexsterContext) {
                    if (parameterTypes[ix].equals(Graph.class)) {
                        methodToCallParams.add(rexsterApplicationGraph.getGraph());
                        continue;
                    }
                    if (parameterTypes[ix].equals(RexsterApplicationGraph.class)) {
                        methodToCallParams.add(rexsterApplicationGraph);
                        continue;
                    }
                    if (parameterTypes[ix].equals(ExtensionMethod.class)) {
                        methodToCallParams.add(methodToCall);
                        continue;
                    }
                    if (parameterTypes[ix].equals(UriInfo.class)) {
                        methodToCallParams.add(this.uriInfo);
                        continue;
                    }
                    if (parameterTypes[ix].equals(HttpServletRequest.class)) {
                        methodToCallParams.add(this.httpServletRequest);
                        continue;
                    }
                    if (parameterTypes[ix].equals(SecurityContext.class)) {
                        methodToCallParams.add(this.securityContext);
                        continue;
                    }
                    if (parameterTypes[ix].equals(RexsterResourceContext.class)) {
                        methodToCallParams.add(rexsterResourceContext);
                        continue;
                    }
                    if (parameterTypes[ix].equals(Edge.class)) {
                        methodToCallParams.add(edgeContext);
                        continue;
                    }
                    if (parameterTypes[ix].equals(Vertex.class)) {
                        methodToCallParams.add(vertexContext);
                        continue;
                    }
                    methodToCallParams.add(null);
                    continue;
                }
                if (annotation[0] instanceof ExtensionRequestParameter) {
                    ExtensionRequestParameter extensionRequestParameter = (ExtensionRequestParameter)annotation[0];
                    if (parameterTypes[ix].equals(String.class)) {
                        this.composeStringExtensionArgs(methodToCallParams, extensionRequestParameter);
                        continue;
                    }
                    if (parameterTypes[ix].equals(Integer.class)) {
                        this.composeIntegerExtensionArgs(methodToCallParams, extensionRequestParameter);
                        continue;
                    }
                    if (parameterTypes[ix].equals(Float.class)) {
                        this.composeFloatExtensionArgs(methodToCallParams, extensionRequestParameter);
                        continue;
                    }
                    if (parameterTypes[ix].equals(Double.class)) {
                        this.composeDoubleExtensionArgs(methodToCallParams, extensionRequestParameter);
                        continue;
                    }
                    if (parameterTypes[ix].equals(Long.class)) {
                        this.composeLongExtensionArgs(methodToCallParams, extensionRequestParameter);
                        continue;
                    }
                    if (parameterTypes[ix].equals(Boolean.class)) {
                        this.composeBooleanExtensionArgs(methodToCallParams, extensionRequestParameter);
                        continue;
                    }
                    if (parameterTypes[ix].equals(JSONObject.class)) {
                        this.composeJsonObjectExtensionArgs(methodToCallParams, extensionRequestParameter, methodToCall);
                        continue;
                    }
                    if (parameterTypes[ix].equals(JSONArray.class)) {
                        this.composeJsonArrayExtensionArgs(methodToCallParams, extensionRequestParameter, methodToCall);
                        continue;
                    }
                    methodToCallParams.add(null);
                    continue;
                }
                methodToCallParams.add(null);
                continue;
            }
            methodToCallParams.add(null);
        }
        return method.invoke((Object)rexsterExtension, methodToCallParams.toArray());
    }

    private void composeStringExtensionArgs(ArrayList<Object> methodToCallParams, ExtensionRequestParameter extensionRequestParameter) {
        String defaultValue = AbstractSubResource.getDefaultExtensionParameterValue(extensionRequestParameter);
        if (extensionRequestParameter.parseToJson()) {
            methodToCallParams.add(this.getRequestObject().optString(extensionRequestParameter.name(), defaultValue));
        } else {
            methodToCallParams.add(this.getRequestObjectFlat().optString(extensionRequestParameter.name(), defaultValue));
        }
    }

    private void composeJsonArrayExtensionArgs(ArrayList<Object> methodToCallParams, ExtensionRequestParameter extensionRequestParameter, ExtensionMethod methodToCall) {
        String defaultValue = AbstractSubResource.getDefaultExtensionParameterValue(extensionRequestParameter);
        JSONArray jsonToUse = extensionRequestParameter.parseToJson() ? this.getRequestObject().optJSONArray(extensionRequestParameter.name()) : this.getRequestObjectFlat().optJSONArray(extensionRequestParameter.name());
        if (jsonToUse == null && defaultValue != null) {
            try {
                jsonToUse = new JSONArray(defaultValue);
            }
            catch (JSONException jse) {
                logger.error((Object)String.format("Could not parse default JSON value for %s on %s: %s", extensionRequestParameter.name(), methodToCall.getExtensionDefinition().path(), defaultValue));
                throw new RuntimeException("Extension error. See log for details.");
            }
        }
        methodToCallParams.add(jsonToUse);
    }

    private void composeJsonObjectExtensionArgs(ArrayList<Object> methodToCallParams, ExtensionRequestParameter extensionRequestParameter, ExtensionMethod methodToCall) {
        String defaultValue = AbstractSubResource.getDefaultExtensionParameterValue(extensionRequestParameter);
        JSONObject jsonToUse = extensionRequestParameter.parseToJson() ? this.getRequestObject().optJSONObject(extensionRequestParameter.name()) : this.getRequestObjectFlat().optJSONObject(extensionRequestParameter.name());
        if (jsonToUse == null && defaultValue != null) {
            try {
                jsonToUse = new JSONObject(defaultValue);
            }
            catch (JSONException jse) {
                logger.error((Object)String.format("Could not parse default JSON value for %s on %s: %s", extensionRequestParameter.name(), methodToCall.getExtensionDefinition().path(), defaultValue));
                throw new RuntimeException("Extension error. See log for details.");
            }
        }
        methodToCallParams.add(jsonToUse);
    }

    private void composeBooleanExtensionArgs(ArrayList<Object> methodToCallParams, ExtensionRequestParameter extensionRequestParameter) {
        String defaultValue = AbstractSubResource.getDefaultExtensionParameterValue(extensionRequestParameter);
        if (this.getRequestObject().has(extensionRequestParameter.name())) {
            if (extensionRequestParameter.parseToJson()) {
                boolean booleanValue = this.getRequestObject().optBoolean(extensionRequestParameter.name());
                methodToCallParams.add(new Boolean(booleanValue));
            } else {
                boolean booleanValue = this.getRequestObjectFlat().optBoolean(extensionRequestParameter.name());
                methodToCallParams.add(new Boolean(booleanValue));
            }
        } else if (defaultValue != null) {
            methodToCallParams.add(Boolean.valueOf(defaultValue));
        } else {
            methodToCallParams.add(null);
        }
    }

    private void composeLongExtensionArgs(ArrayList<Object> methodToCallParams, ExtensionRequestParameter extensionRequestParameter) {
        String defaultValue = AbstractSubResource.getDefaultExtensionParameterValue(extensionRequestParameter);
        if (this.getRequestObject().has(extensionRequestParameter.name())) {
            if (extensionRequestParameter.parseToJson()) {
                long longValue = this.getRequestObject().optLong(extensionRequestParameter.name());
                methodToCallParams.add(new Long(longValue));
            } else {
                long longValue = this.getRequestObjectFlat().optLong(extensionRequestParameter.name());
                methodToCallParams.add(new Long(longValue));
            }
        } else if (defaultValue != null) {
            methodToCallParams.add(Long.valueOf(defaultValue));
        } else {
            methodToCallParams.add(null);
        }
    }

    private void composeDoubleExtensionArgs(ArrayList<Object> methodToCallParams, ExtensionRequestParameter extensionRequestParameter) {
        String defaultValue = AbstractSubResource.getDefaultExtensionParameterValue(extensionRequestParameter);
        if (this.getRequestObject().has(extensionRequestParameter.name())) {
            if (extensionRequestParameter.parseToJson()) {
                double doubleValue = this.getRequestObject().optDouble(extensionRequestParameter.name());
                methodToCallParams.add(new Double(doubleValue));
            } else {
                double doubleValue = this.getRequestObjectFlat().optDouble(extensionRequestParameter.name());
                methodToCallParams.add(new Double(doubleValue));
            }
        } else if (defaultValue != null) {
            methodToCallParams.add(Double.valueOf(defaultValue));
        } else {
            methodToCallParams.add(null);
        }
    }

    private void composeFloatExtensionArgs(ArrayList<Object> methodToCallParams, ExtensionRequestParameter extensionRequestParameter) {
        String defaultValue = AbstractSubResource.getDefaultExtensionParameterValue(extensionRequestParameter);
        if (this.getRequestObject().has(extensionRequestParameter.name())) {
            if (extensionRequestParameter.parseToJson()) {
                float floatValue = (float)this.getRequestObject().optDouble(extensionRequestParameter.name());
                methodToCallParams.add(new Float(floatValue));
            } else {
                float floatValue = (float)this.getRequestObjectFlat().optDouble(extensionRequestParameter.name());
                methodToCallParams.add(new Float(floatValue));
            }
        } else if (defaultValue != null) {
            methodToCallParams.add(Float.valueOf(defaultValue));
        } else {
            methodToCallParams.add(null);
        }
    }

    private void composeIntegerExtensionArgs(ArrayList<Object> methodToCallParams, ExtensionRequestParameter extensionRequestParameter) {
        String defaultValue = AbstractSubResource.getDefaultExtensionParameterValue(extensionRequestParameter);
        if (this.getRequestObject().has(extensionRequestParameter.name())) {
            if (extensionRequestParameter.parseToJson()) {
                int intValue = this.getRequestObject().optInt(extensionRequestParameter.name());
                methodToCallParams.add(intValue);
            } else {
                int intValue = this.getRequestObjectFlat().optInt(extensionRequestParameter.name());
                methodToCallParams.add(intValue);
            }
        } else if (defaultValue != null) {
            methodToCallParams.add(Integer.valueOf(defaultValue));
        } else {
            methodToCallParams.add(null);
        }
    }

    private static String getDefaultExtensionParameterValue(ExtensionRequestParameter extensionRequestParameter) {
        return extensionRequestParameter.defaultValue().length == 0 ? null : extensionRequestParameter.defaultValue()[0];
    }

    protected ExtensionResponse tryAppendRexsterAttributesIfJson(ExtensionResponse extResponse, ExtensionMethod methodToCall, String mediaType) {
        JSONObject entity;
        Object obj;
        ExtensionResponse newExtensionResponse = extResponse;
        if (mediaType.equals("application/json") && methodToCall.getExtensionDefinition().tryIncludeRexsterAttributes() && (obj = extResponse.getJerseyResponse().getEntity()) instanceof JSONObject && (entity = (JSONObject)obj) != null) {
            try {
                entity.put("version", (Object)"2.5.0");
                entity.put("queryTime", this.sh.stopWatch());
            }
            catch (JSONException jsonException) {
                logger.error((Object)"Couldn't add Rexster attributes to response for an extension.");
            }
            newExtensionResponse = new ExtensionResponse(Response.fromResponse((Response)extResponse.getJerseyResponse()).entity((Object)entity).build());
        }
        return newExtensionResponse;
    }
}

