/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.rexster;

import com.codahale.metrics.annotation.Timed;
import com.tinkerpop.rexster.BaseResource;
import com.tinkerpop.rexster.extension.HttpMethod;
import com.tinkerpop.rexster.server.RexsterApplication;
import java.util.Collection;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.ws.rs.GET;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

@Path(value="/graphs")
@Produces(value={"application/json", "application/vnd.rexster-v1+json", "application/vnd.rexster-typed-v1+json"})
public class RexsterResource
extends BaseResource {
    @Context
    public ServletContext servletCtx;

    public RexsterResource() {
        super(null);
    }

    public RexsterResource(RexsterApplication ra) {
        super(ra);
    }

    @OPTIONS
    public Response optionsRexsterRoot() {
        return this.buildOptionsResponse(HttpMethod.GET.toString());
    }

    @GET
    @Timed(name="http.rest.graphs.collection.get", absolute=true)
    public Response getRexsterRoot() {
        try {
            Set graphNames = this.getRexsterApplication().getGraphNames();
            JSONArray jsonArrayNames = new JSONArray((Collection)graphNames);
            this.resultObject.put("name", (Object)"Rexster: A Graph Server");
            this.resultObject.put("graphs", (Object)jsonArrayNames);
            this.resultObject.put("queryTime", this.sh.stopWatch());
            this.resultObject.put("upTime", (Object)this.getTimeAlive());
            return Response.ok((Object)this.resultObject).build();
        }
        catch (JSONException ex) {
            JSONObject error = this.generateErrorObject(ex.getMessage());
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)error).build());
        }
    }
}

