/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.rexster.filter;

import com.sun.jersey.core.util.Base64;
import com.sun.jersey.spi.container.ContainerRequest;
import com.sun.jersey.spi.container.ContainerRequestFilter;
import com.tinkerpop.rexster.protocol.msg.ErrorResponseMessage;
import com.tinkerpop.rexster.protocol.msg.RexProMessage;
import com.tinkerpop.rexster.protocol.msg.SessionRequestMessage;
import com.tinkerpop.rexster.protocol.server.RexProRequest;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.security.Principal;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.log4j.Logger;
import org.codehaus.jettison.json.JSONObject;
import org.glassfish.grizzly.filterchain.BaseFilter;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.NextAction;

public abstract class AbstractSecurityFilter
extends BaseFilter
implements ContainerRequestFilter {
    private static final Logger logger = Logger.getLogger(AbstractSecurityFilter.class);
    @Context
    protected UriInfo uriInfo;
    @Context
    protected ServletConfig servletConfig;
    @Context
    protected HttpServletRequest httpServletRequest;
    @Context
    protected HttpServletResponse httpServletResponse;
    private boolean isConfigured = false;

    public AbstractSecurityFilter() {
    }

    public AbstractSecurityFilter(XMLConfiguration configuration) {
        this.configure(configuration);
        this.isConfigured = true;
    }

    public abstract boolean authenticate(String var1, String var2);

    public abstract void configure(XMLConfiguration var1);

    public abstract String getName();

    public NextAction handleRead(FilterChainContext ctx) throws IOException {
        String password;
        String username;
        SessionRequestMessage specificMessage;
        RexProRequest request = (RexProRequest)ctx.getMessage();
        request.process();
        RexProMessage message = request.getRequestMessage();
        if (message instanceof SessionRequestMessage && !message.hasSession() && !(specificMessage = (SessionRequestMessage)message).metaGetKillSession().booleanValue() && !this.authenticate(username = specificMessage.Username, password = specificMessage.Password)) {
            ErrorResponseMessage errorMessage = new ErrorResponseMessage();
            errorMessage.setSessionAsUUID(RexProMessage.EMPTY_SESSION);
            errorMessage.Request = specificMessage.Request;
            errorMessage.ErrorMessage = "Invalid username or password.";
            errorMessage.metaSetFlag(ErrorResponseMessage.AUTH_FAILURE_ERROR);
            request.writeResponseMessage((RexProMessage)errorMessage);
            ctx.write((Object)request);
            return ctx.getStopAction();
        }
        return ctx.getInvokeAction();
    }

    public ContainerRequest filter(ContainerRequest request) {
        User user = this.authenticateServletRequest(request);
        request.setSecurityContext((SecurityContext)new Authorizer(user));
        return request;
    }

    private void initFromServletConfiguration() {
        if (this.isConfigured) {
            String rexsterXmlFile = this.servletConfig.getInitParameter("com.tinkerpop.rexster.config");
            XMLConfiguration properties = new XMLConfiguration();
            try {
                properties.load((Reader)new FileReader(rexsterXmlFile));
            }
            catch (Exception e) {
                throw new RuntimeException("Could not locate " + rexsterXmlFile + " properties file.", e);
            }
            this.configure(properties);
            this.isConfigured = true;
        }
    }

    private User authenticateServletRequest(ContainerRequest request) {
        this.initFromServletConfiguration();
        String authentication = request.getHeaderValue("Authorization");
        if (authentication == null) {
            throw new WebApplicationException(this.generateErrorResponse("Authentication credentials are required."));
        }
        if (!authentication.startsWith("Basic ")) {
            logger.info((Object)("Authentication failed: request for unsupported authentication type [" + authentication + "]"));
            throw new WebApplicationException(this.generateErrorResponse("Invalid authentication credentials."));
        }
        String authenticationBase64Segment = authentication.substring("Basic ".length());
        String[] values = new String(Base64.base64Decode((String)authenticationBase64Segment)).split(":");
        if (values.length < 2) {
            logger.info((Object)("Authentication failed: invalid authentication string format [" + authenticationBase64Segment + "]"));
            throw new WebApplicationException(this.generateErrorResponse("Invalid authentication credentials."));
        }
        String username = values[0];
        String password = values[1];
        if (username == null || password == null) {
            logger.info((Object)("Authentication failed: missing username or password [" + authentication + "]"));
            throw new WebApplicationException(this.generateErrorResponse("Invalid authentication credentials."));
        }
        if (!this.authenticate(username, password)) {
            logger.info((Object)("Authentication failed: invalid username or password [" + authenticationBase64Segment + "]"));
            throw new WebApplicationException(this.generateErrorResponse("Invalid username or password."));
        }
        User user = new User(username, "user");
        logger.debug((Object)("Authentication succeeded for [" + username + "]"));
        return user;
    }

    private Response generateErrorResponse(final String message) {
        HashMap<String, String> errorEntity = new HashMap<String, String>(){
            {
                this.put("message", message);
                this.put("version", "2.5.0");
            }
        };
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).header("WWW-Authenticate", (Object)"Basic realm=\"rexster\"").type("application/json").entity((Object)new JSONObject((Map)errorEntity)).build();
    }

    public class User {
        public final String username;
        public final String role;

        public User(String username, String role) {
            this.username = username;
            this.role = role;
        }
    }

    public class Authorizer
    implements SecurityContext {
        private final User user;
        private final Principal principal;

        public Authorizer(final User user) {
            this.user = user;
            this.principal = new Principal(){

                @Override
                public String getName() {
                    return user.username;
                }
            };
        }

        public Principal getUserPrincipal() {
            return this.principal;
        }

        public boolean isUserInRole(String role) {
            return role.equals(this.user.role);
        }

        public boolean isSecure() {
            return "https".equals(AbstractSecurityFilter.this.uriInfo.getRequestUri().getScheme());
        }

        public String getAuthenticationScheme() {
            return "BASIC";
        }
    }
}

