/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.projects.ui.dependencies;

import javax.inject.Inject;
import org.jboss.forge.addon.dependencies.Dependency;
import org.jboss.forge.addon.dependencies.builder.DependencyBuilder;
import org.jboss.forge.addon.facets.constraints.FacetConstraint;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.projects.ProjectFactory;
import org.jboss.forge.addon.projects.facets.DependencyFacet;
import org.jboss.forge.addon.projects.ui.AbstractProjectCommand;
import org.jboss.forge.addon.projects.ui.dependencies.HasManagedDependenciesCommand;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.input.UIInput;
import org.jboss.forge.addon.ui.input.UIInputMany;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.metadata.WithAttributes;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;

@FacetConstraint(value={DependencyFacet.class})
public class HasManagedDependenciesCommandImpl
extends AbstractProjectCommand
implements HasManagedDependenciesCommand {
    @Inject
    private ProjectFactory factory;
    @Inject
    @WithAttributes(shortName=100, label="Coordinates", required=true, description="The coordinates of the managed arguments to be checked [groupId :artifactId {:version :scope :packaging}]")
    private UIInputMany<Dependency> arguments;
    @Inject
    @WithAttributes(shortName=101, label="Effective", required=false, description="", defaultValue="")
    private UIInput<Boolean> effective;

    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.forCommand(HasManagedDependenciesCommandImpl.class).description("Check one or more managed dependencies in the current project.").name("Project: Has Managed Dependencies").category(Categories.create((String[])new String[]{"Project", "Manage"}));
    }

    public void initializeUI(UIBuilder builder) throws Exception {
        builder.add(this.arguments);
        builder.add(this.effective);
    }

    public Result execute(UIExecutionContext context) {
        Project project = this.getSelectedProject(context.getUIContext());
        DependencyFacet deps = (DependencyFacet)project.getFacet(DependencyFacet.class);
        if (this.arguments.hasValue()) {
            int numberOfGavsFound = 0;
            int numberOfGavs = 0;
            for (Dependency gav : this.arguments.getValue()) {
                ++numberOfGavs;
                DependencyBuilder dep = DependencyBuilder.create((Dependency)gav);
                if (((Boolean)this.effective.getValue()).booleanValue()) {
                    if (!deps.hasEffectiveManagedDependency(gav)) continue;
                    ++numberOfGavsFound;
                    continue;
                }
                if (!deps.hasDirectManagedDependency((Dependency)dep)) continue;
                ++numberOfGavsFound;
            }
            if (numberOfGavs == numberOfGavsFound) {
                return Results.success((String)"All arguments found");
            }
            return Results.fail((String)("Missing " + (numberOfGavs - numberOfGavsFound)));
        }
        return Results.fail((String)"No arguments specified.");
    }

    protected boolean isProjectRequired() {
        return true;
    }

    protected ProjectFactory getProjectFactory() {
        return this.factory;
    }
}

