/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.util;

import java.util.Arrays;
import org.ocpsoft.common.util.Assert;

public abstract class ParseTools {
    private static final char ESCAPE_CHAR = '\\';

    public static CapturingGroup balancedCapture(char[] chars, int startPos, int endPos, CaptureType type) {
        int cursor;
        Assert.notNull((Object)chars, (String)"Character input array must not be null.");
        Assert.assertTrue((startPos >= 0 ? 1 : 0) != 0, (String)"Start position must be greater than zero.");
        Assert.assertTrue((startPos < chars.length - 1 ? 1 : 0) != 0, (String)"Start position must be at least one character before the array upper bound.");
        Assert.assertTrue((endPos > 0 ? 1 : 0) != 0, (String)"End position must be greater than zero.");
        Assert.assertTrue((endPos < chars.length ? 1 : 0) != 0, (String)"End position must be less than or equal to the array upper bound.");
        Assert.assertTrue((startPos < endPos ? 1 : 0) != 0, (String)"Start position must be less than end position.");
        Assert.assertTrue((chars[startPos] == type.getBegin() ? 1 : 0) != 0, (String)("Character at starting position was [" + chars[startPos] + "] but expected [" + type.getBegin() + "]"));
        if (ParseTools.isEscaped(chars, startPos)) {
            throw new IllegalArgumentException("Character at starting position is escaped, and cannot be used in capturing a group.");
        }
        int depth = 1;
        char begin = type.getBegin();
        char term = type.getEnd();
        for (cursor = startPos + 1; cursor < endPos && depth > 0; ++cursor) {
            if (chars[cursor] == term) {
                if (!ParseTools.isEscaped(chars, cursor)) {
                    --depth;
                }
            } else if (chars[cursor] == begin && !ParseTools.isEscaped(chars, cursor)) {
                ++depth;
            }
            if (depth == 0) break;
        }
        return new CapturingGroup(chars, startPos, cursor);
    }

    public static boolean isEscaped(char[] chars, int cursor) {
        Assert.notNull((Object)chars, (String)"Character input array must not be null.");
        Assert.assertTrue((cursor >= 0 ? 1 : 0) != 0, (String)"Start position must be greater than zero.");
        Assert.assertTrue((cursor < chars.length ? 1 : 0) != 0, (String)"Start position must be within the array upper bound.");
        return cursor > 0 && chars[cursor - 1] == '\\' && (cursor == 1 || cursor > 1 && chars[cursor - 2] != '\\');
    }

    public static enum CaptureType {
        BRACE('{', '}'),
        BRACKET('[', ']'),
        PAREN('(', ')'),
        REGEX('/', '/');

        private char begin;
        private char end;

        private CaptureType(char begin, char end) {
            this.begin = begin;
            this.end = end;
        }

        public char getBegin() {
            return this.begin;
        }

        public char getEnd() {
            return this.end;
        }
    }

    public static class CapturingGroup {
        private final char[] chars;
        private final int start;
        private final int end;

        public CapturingGroup(char[] chars, int start, int end) {
            this.chars = chars;
            this.start = start;
            this.end = end;
        }

        public int getStart() {
            return this.start;
        }

        public int getEnd() {
            return this.end;
        }

        public char[] getCaptured() {
            return Arrays.copyOfRange(this.chars, this.start + 1, this.end);
        }

        public String toString() {
            return "CapturingGroup [start=" + this.start + ", end=" + this.end + "]";
        }
    }
}

