/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.text;

import java.io.OutputStream;
import org.jboss.forge.addon.text.highlight.Encoder;
import org.jboss.forge.addon.text.highlight.Scanner;
import org.jboss.forge.addon.text.highlight.Syntax;
import org.jboss.forge.furnace.Furnace;
import org.jboss.forge.furnace.container.simple.lifecycle.SimpleContainer;
import org.jboss.forge.furnace.repositories.AddonRepository;
import org.jboss.forge.furnace.services.Imported;

public class Highlighter {
    private Imported<Scanner> importedScanners;

    public Highlighter() {
        Syntax.builtIns();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void byType(String contentType, String content, OutputStream out) {
        if (contentType == null) {
            throw new IllegalArgumentException("contentType must be specified");
        }
        Imported<Scanner> scanners = this.resolveScanners();
        for (Scanner scanner : scanners) {
            if (!scanner.getType().getName().equalsIgnoreCase(contentType)) continue;
            try {
                this.execute(scanner, content, out);
            }
            finally {
                scanners.release((Object)scanner);
            }
            return;
        }
        this.execute(Scanner.Factory.byType(contentType), content, out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void byFileName(String fileName, String content, OutputStream out) {
        if (fileName == null) {
            throw new IllegalArgumentException("contentType must be specified");
        }
        Imported<Scanner> scanners = this.resolveScanners();
        for (Scanner scanner : scanners) {
            if (!scanner.getType().supports(fileName)) continue;
            try {
                this.execute(scanner, content, out);
            }
            finally {
                scanners.release((Object)scanner);
            }
            return;
        }
        this.execute(Scanner.Factory.byFileName(fileName), content, out);
    }

    private void execute(Scanner scanner, String content, OutputStream out) {
        if (scanner == null) {
            throw new IllegalArgumentException("scanner must be specified");
        }
        if (content == null) {
            throw new IllegalArgumentException("content must be specified");
        }
        if (out == null) {
            throw new IllegalArgumentException("out must be specified");
        }
        Syntax.Builder.create().encoderType(Encoder.Type.TERMINAL).output(out).scanner(scanner).execute(content);
    }

    private Imported<Scanner> resolveScanners() {
        Furnace furnace;
        if (this.importedScanners == null && (furnace = SimpleContainer.getFurnace((ClassLoader)this.getClass().getClassLoader())) != null) {
            this.importedScanners = furnace.getAddonRegistry(new AddonRepository[0]).getServices(Scanner.class);
        }
        return this.importedScanners;
    }
}

