/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.xml.condition;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import javax.xml.xpath.XPathFunction;
import javax.xml.xpath.XPathFunctionException;
import javax.xml.xpath.XPathFunctionResolver;
import org.jboss.forge.furnace.util.Assert;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.Variables;
import org.jboss.windup.config.condition.EvaluationStrategy;
import org.jboss.windup.config.parameters.FrameContext;
import org.jboss.windup.config.parameters.FrameCreationContext;
import org.jboss.windup.config.parameters.ParameterizedGraphCondition;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.WindupVertexFrame;
import org.jboss.windup.graph.service.GraphService;
import org.jboss.windup.rules.apps.xml.condition.XmlFileEvaluateXPathFunction;
import org.jboss.windup.rules.apps.xml.condition.XmlFileFrom;
import org.jboss.windup.rules.apps.xml.condition.XmlFileFunctionResolver;
import org.jboss.windup.rules.apps.xml.condition.XmlFileMatchesXPathFunction;
import org.jboss.windup.rules.apps.xml.condition.XmlFileParameterMatchCache;
import org.jboss.windup.rules.apps.xml.condition.XmlFileStartFrameXPathFunction;
import org.jboss.windup.rules.apps.xml.condition.XmlFileXPathTransformer;
import org.jboss.windup.rules.apps.xml.model.DoctypeMetaModel;
import org.jboss.windup.rules.apps.xml.model.NamespaceMetaModel;
import org.jboss.windup.rules.apps.xml.model.XmlFileModel;
import org.jboss.windup.rules.apps.xml.model.XmlTypeReferenceModel;
import org.jboss.windup.rules.apps.xml.service.XmlFileService;
import org.jboss.windup.rules.files.model.FileReferenceModel;
import org.jboss.windup.util.ExecutionStatistics;
import org.jboss.windup.util.Logging;
import org.jboss.windup.util.exception.WindupException;
import org.jboss.windup.util.xml.NamespaceMapContext;
import org.jboss.windup.util.xml.XmlUtil;
import org.ocpsoft.rewrite.config.ConditionBuilder;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.event.Rewrite;
import org.ocpsoft.rewrite.param.DefaultParameterStore;
import org.ocpsoft.rewrite.param.DefaultParameterValueStore;
import org.ocpsoft.rewrite.param.Parameter;
import org.ocpsoft.rewrite.param.ParameterStore;
import org.ocpsoft.rewrite.param.ParameterValueStore;
import org.ocpsoft.rewrite.param.RegexParameterizedPatternParser;
import org.ocpsoft.rewrite.util.Maps;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlFile
extends ParameterizedGraphCondition {
    private static final Logger LOG = Logging.get(XmlFile.class);
    protected static final String UNPARSEABLE_XML_CLASSIFICATION = "Unparseable XML File";
    protected static final String UNPARSEABLE_XML_DESCRIPTION = "This file could not be parsed via XPath";
    protected static final String WINDUP_NS_PREFIX = "windup";
    protected static final String WINDUP_NS_URI = "http://windup.jboss.org/windupv2functions";
    private static XPathFactory factory = XPathFactory.newInstance();
    private final XmlFileFunctionResolver xmlFileFunctionResolver;
    private final XPath xpathEngine;
    private String xpathString;
    private XPathExpression compiledXPath;
    private Map<String, String> namespaces = new HashMap<String, String>();
    private String fileName;
    private String publicId;
    private String xpathResultMatch;
    private RegexParameterizedPatternParser xpathPattern;

    public void setXpathResultMatch(String xpathResultMatch) {
        this.xpathResultMatch = xpathResultMatch;
    }

    private XmlFile(String xpath) {
        this();
        this.setXpath(xpath);
    }

    XmlFile() {
        this.namespaces.put(WINDUP_NS_PREFIX, WINDUP_NS_URI);
        this.xpathEngine = factory.newXPath();
        XPathFunctionResolver originalResolver = this.xpathEngine.getXPathFunctionResolver();
        this.xmlFileFunctionResolver = new XmlFileFunctionResolver(originalResolver);
        this.xpathEngine.setXPathFunctionResolver(this.xmlFileFunctionResolver);
    }

    public static XmlFile matchesXpath(String xpath) {
        return new XmlFile(xpath);
    }

    public static XmlFile withDTDPublicId(String publicIdRegex) {
        XmlFile xmlFile = new XmlFile();
        xmlFile.publicId = publicIdRegex;
        return xmlFile;
    }

    public ConditionBuilder as(String variable) {
        Assert.notNull((Object)variable, (String)"Variable name must not be null.");
        this.setOutputVariablesName(variable);
        return this;
    }

    public XmlFile inFile(String fileName) {
        this.fileName = fileName;
        return this;
    }

    public XmlFile resultMatches(String regex) {
        this.xpathResultMatch = regex;
        return this;
    }

    public static XmlFileFrom from(String fromVariable) {
        return new XmlFileFrom(fromVariable);
    }

    public void setParameterStore(ParameterStore store) {
        if (this.xpathPattern != null) {
            this.xpathPattern.setParameterStore(store);
        }
    }

    public Set<String> getRequiredParameterNames() {
        if (this.xpathPattern == null) {
            return Collections.emptySet();
        }
        HashSet<String> result = new HashSet<String>(this.xpathPattern.getRequiredParameterNames());
        return result;
    }

    protected String getVarname() {
        return this.getOutputVariablesName();
    }

    protected boolean evaluateAndPopulateValueStores(final GraphRewrite event, final EvaluationContext context, final FrameCreationContext frameCreationContext) {
        return this.evaluate(event, context, new XmlFileEvaluationStrategy(){
            private LinkedHashMap<String, List<WindupVertexFrame>> variables;

            public void modelMatched() {
                this.variables = new LinkedHashMap();
                frameCreationContext.beginNew(this.variables);
            }

            public void modelSubmitted(WindupVertexFrame model) {
                Maps.addListValue(this.variables, (Object)XmlFile.this.getVarname(), (Object)model);
            }

            @Override
            public boolean submitValue(Parameter<?> parameter, String value) {
                ParameterValueStore valueStore = DefaultParameterValueStore.getInstance((EvaluationContext)context);
                return valueStore.submit((Rewrite)event, context, parameter, value);
            }

            public void modelSubmissionRejected() {
                frameCreationContext.rollback();
            }
        });
    }

    protected boolean evaluateWithValueStore(final GraphRewrite event, final EvaluationContext context, FrameContext frameContext) {
        boolean result = this.evaluate(event, context, new XmlFileEvaluationStrategy(){

            public void modelMatched() {
            }

            public void modelSubmitted(WindupVertexFrame model) {
            }

            @Override
            public boolean submitValue(Parameter<?> parameter, String value) {
                ParameterValueStore valueStore = DefaultParameterValueStore.getInstance((EvaluationContext)context);
                String existingValue = valueStore.retrieve(parameter);
                if (existingValue == null) {
                    return valueStore.submit((Rewrite)event, context, parameter, value);
                }
                return valueStore.isValid((Rewrite)event, context, parameter, value);
            }

            public void modelSubmissionRejected() {
            }
        });
        if (!result) {
            frameContext.reject();
        }
        return result;
    }

    private boolean evaluate(GraphRewrite event, EvaluationContext context, XmlFileEvaluationStrategy evaluationStrategy) {
        ExecutionStatistics.get().begin("XmlFile.evaluate");
        ArrayList<WindupVertexFrame> resultLocations = new ArrayList<WindupVertexFrame>();
        GraphContext graphContext = event.getGraphContext();
        GraphService xmlResourceService = new GraphService(graphContext, XmlFileModel.class);
        Iterable allXmls = this.getInputVariablesName() == null || this.getInputVariablesName().equals("") ? xmlResourceService.findAll() : Variables.instance((GraphRewrite)event).findVariable(this.getInputVariablesName());
        for (WindupVertexFrame iterated : allXmls) {
            XmlFileModel xml;
            if (iterated instanceof FileReferenceModel) {
                xml = (XmlFileModel)((FileReferenceModel)iterated).getFile();
            } else if (iterated instanceof XmlFileModel) {
                xml = (XmlFileModel)iterated;
            } else {
                throw new WindupException("XmlFile was called on the wrong graph type ( " + iterated.toPrettyString() + ")");
            }
            if (this.fileName != null && !this.fileName.equals("") && !xml.getFileName().matches(this.fileName)) continue;
            if (this.publicId != null && !this.publicId.equals("")) {
                DoctypeMetaModel doctype = xml.getDoctype();
                if (doctype == null || doctype.getPublicId() == null || !doctype.getPublicId().matches(this.publicId)) continue;
                if (this.xpathString == null) {
                    evaluationStrategy.modelMatched();
                    evaluationStrategy.modelSubmitted((WindupVertexFrame)xml);
                    resultLocations.add((WindupVertexFrame)xml);
                }
            }
            if (this.xpathString == null) continue;
            String xpathStringWithParameterFunctions = XmlFileXPathTransformer.transformXPath(this.xpathString);
            LOG.fine("XmlFile compiled: " + this.xpathString + " to " + xpathStringWithParameterFunctions);
            XmlFileService xmlFileService = new XmlFileService(graphContext);
            Document document = xmlFileService.loadDocumentQuiet(xml);
            if (document == null) continue;
            ParameterStore store = DefaultParameterStore.getInstance((EvaluationContext)context);
            XmlFileParameterMatchCache paramMatchCache = new XmlFileParameterMatchCache();
            this.xmlFileFunctionResolver.registerFunction(WINDUP_NS_URI, "startFrame", new XmlFileStartFrameXPathFunction(paramMatchCache));
            this.xmlFileFunctionResolver.registerFunction(WINDUP_NS_URI, "evaluate", new XmlFileEvaluateXPathFunction(evaluationStrategy));
            this.xmlFileFunctionResolver.registerFunction(WINDUP_NS_URI, "matches", new XmlFileMatchesXPathFunction(context, store, paramMatchCache, event));
            this.xmlFileFunctionResolver.registerFunction(WINDUP_NS_URI, "persist", new XmlFilePersistXPathFunction(graphContext, xml, evaluationStrategy, store, paramMatchCache, resultLocations));
            if (this.compiledXPath == null) {
                NamespaceMapContext nsContext = new NamespaceMapContext(this.namespaces);
                this.xpathEngine.setNamespaceContext((NamespaceContext)nsContext);
                try {
                    this.compiledXPath = this.xpathEngine.compile(xpathStringWithParameterFunctions);
                }
                catch (Exception e) {
                    String message = e.getMessage();
                    if (message == null && e.getCause() != null && e.getCause().getMessage() != null) {
                        message = e.getCause().getMessage();
                    }
                    LOG.severe("Condition: " + (Object)((Object)this) + " failed to run, as the following xpath was uncompilable: " + this.xpathString + " (compiled contents: " + xpathStringWithParameterFunctions + ") due to: " + message);
                    return false;
                }
            }
            XmlUtil.xpathNodeList((Node)document, (XPathExpression)this.compiledXPath);
        }
        Variables.instance((GraphRewrite)event).setVariable(this.getOutputVariablesName(), resultLocations);
        ExecutionStatistics.get().end("XmlFile.evaluate");
        return !resultLocations.isEmpty();
    }

    public XmlFile namespace(String prefix, String url) {
        this.namespaces.put(prefix, url);
        return this;
    }

    public void setXpath(String xpath) {
        this.xpathString = xpath;
        this.compiledXPath = null;
        if (xpath != null) {
            this.xpathPattern = new RegexParameterizedPatternParser(this.xpathString);
        }
    }

    public void setPublicId(String publicId) {
        this.publicId = publicId;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("XmlFile");
        if (this.getInputVariablesName() != null) {
            builder.append(".inputVariable(" + this.getInputVariablesName() + ")");
        }
        if (this.xpathString != null) {
            builder.append(".matches(" + this.xpathString + ")");
        }
        if (this.fileName != null) {
            builder.append(".inFile(" + this.fileName + ")");
        }
        if (this.publicId != null) {
            builder.append(".withDTDPublicId(" + this.publicId + ")");
        }
        builder.append(".as(" + this.getInputVariablesName() + ")");
        return builder.toString();
    }

    final class XmlFilePersistXPathFunction
    implements XPathFunction {
        private final GraphContext graphContext;
        private final XmlFileModel xml;
        private final XmlFileEvaluationStrategy evaluationStrategy;
        private final ParameterStore store;
        private final XmlFileParameterMatchCache paramMatchCache;
        private final List<WindupVertexFrame> resultLocations;

        XmlFilePersistXPathFunction(GraphContext graphContext, XmlFileModel xml, XmlFileEvaluationStrategy evaluationStrategy, ParameterStore store, XmlFileParameterMatchCache paramMatchCache, List<WindupVertexFrame> resultLocations) {
            this.graphContext = graphContext;
            this.xml = xml;
            this.evaluationStrategy = evaluationStrategy;
            this.store = store;
            this.paramMatchCache = paramMatchCache;
            this.resultLocations = resultLocations;
        }

        public Object evaluate(List args) throws XPathFunctionException {
            int frameIdx = ((Double)args.get(0)).intValue();
            NodeList arg1 = (NodeList)args.get(1);
            String nodeText = XmlUtil.nodeListToString((NodeList)arg1);
            LOG.fine("persist(" + frameIdx + ", " + nodeText + ")");
            for (int i = 0; i < arg1.getLength(); ++i) {
                Node node = arg1.item(i);
                if (XmlFile.this.xpathResultMatch != null && !node.toString().matches(XmlFile.this.xpathResultMatch)) continue;
                int lineNumber = (Integer)node.getUserData("ln");
                int columnNumber = (Integer)node.getUserData("cn");
                GraphService fileLocationService = new GraphService(this.graphContext, XmlTypeReferenceModel.class);
                XmlTypeReferenceModel fileLocation = (XmlTypeReferenceModel)fileLocationService.create();
                String sourceSnippit = XmlUtil.nodeToString((Node)node);
                fileLocation.setSourceSnippit(sourceSnippit);
                fileLocation.setLineNumber(lineNumber);
                fileLocation.setColumnNumber(columnNumber);
                fileLocation.setLength(node.toString().length());
                fileLocation.setFile(this.xml);
                fileLocation.setXpath(XmlFile.this.xpathString);
                GraphService metaModelService = new GraphService(this.graphContext, NamespaceMetaModel.class);
                for (Map.Entry entry : XmlFile.this.namespaces.entrySet()) {
                    NamespaceMetaModel metaModel = (NamespaceMetaModel)metaModelService.create();
                    metaModel.setSchemaLocation((String)entry.getKey());
                    metaModel.setSchemaLocation((String)entry.getValue());
                    metaModel.addXmlResource(this.xml);
                    fileLocation.addNamespace(metaModel);
                }
                this.resultLocations.add((WindupVertexFrame)fileLocation);
                this.evaluationStrategy.modelMatched();
                for (Map.Entry<Object, Object> entry : this.paramMatchCache.getVariables(frameIdx).entrySet()) {
                    String value;
                    Parameter param = this.store.get((String)entry.getKey());
                    if (this.evaluationStrategy.submitValue(param, value = (String)entry.getValue())) continue;
                    return false;
                }
                this.evaluationStrategy.modelSubmitted((WindupVertexFrame)fileLocation);
                this.evaluationStrategy.modelMatched();
            }
            return true;
        }
    }

    private static interface XmlFileEvaluationStrategy
    extends EvaluationStrategy {
        public boolean submitValue(Parameter<?> var1, String var2);
    }
}

