/*
 * Decompiled with CFR 0.152.
 */
package org.xadisk.filesystem.workers;

import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import javax.resource.spi.work.Work;

public abstract class EventWorker
implements Work {
    private final ReentrantLock eventRaiseSynchLock = new ReentrantLock(false);
    private final Condition waitTillEventRaised = this.eventRaiseSynchLock.newCondition();
    private boolean enabled = true;
    private boolean eventRaised = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        try {
            this.eventRaiseSynchLock.lockInterruptibly();
            this.enabled = false;
            this.waitTillEventRaised.signal();
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            return;
        }
        finally {
            this.eventRaiseSynchLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (this.enabled) {
            try {
                this.eventRaiseSynchLock.lockInterruptibly();
                while (!this.eventRaised && this.enabled) {
                    this.waitTillEventRaised.await();
                }
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                break;
            }
            finally {
                this.eventRaiseSynchLock.unlock();
            }
            if (!this.eventRaised) continue;
            this.eventRaised = false;
            this.processEvent();
        }
    }

    abstract void processEvent();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void raiseEvent() {
        if (this.eventRaised) {
            return;
        }
        this.eventRaised = true;
        try {
            this.eventRaiseSynchLock.lock();
            this.waitTillEventRaised.signal();
        }
        finally {
            this.eventRaiseSynchLock.unlock();
        }
    }
}

