/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.context.beanstore.http;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.jboss.weld.context.beanstore.NamingScheme;
import org.jboss.weld.context.beanstore.http.AbstractSessionBeanStore;
import org.jboss.weld.logging.ContextLogger;
import org.jboss.weld.servlet.SessionHolder;

public class LazySessionBeanStore
extends AbstractSessionBeanStore {
    private final HttpServletRequest request;

    public LazySessionBeanStore(HttpServletRequest request, NamingScheme namingScheme) {
        super(namingScheme);
        this.request = request;
        ContextLogger.LOG.loadingBeanStoreMapFromSession(this, this.getSession(false));
    }

    protected HttpSession getSessionIfExists() {
        return SessionHolder.getSessionIfExists();
    }

    @Override
    protected HttpSession getSession(boolean create) {
        try {
            return SessionHolder.getSession(this.request, create);
        }
        catch (IllegalStateException e) {
            this.detach();
            return null;
        }
    }
}

