/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.xml;

import com.google.common.collect.ImmutableSet;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jboss.weld.bootstrap.spi.BeanDiscoveryMode;
import org.jboss.weld.bootstrap.spi.BeansXml;
import org.jboss.weld.bootstrap.spi.ClassAvailableActivation;
import org.jboss.weld.bootstrap.spi.Filter;
import org.jboss.weld.bootstrap.spi.Metadata;
import org.jboss.weld.bootstrap.spi.SystemPropertyActivation;
import org.jboss.weld.logging.XmlLogger;
import org.jboss.weld.metadata.BeansXmlImpl;
import org.jboss.weld.metadata.ClassAvailableActivationImpl;
import org.jboss.weld.metadata.FilterImpl;
import org.jboss.weld.metadata.ScanningImpl;
import org.jboss.weld.metadata.SystemPropertyActivationImpl;
import org.jboss.weld.metadata.WeldFilterImpl;
import org.jboss.weld.xml.XmlMetadata;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class BeansXmlHandler
extends DefaultHandler {
    private static final String VALUE_ATTRIBUTE_QUALIFIED_NAME = "value";
    private static final String PATTERN_ATTRIBUTE_QUALIFIED_NAME = "pattern";
    private static final String NAME_ATTRIBUTE_QUALIFIED_NAME = "name";
    public static final String JAVAEE_LEGACY_URI = "http://java.sun.com/xml/ns/javaee";
    public static final String JAVAEE_URI = "http://xmlns.jcp.org/xml/ns/javaee";
    public static final Set<String> JAVAEE_URIS = ImmutableSet.of((Object)"http://java.sun.com/xml/ns/javaee", (Object)"http://xmlns.jcp.org/xml/ns/javaee");
    public static final String WELD_URI = "http://jboss.org/schema/weld/beans";
    public static final Set<String> SCANNING_URI = ImmutableSet.of((Object)"http://jboss.org/schema/weld/beans", (Object)"http://xmlns.jcp.org/xml/ns/javaee", (Object)"http://java.sun.com/xml/ns/javaee");
    private static final String VERSION_ATTRIBUTE_NAME = "version";
    private static final String BEAN_DISCOVERY_MODE_ATTRIBUTE_NAME = "bean-discovery-mode";
    private static final String ROOT_ELEMENT_NAME = "beans";
    private static final String IF_CLASS_AVAILABLE = "if-class-available";
    private static final String IF_CLASS_NOT_AVAILABLE = "if-class-not-available";
    private static final String IF_SYSTEM_PROPERTY = "if-system-property";
    private static final String CLASS = "class";
    private static final String STEREOTYPE = "stereotype";
    private static final String INCLUDE = "include";
    private static final String EXCLUDE = "exclude";
    private static final String VALIDATION_ERROR_CODE_CVC_ELT_1 = "cvc-elt.1";
    private final Collection<Container> containers;
    private final List<Metadata<String>> interceptors;
    private final List<Metadata<String>> decorators;
    private final List<Metadata<String>> alternativesClasses;
    private final List<Metadata<String>> alternativeStereotypes;
    private final List<Metadata<Filter>> includes;
    private final List<Metadata<Filter>> excludes;
    protected final URL file;
    private BeanDiscoveryMode discoveryMode;
    private String version;
    private Collection<Container> seenContainers;
    private Container currentContainer;
    private StringBuilder buffer;
    private Locator locator;

    protected static String trim(String str) {
        if (str == null) {
            return null;
        }
        return str.trim();
    }

    public BeansXmlHandler(final URL file) {
        this.file = file;
        this.interceptors = new ArrayList<Metadata<String>>();
        this.decorators = new ArrayList<Metadata<String>>();
        this.alternativesClasses = new ArrayList<Metadata<String>>();
        this.alternativeStereotypes = new ArrayList<Metadata<String>>();
        this.includes = new ArrayList<Metadata<Filter>>();
        this.excludes = new ArrayList<Metadata<Filter>>();
        this.seenContainers = new ArrayList<Container>();
        this.containers = new ArrayList<Container>();
        this.discoveryMode = BeanDiscoveryMode.ALL;
        this.containers.add(new SpecContainer("interceptors", new String[]{CLASS}){

            @Override
            public void processEndChildElement(String uri, String localName, String qName, String nestedText) {
                if (this.isInNamespace(uri) && BeansXmlHandler.CLASS.equals(localName)) {
                    BeansXmlHandler.this.interceptors.add(new XmlMetadata<String>(qName, BeansXmlHandler.trim(nestedText), file, BeansXmlHandler.this.locator.getLineNumber()));
                }
            }

            @Override
            public void handleMultiple() {
                throw XmlLogger.LOG.multipleInterceptors(file + "@" + BeansXmlHandler.this.locator.getLineNumber());
            }
        });
        this.containers.add(new SpecContainer("decorators", new String[]{CLASS}){

            @Override
            public void processEndChildElement(String uri, String localName, String qName, String nestedText) {
                if (this.isInNamespace(uri) && BeansXmlHandler.CLASS.equals(localName)) {
                    BeansXmlHandler.this.decorators.add(new XmlMetadata<String>(qName, BeansXmlHandler.trim(nestedText), file, BeansXmlHandler.this.locator.getLineNumber()));
                }
            }

            @Override
            public void handleMultiple() {
                throw XmlLogger.LOG.multipleDecorators(file + "@" + BeansXmlHandler.this.locator.getLineNumber());
            }
        });
        this.containers.add(new SpecContainer("alternatives", new String[]{CLASS, STEREOTYPE}){

            @Override
            public void processEndChildElement(String uri, String localName, String qName, String nestedText) {
                if (this.isInNamespace(uri) && BeansXmlHandler.CLASS.equals(localName)) {
                    BeansXmlHandler.this.alternativesClasses.add(new XmlMetadata<String>(qName, BeansXmlHandler.trim(nestedText), file, BeansXmlHandler.this.locator.getLineNumber()));
                } else if (this.isInNamespace(uri) && BeansXmlHandler.STEREOTYPE.equals(localName)) {
                    BeansXmlHandler.this.alternativeStereotypes.add(new XmlMetadata<String>(qName, BeansXmlHandler.trim(nestedText), file, BeansXmlHandler.this.locator.getLineNumber()));
                }
            }

            @Override
            public void handleMultiple() {
                throw XmlLogger.LOG.multipleAlternatives(file + "@" + BeansXmlHandler.this.locator.getLineNumber());
            }
        });
        this.containers.add(new Container(SCANNING_URI, "scan", new String[0]){
            String name;
            String pattern;
            Collection<Metadata<SystemPropertyActivation>> systemPropertyActivations;
            Collection<Metadata<ClassAvailableActivation>> classAvailableActivations;

            @Override
            public void processStartChildElement(String uri, String localName, String qName, Attributes attributes) {
                if (this.isFilterElement(uri, localName)) {
                    this.name = this.interpolateAttributeValue(attributes, BeansXmlHandler.NAME_ATTRIBUTE_QUALIFIED_NAME);
                    this.pattern = this.interpolateAttributeValue(attributes, BeansXmlHandler.PATTERN_ATTRIBUTE_QUALIFIED_NAME);
                    this.systemPropertyActivations = new ArrayList<Metadata<SystemPropertyActivation>>();
                    this.classAvailableActivations = new ArrayList<Metadata<ClassAvailableActivation>>();
                } else if (this.isInNamespace(uri)) {
                    if (BeansXmlHandler.IF_CLASS_AVAILABLE.equals(localName) || BeansXmlHandler.IF_CLASS_NOT_AVAILABLE.equals(localName)) {
                        String className = this.interpolateAttributeValue(attributes, BeansXmlHandler.NAME_ATTRIBUTE_QUALIFIED_NAME);
                        XmlMetadata<ClassAvailableActivationImpl> classAvailableActivation = new XmlMetadata<ClassAvailableActivationImpl>(qName, new ClassAvailableActivationImpl(className, BeansXmlHandler.IF_CLASS_NOT_AVAILABLE.equals(localName)), file, BeansXmlHandler.this.locator.getLineNumber());
                        this.classAvailableActivations.add(classAvailableActivation);
                    } else if (BeansXmlHandler.IF_SYSTEM_PROPERTY.equals(localName)) {
                        String systemPropertyName = this.interpolateAttributeValue(attributes, BeansXmlHandler.NAME_ATTRIBUTE_QUALIFIED_NAME);
                        String systemPropertyValue = this.interpolateAttributeValue(attributes, BeansXmlHandler.VALUE_ATTRIBUTE_QUALIFIED_NAME);
                        XmlMetadata<SystemPropertyActivationImpl> systemPropertyActivation = new XmlMetadata<SystemPropertyActivationImpl>(qName, new SystemPropertyActivationImpl(systemPropertyName, systemPropertyValue), file, BeansXmlHandler.this.locator.getLineNumber());
                        this.systemPropertyActivations.add(systemPropertyActivation);
                    }
                }
            }

            private String interpolateAttributeValue(Attributes attributes, String qName) {
                String value = BeansXmlHandler.trim(attributes.getValue(qName));
                return value == null ? null : BeansXmlHandler.this.interpolate(value);
            }

            @Override
            public void processEndChildElement(String uri, String localName, String qName, String nestedText) {
                if (this.isFilterElement(uri, localName)) {
                    FilterImpl filter = null;
                    filter = BeansXmlHandler.WELD_URI.equals(uri) ? new WeldFilterImpl(this.name, this.systemPropertyActivations, this.classAvailableActivations, this.pattern) : new FilterImpl(this.name, this.systemPropertyActivations, this.classAvailableActivations);
                    XmlMetadata<FilterImpl> filterMetadata = new XmlMetadata<FilterImpl>(qName, filter, file, BeansXmlHandler.this.locator.getLineNumber());
                    if (BeansXmlHandler.INCLUDE.equals(localName)) {
                        BeansXmlHandler.this.includes.add(filterMetadata);
                    } else if (BeansXmlHandler.EXCLUDE.equals(localName)) {
                        BeansXmlHandler.this.excludes.add(filterMetadata);
                    }
                    this.name = null;
                    this.pattern = null;
                    this.systemPropertyActivations = null;
                    this.classAvailableActivations = null;
                }
            }

            private boolean isFilterElement(String uri, String localName) {
                return this.isInNamespace(uri) && (BeansXmlHandler.INCLUDE.equals(localName) || BeansXmlHandler.EXCLUDE.equals(localName));
            }

            @Override
            public void handleMultiple() {
                throw XmlLogger.LOG.multipleScanning(file + "@" + BeansXmlHandler.this.locator.getLineNumber());
            }
        });
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (localName.equals(ROOT_ELEMENT_NAME) && ("".equals(uri) || JAVAEE_URIS.contains(uri))) {
            this.processRootElement(attributes);
            return;
        }
        if (this.currentContainer == null) {
            Container container = this.getContainer(uri, localName);
            if (container != null) {
                if (this.seenContainers.contains(container)) {
                    container.handleMultiple();
                }
                this.currentContainer = container;
            }
        } else {
            this.currentContainer.processStartChildElement(uri, localName, qName, attributes);
            if (this.currentContainer.getNestedElements().contains(localName)) {
                this.buffer = new StringBuilder();
            }
        }
    }

    private void processRootElement(Attributes attributes) {
        String version;
        String discoveryMode = attributes.getValue(BEAN_DISCOVERY_MODE_ATTRIBUTE_NAME);
        if (discoveryMode != null) {
            this.discoveryMode = BeanDiscoveryMode.valueOf((String)discoveryMode.toUpperCase());
        }
        if ((version = attributes.getValue(VERSION_ATTRIBUTE_NAME)) != null) {
            this.version = version;
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.currentContainer != null) {
            Container container;
            this.currentContainer.processEndChildElement(uri, localName, qName, this.buffer != null ? this.buffer.toString() : null);
            if (this.currentContainer.getNestedElements().contains(localName)) {
                this.buffer = null;
            }
            if ((container = this.getContainer(uri, localName)) != null) {
                this.seenContainers.add(container);
                this.currentContainer = null;
            }
        }
    }

    private Container getContainer(String uri, String localName) {
        return BeansXmlHandler.getContainer(uri, localName, this.containers);
    }

    private static Container getContainer(String uri, String localName, Collection<Container> containers) {
        for (Container container : containers) {
            if (!(uri.length() == 0 ? container.getLocalName().equals(localName) : container.getLocalName().equals(localName) && container.getUris().contains(uri))) continue;
            return container;
        }
        return null;
    }

    public BeansXml createBeansXml() {
        return new BeansXmlImpl(this.alternativesClasses, this.alternativeStereotypes, this.decorators, this.interceptors, new ScanningImpl(this.includes, this.excludes), this.file, this.discoveryMode, this.version);
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.buffer != null) {
            this.buffer.append(ch, start, length);
        }
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    @Override
    public void warning(SAXParseException e) throws SAXException {
        XmlLogger.LOG.xsdValidationWarning(this.file, e.getLineNumber(), e.getMessage());
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
        if (e.getMessage().startsWith(VALIDATION_ERROR_CODE_CVC_ELT_1) && e.getMessage().contains(ROOT_ELEMENT_NAME)) {
            return;
        }
        XmlLogger.LOG.xsdValidationError(this.file, e.getLineNumber(), e.getMessage());
    }

    protected String interpolate(String string) {
        return string;
    }

    private abstract class SpecContainer
    extends Container {
        public SpecContainer(String localName, String ... nestedElements) {
            super(JAVAEE_URIS, localName, nestedElements);
        }
    }

    public abstract class Container {
        private final Set<String> uris;
        private final String localName;
        private final Collection<String> nestedElements;

        public Container(Set<String> uris, String localName, String ... nestedElements) {
            this.uris = uris;
            this.localName = localName;
            this.nestedElements = Arrays.asList(nestedElements);
        }

        public String getLocalName() {
            return this.localName;
        }

        public Set<String> getUris() {
            return this.uris;
        }

        public void processStartChildElement(String uri, String localName, String qName, Attributes attributes) {
        }

        public void processEndChildElement(String uri, String localName, String qName, String nestedText) {
        }

        public void handleMultiple() {
        }

        public Collection<String> getNestedElements() {
            return this.nestedElements;
        }

        public String toString() {
            return "<" + this.localName + " />";
        }

        protected boolean isInNamespace(String namespace) {
            if (namespace.length() == 0) {
                return true;
            }
            return this.getUris().contains(namespace);
        }
    }
}

