/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.roaster.model.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jboss.forge.roaster.model.util.Strings;

public class Types {
    private static final Pattern CLASS_ARRAY_PATTERN = Pattern.compile("\\[+(B|F|C|D|I|J|S|Z|L)([0-9a-zA-Z\\.\\$]*);?");
    private static final Pattern SIMPLE_ARRAY_PATTERN = Pattern.compile("((?:[0-9a-zA-Z\\$]+)(?:\\<[^\\.^\\[]+)?(?:\\.(?:[0-9a-zA-Z\\$]+)(?:\\<[^\\.^\\[]+)?)*)(\\[\\])+");
    private static final Pattern GENERIC_PATTERN = Pattern.compile(".*<.*>$");
    private static final Pattern WILDCARD_AWARE_TYPE_PATTERN = Pattern.compile("^\\s*(\\?\\s+(?:extends|super)\\s+)?([A-Za-z$_]\\S*)\\s*$");
    private static final List<String> LANG_TYPES = Arrays.asList("Appendable", "AutoCloseable", "CharSequence", "Cloneable", "Comparable", "Iterable", "Readable", "Runnable", "Boolean", "Byte", "Character", "Character.Subset", "Character.UnicodeBlock", "Class", "ClassLoader", "ClassValue", "Compiler", "Double", "Enum", "Float", "InheritableThreadLocal", "Integer", "Long", "Math", "Number", "Object", "Package", "Process", "ProcessBuilder", "ProcessBuilder.Redirect", "Runtime", "RuntimePermission", "SecurityManager", "Short", "StackTraceElement", "StrictMath", "String", "StringBuffer", "StringBuilder", "System", "Thread", "ThreadGroup", "ThreadLocal", "Throwable", "Void", "AbstractMethodError", "AssertionError", "BootstrapMethodError", "ClassCircularityError", "ClassFormatError", "Error", "ExceptionInInitializerError", "IllegalAccessError", "IncompatibleClassChangeError", "InstantiationError", "InternalError", "LinkageError", "NoClassDefFoundError", "NoSuchFieldError", "NoSuchMethodError", "OutOfMemoryError", "StackOverflowError", "ThreadDeath", "UnknownError", "UnsatisfiedLinkError", "UnsupportedClassVersionError", "VerifyError", "VirtualMachineError", "AbstractMethodError", "AssertionError", "BootstrapMethodError", "ClassCircularityError", "ClassFormatError", "Error", "ExceptionInInitializerError", "IllegalAccessError", "IncompatibleClassChangeError", "InstantiationError", "InternalError", "LinkageError", "NoClassDefFoundError", "NoSuchFieldError", "NoSuchMethodError", "OutOfMemoryError", "StackOverflowError", "ThreadDeath", "UnknownError", "UnsatisfiedLinkError", "UnsupportedClassVersionError", "VerifyError", "VirtualMachineError", "Deprecated", "Override", "SafeVarargs", "SuppressWarnings");

    public static boolean areEquivalent(String left, String right) {
        if (left == null && right == null) {
            return true;
        }
        if (left == null || right == null) {
            return false;
        }
        if (left.equals(right)) {
            return true;
        }
        left = Types.stripGenerics(left);
        right = Types.stripGenerics(right);
        String l = Types.toSimpleName(left);
        String r = Types.toSimpleName(right);
        String lp = Types.getPackage(left);
        String rp = Types.getPackage(right);
        if (l.equals(r)) {
            return lp.isEmpty() || rp.isEmpty();
        }
        return false;
    }

    public static String toSimpleName(String type) {
        String[] tokens;
        if (type == null) {
            return null;
        }
        String result = type;
        if (Types.isGeneric(type)) {
            result = Types.stripGenerics(result);
        }
        if ((tokens = Types.tokenizeClassName(result)) != null) {
            result = tokens[tokens.length - 1];
        }
        if (Types.isGeneric(type)) {
            ArrayList<String> simpleParameters = new ArrayList<String>();
            for (String typeParameter : Types.getGenericsTypeParameter(type).split(", ")) {
                Matcher matcher = WILDCARD_AWARE_TYPE_PATTERN.matcher(typeParameter);
                if (!matcher.matches()) {
                    throw new IllegalArgumentException("Cannot parse type parameter " + typeParameter);
                }
                String simpleType = Types.toSimpleName(matcher.group(2));
                if (matcher.start(1) >= 0) {
                    simpleType = (matcher.group(1) + ' ' + simpleType).replaceAll("\\s{2,}?", " ");
                }
                simpleParameters.add(simpleType);
            }
            result = result + new StringBuilder("<>").insert(1, Strings.join(simpleParameters, ", ")).toString();
        }
        return result;
    }

    public static String[] tokenizeClassName(String className) {
        String[] result = null;
        if (className != null) {
            result = className.split("\\.");
        }
        return result;
    }

    public static boolean isQualified(String className) {
        String[] tokens = Types.tokenizeClassName(className);
        return tokens != null && tokens.length > 1;
    }

    public static String getPackage(String className) {
        if (className.indexOf(".") > -1) {
            return className.substring(0, className.lastIndexOf("."));
        }
        return "";
    }

    public static boolean isSimpleName(String name) {
        return name != null && name.matches("(?i)(?![0-9])[a-z0-9$_]+");
    }

    public static boolean isJavaLang(String type) {
        String javaLang = "java.lang.";
        String check = type.startsWith("java.lang.") ? type.substring("java.lang.".length()) : type;
        return LANG_TYPES.contains(check);
    }

    public static boolean isBasicType(String idType) {
        return Types.isPrimitive(idType) || Arrays.asList("Boolean", "Byte", "Double", "Float", "Integer", "Long", "Short", "String").contains(idType);
    }

    public static boolean isGeneric(String type) {
        return type != null && GENERIC_PATTERN.matcher(type).matches();
    }

    public static String stripGenerics(String type) {
        String componentType;
        int arrayDimensions;
        if (Types.isArray(type)) {
            arrayDimensions = Types.getArrayDimension(type);
            componentType = Types.stripArray(type);
        } else {
            arrayDimensions = 0;
            componentType = type;
        }
        StringBuilder result = new StringBuilder();
        if (Types.isGeneric(componentType)) {
            result.append(componentType.replaceFirst("^([^<]*)<.*?>$", "$1"));
        } else {
            result.append(componentType);
        }
        for (int i = 0; i < arrayDimensions; ++i) {
            result.append("[]");
        }
        return result.toString();
    }

    public static String getGenerics(String type) {
        if (Types.isGeneric(type)) {
            return new StringBuilder("<>").insert(1, Types.getGenericsTypeParameter(type)).toString();
        }
        return "";
    }

    public static String getGenericsTypeParameter(String type) {
        if (Types.isGeneric(type)) {
            return type.replaceFirst("^[^<]*<(.*?)>$", "$1");
        }
        return "";
    }

    public static boolean isArray(String type) {
        return type != null && (SIMPLE_ARRAY_PATTERN.matcher(type).matches() || CLASS_ARRAY_PATTERN.matcher(type).matches());
    }

    public static String stripArray(String type) {
        String result = type;
        if (Types.isArray(type)) {
            Matcher matcher = SIMPLE_ARRAY_PATTERN.matcher(type);
            if (matcher.find()) {
                result = matcher.group(1);
            } else {
                matcher = CLASS_ARRAY_PATTERN.matcher(type);
                if (matcher.find()) {
                    switch (matcher.group(1).charAt(0)) {
                        case 'B': {
                            result = "byte";
                            break;
                        }
                        case 'F': {
                            result = "float";
                            break;
                        }
                        case 'C': {
                            result = "char";
                            break;
                        }
                        case 'D': {
                            result = "double";
                            break;
                        }
                        case 'I': {
                            result = "int";
                            break;
                        }
                        case 'J': {
                            result = "long";
                            break;
                        }
                        case 'S': {
                            result = "short";
                            break;
                        }
                        case 'Z': {
                            result = "boolean";
                            break;
                        }
                        case 'L': {
                            result = matcher.group(2);
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Invalid array format " + type);
                        }
                    }
                }
            }
        }
        return result;
    }

    public static boolean isPrimitive(String result) {
        return Arrays.asList("byte", "short", "int", "long", "float", "double", "boolean", "char").contains(result);
    }

    public static int getArrayDimension(String name) {
        int count = 0;
        if (name != null) {
            for (char c : name.toCharArray()) {
                if (c != '[') continue;
                ++count;
            }
        }
        return count;
    }
}

