/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.cl.parser;

public class ParsedCompleteObject {
    private String name;
    private String value = "";
    private Class<?> type;
    private final boolean option;
    private boolean displayOptions = false;
    private boolean argument = false;
    private final boolean displayArguments = false;
    private boolean completeOptionName = false;
    private int offset = 0;

    public ParsedCompleteObject(boolean displayArguments) {
        this.option = !displayArguments;
        this.argument = !this.option;
    }

    public ParsedCompleteObject(boolean displayOptions, String name, int offset) {
        this.displayOptions = displayOptions;
        this.offset = offset;
        this.name = name;
        this.value = "";
        this.type = null;
        this.option = false;
    }

    public ParsedCompleteObject(boolean displayOptions, String name, int offset, boolean completeOptionName) {
        this(displayOptions, name, offset);
        this.completeOptionName = completeOptionName;
    }

    public ParsedCompleteObject(String name, String value, Class<?> type, boolean option, boolean completeOptionName) {
        this(name, value, type, option);
        this.completeOptionName = completeOptionName;
    }

    public ParsedCompleteObject(String name, String value, Class<?> type, boolean option) {
        this.name = name;
        this.value = value;
        this.type = type;
        this.option = option;
        this.argument = !this.option;
        this.offset = value.length();
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public Class<?> getType() {
        return this.type;
    }

    public boolean isOption() {
        return this.option;
    }

    public boolean isArgument() {
        return this.argument;
    }

    public int getOffset() {
        return this.offset;
    }

    public boolean doDisplayOptions() {
        return this.displayOptions;
    }

    public boolean isCompleteOptionName() {
        return this.completeOptionName;
    }

    public String toString() {
        return "ParsedCompleteObject{name='" + this.name + '\'' + ", value='" + this.value + '\'' + ", type=" + this.type + ", option=" + this.option + ", argument=" + this.argument + ", displayOptions=" + this.displayOptions + ", displayArguments=" + false + ", completeOptionName=" + this.completeOptionName + ", offset=" + this.offset + '}';
    }
}

