/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jboss.aesh.comparators.PosixFileNameComparator;
import org.jboss.aesh.complete.CompleteOperation;
import org.jboss.aesh.console.Config;
import org.jboss.aesh.constants.AeshConstants;
import org.jboss.aesh.io.Resource;
import org.jboss.aesh.io.filter.AllResourceFilter;
import org.jboss.aesh.io.filter.ResourceFilter;
import org.jboss.aesh.parser.Parser;
import org.jboss.aesh.terminal.TerminalString;

public class FileLister {
    private String token;
    private Resource cwd;
    private String rest;
    private String lastDir;
    private ResourceFilter fileFilter;
    private Comparator fileComparator;

    public FileLister(String token, Resource cwd) {
        if (token == null) {
            throw new IllegalArgumentException("Incoming directory cannot be null");
        }
        if (cwd == null) {
            throw new IllegalArgumentException("Current working directory cannot be null");
        }
        this.token = Parser.switchEscapedSpacesToSpacesInWord(token);
        this.cwd = cwd;
        this.findRestAndLastDir();
        this.setFileFilter(new AllResourceFilter());
    }

    public FileLister(String token, Resource cwd, Comparator comparator) {
        this(token, cwd);
        this.fileComparator = comparator;
    }

    public FileLister(String token, Resource cwd, ResourceFilter filter) {
        this(token, cwd);
        this.setFileFilter(filter);
    }

    public FileLister(String token, Resource cwd, ResourceFilter filter, Comparator fileComparator) {
        this(token, cwd, filter);
        this.fileComparator = fileComparator;
    }

    private void setFileFilter(ResourceFilter filter) {
        this.fileFilter = filter;
    }

    public void findMatchingDirectories(CompleteOperation completion) {
        completion.doAppendSeparator(false);
        if (this.token.trim().isEmpty()) {
            completion.addCompletionCandidates(this.listDirectory(this.cwd, null));
        } else if (!this.containStar() && !this.containWildCards()) {
            List<String> tmpDirs;
            if (this.startWithHome()) {
                if (this.isHomeAndTokenADirectory()) {
                    if (this.tokenEndsWithSlash()) {
                        completion.addCompletionCandidates(this.listDirectory(this.cwd.newInstance(Config.getHomeDir() + this.token.substring(1)), null));
                    } else {
                        tmpDirs = this.listDirectory(this.cwd.newInstance(Config.getHomeDir()), this.token.substring(2));
                        if (tmpDirs.size() == 1 || this.endsWithParent()) {
                            completion.addCompletionCandidate(Config.getPathSeparator());
                        } else {
                            completion.addCompletionCandidates(tmpDirs);
                        }
                    }
                } else if (this.isHomeAndTokenAFile()) {
                    completion.addCompletionCandidate("");
                    completion.doAppendSeparator(true);
                } else {
                    this.listPossibleDirectories(completion);
                }
            } else if (!this.startWithSlash() && !this.startWithWindowsDrive()) {
                if (this.isCwdAndTokenADirectory()) {
                    if (this.tokenEndsWithSlash()) {
                        completion.addCompletionCandidates(this.listDirectory(this.cwd.newInstance(this.cwd.getAbsolutePath() + Config.getPathSeparator() + this.token), null));
                    } else {
                        tmpDirs = this.lastDir != null ? this.listDirectory(this.cwd.newInstance(this.cwd.getAbsolutePath() + Config.getPathSeparator() + this.lastDir), this.rest) : this.listDirectory(this.cwd, this.rest);
                        if (tmpDirs.size() == 1 || this.endsWithParent()) {
                            completion.addCompletionCandidate(this.rest + Config.getPathSeparator());
                        } else {
                            completion.addCompletionCandidates(tmpDirs);
                        }
                    }
                } else if (this.isCwdAndTokenAFile()) {
                    this.listPossibleDirectories(completion);
                    if (completion.getCompletionCandidates().size() == 1) {
                        completion.getCompletionCandidates().set(0, new TerminalString("", true));
                        completion.doAppendSeparator(true);
                    } else if (completion.getCompletionCandidates().size() == 0) {
                        completion.addCompletionCandidate("");
                        completion.doAppendSeparator(true);
                    }
                } else {
                    this.listPossibleDirectories(completion);
                }
            } else if (this.startWithSlash() || this.startWithWindowsDrive()) {
                if (this.isTokenADirectory()) {
                    if (this.tokenEndsWithSlash()) {
                        completion.addCompletionCandidates(this.listDirectory(this.cwd.newInstance(this.token), null));
                    } else {
                        completion.addCompletionCandidate(Config.getPathSeparator());
                    }
                } else if (this.isTokenAFile()) {
                    this.listPossibleDirectories(completion);
                    if (completion.getCompletionCandidates().size() == 1) {
                        completion.getCompletionCandidates().set(0, new TerminalString("", true));
                        completion.doAppendSeparator(true);
                    }
                } else {
                    this.listPossibleDirectories(completion);
                }
            }
        }
        if (completion.getCompletionCandidates().size() > 1) {
            String startsWith = Parser.findStartsWithTerminalString(completion.getCompletionCandidates());
            if (startsWith.contains(" ")) {
                startsWith = Parser.switchEscapedSpacesToSpacesInWord(startsWith);
            }
            if (startsWith != null && startsWith.length() > 0 && this.rest != null && startsWith.length() > this.rest.length()) {
                completion.getCompletionCandidates().clear();
                completion.addCompletionCandidate(Parser.switchSpacesToEscapedSpacesInWord(startsWith));
            }
        }
        if (completion.getCompletionCandidates().size() == 1) {
            if (this.isTokenADirectory() && !this.tokenEndsWithSlash() && (this.startWithSlash() || this.startWithWindowsDrive())) {
                completion.getCompletionCandidates().get(0).setCharacters(this.token + completion.getCompletionCandidates().get(0).getCharacters());
                completion.setOffset(completion.getCursor() - this.token.length());
            } else if (this.token != null) {
                if (this.rest != null && this.token.length() > this.rest.length()) {
                    completion.getCompletionCandidates().get(0).setCharacters(Parser.switchSpacesToEscapedSpacesInWord(this.token.substring(0, this.token.length() - this.rest.length())) + completion.getCompletionCandidates().get(0).getCharacters());
                    completion.setOffset(completion.getCursor() - this.token.length());
                } else if (this.rest != null && this.token.length() == this.rest.length()) {
                    completion.setOffset(completion.getCursor() - (this.rest.length() + Parser.findNumberOfSpacesInWord(this.rest)));
                } else {
                    if (this.token.endsWith(Config.getPathSeparator())) {
                        completion.getCompletionCandidates().get(0).setCharacters(Parser.switchSpacesToEscapedSpacesInWord(this.token) + completion.getCompletionCandidates().get(0).getCharacters());
                    }
                    completion.setOffset(completion.getCursor() - this.token.length());
                }
            } else {
                completion.setOffset(completion.getCursor());
            }
        } else if (completion.getCompletionCandidates().size() > 1) {
            completion.setIgnoreOffset(true);
            if (this.rest != null && this.rest.length() > 0) {
                completion.setOffset(completion.getCursor() - this.rest.length());
            }
        }
    }

    private void listPossibleDirectories(CompleteOperation completion) {
        List<String> returnFiles = this.startWithSlash() ? (this.lastDir != null && this.lastDir.startsWith(Config.getPathSeparator()) ? this.listDirectory(this.cwd.newInstance(this.lastDir), this.rest) : this.listDirectory(this.cwd.newInstance(Config.getPathSeparator() + this.lastDir), this.rest)) : (this.startWithWindowsDrive() ? (this.lastDir != null && this.lastDir.length() == 2 ? this.listDirectory(this.cwd.newInstance(this.lastDir + Config.getPathSeparator()), this.rest) : this.listDirectory(this.cwd.newInstance(this.lastDir), this.rest)) : (this.startWithHome() ? (this.lastDir != null ? this.listDirectory(this.cwd.newInstance(Config.getHomeDir() + this.lastDir.substring(1)), this.rest) : this.listDirectory(this.cwd.newInstance(Config.getHomeDir() + Config.getPathSeparator()), this.rest)) : (this.lastDir != null ? this.listDirectory(this.cwd.newInstance(this.cwd + Config.getPathSeparator() + this.lastDir), this.rest) : this.listDirectory(this.cwd, this.rest))));
        completion.addCompletionCandidates(returnFiles);
    }

    private void findRestAndLastDir() {
        if (this.token.contains(Config.getPathSeparator())) {
            this.lastDir = this.token.substring(0, this.token.lastIndexOf(Config.getPathSeparator()));
            this.rest = this.token.substring(this.token.lastIndexOf(Config.getPathSeparator()) + 1);
        } else if (this.token.trim().isEmpty()) {
            this.lastDir = this.token;
        } else {
            this.rest = this.token;
        }
    }

    private boolean isTokenADirectory() {
        return this.cwd.newInstance(this.token).isDirectory();
    }

    private boolean isTokenAFile() {
        return this.cwd.newInstance(this.token).isLeaf();
    }

    private boolean isCwdAndTokenADirectory() {
        return this.cwd.newInstance(this.cwd.getAbsolutePath() + Config.getPathSeparator() + this.token).isDirectory();
    }

    private boolean isCwdAndTokenAFile() {
        return this.cwd.newInstance(this.cwd.getAbsolutePath() + Config.getPathSeparator() + this.token).isLeaf();
    }

    private boolean isHomeAndTokenADirectory() {
        return this.cwd.newInstance(Config.getHomeDir() + this.token.substring(1)).isDirectory();
    }

    private boolean isHomeAndTokenAFile() {
        return this.cwd.newInstance(Config.getHomeDir() + this.token.substring(1)).isLeaf();
    }

    private boolean endsWithParent() {
        return this.token.length() > 1 && this.token.lastIndexOf("..") == this.token.length() - 2;
    }

    private boolean startWithHome() {
        return this.token.indexOf(AeshConstants.HOME) == 0;
    }

    private boolean containStar() {
        int index = this.token.indexOf(42);
        return index == 0 || index > 0 && this.token.charAt(index - 1) != '\\';
    }

    private boolean containWildCards() {
        int index = this.token.indexOf(63);
        return index == 0 || index > 0 && this.token.charAt(index - 1) != '\\';
    }

    private boolean startWithSlash() {
        return this.token.indexOf(Config.getPathSeparator()) == 0;
    }

    private boolean startWithWindowsDrive() {
        if (!Config.isOSPOSIXCompatible()) {
            for (Resource f : this.cwd.listRoots()) {
                if (!this.token.startsWith(f.toString())) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    private boolean tokenEndsWithSlash() {
        return this.token.lastIndexOf(Config.getPathSeparator()) == this.token.length() - 1;
    }

    private List<String> listDirectory(Resource path, String rest) {
        ArrayList<String> fileNames = new ArrayList<String>();
        if (path != null && !path.isLeaf()) {
            for (Resource file : path.list(this.fileFilter)) {
                if (rest == null || rest.length() == 0) {
                    if (!file.isLeaf()) {
                        fileNames.add(Parser.switchSpacesToEscapedSpacesInWord(file.getName()) + Config.getPathSeparator());
                        continue;
                    }
                    fileNames.add(Parser.switchSpacesToEscapedSpacesInWord(file.getName()));
                    continue;
                }
                if (!file.getName().startsWith(rest)) continue;
                if (!file.isLeaf()) {
                    fileNames.add(Parser.switchSpacesToEscapedSpacesInWord(file.getName()) + Config.getPathSeparator());
                    continue;
                }
                fileNames.add(Parser.switchSpacesToEscapedSpacesInWord(file.getName()));
            }
        }
        if (this.fileComparator == null) {
            this.fileComparator = new PosixFileNameComparator();
        }
        Collections.sort(fileNames, this.fileComparator);
        return fileNames;
    }

    public String toString() {
        return "FileLister{token='" + this.token + '\'' + ", cwd=" + this.cwd + ", rest='" + this.rest + '\'' + ", lastDir='" + this.lastDir + '\'' + '}';
    }
}

