/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.roaster.model.impl;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.jboss.forge.roaster.Roaster;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.AST;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.ASTNode;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.ArrayInitializer;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.BodyDeclaration;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.Expression;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.MemberValuePair;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.NormalAnnotation;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.TypeLiteral;
import org.jboss.forge.roaster.model.Annotation;
import org.jboss.forge.roaster.model.JavaClass;
import org.jboss.forge.roaster.model.ValuePair;
import org.jboss.forge.roaster.model.impl.TypeImpl;
import org.jboss.forge.roaster.model.impl.ValuePairImpl;
import org.jboss.forge.roaster.model.source.AnnotationSource;
import org.jboss.forge.roaster.model.source.AnnotationTargetSource;
import org.jboss.forge.roaster.model.source.JavaSource;
import org.jboss.forge.roaster.model.util.Assert;
import org.jboss.forge.roaster.model.util.Strings;

public class AnnotationImpl<O extends JavaSource<O>, T>
implements AnnotationSource<O> {
    private static final String DEFAULT_VALUE = "value";
    private AnnotationTargetSource<O, T> parent = null;
    private AST ast = null;
    private org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.Annotation annotation;

    public AnnotationImpl(AnnotationTargetSource<O, T> parent) {
        this(parent, AnnotationType.MARKER);
    }

    public AnnotationImpl(AnnotationTargetSource<O, T> parent, Object internal) {
        this.parent = parent;
        this.ast = ((ASTNode)parent.getInternal()).getAST();
        Assert.notNull((Object)internal, (String)"internal representation must not be null");
        this.annotation = (org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.Annotation)internal;
    }

    public AnnotationImpl(AnnotationTargetSource<O, T> parent, AnnotationType type) {
        this(parent, AnnotationImpl.createAnnotation(parent, type));
    }

    private static org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.Annotation createAnnotation(AnnotationTargetSource<?, ?> parent, AnnotationType type) {
        AST ast = ((ASTNode)parent.getInternal()).getAST();
        switch (type) {
            case MARKER: {
                return ast.newMarkerAnnotation();
            }
            case SINGLE: {
                return ast.newSingleMemberAnnotation();
            }
            case NORMAL: {
                return ast.newNormalAnnotation();
            }
        }
        throw new IllegalArgumentException("Unknown annotation type: " + (Object)((Object)type));
    }

    public String getName() {
        return this.annotation.getTypeName().getFullyQualifiedName();
    }

    public String getQualifiedName() {
        return ((JavaSource)this.parent.getOrigin()).resolveType(this.getName());
    }

    public String getLiteralValue() throws IllegalStateException {
        if (this.isSingleValue()) {
            return ((SingleMemberAnnotation)this.annotation).getValue().toString();
        }
        if (this.isNormal()) {
            List<ValuePair> values = this.getValues();
            for (ValuePair pair : values) {
                String name = pair.getName();
                if (!DEFAULT_VALUE.equals(name)) continue;
                return pair.getLiteralValue();
            }
        }
        return null;
    }

    public String getLiteralValue(String name) {
        if (DEFAULT_VALUE.equals(name) && this.isSingleValue()) {
            return this.getLiteralValue();
        }
        if (this.isNormal()) {
            for (Object v : ((NormalAnnotation)this.annotation).values()) {
                MemberValuePair pair;
                if (!(v instanceof MemberValuePair) || !(pair = (MemberValuePair)v).getName().getFullyQualifiedName().equals(name)) continue;
                return pair.getValue().toString();
            }
        }
        return null;
    }

    public List<ValuePair> getValues() {
        ArrayList<ValuePairImpl> result = new ArrayList<ValuePairImpl>();
        if (this.isNormal()) {
            for (Object v : ((NormalAnnotation)this.annotation).values()) {
                if (!(v instanceof MemberValuePair)) continue;
                MemberValuePair pair = (MemberValuePair)v;
                ValuePairImpl temp = new ValuePairImpl(pair.getName().getFullyQualifiedName(), pair.getValue().toString());
                result.add(temp);
            }
        } else if (this.isSingleValue()) {
            result.add(new ValuePairImpl(DEFAULT_VALUE, this.getLiteralValue()));
        }
        return Collections.unmodifiableList(result);
    }

    public String getStringValue() throws IllegalStateException {
        return Strings.unquote((String)this.getLiteralValue());
    }

    public String getStringValue(String name) {
        return Strings.unquote((String)this.getLiteralValue(name));
    }

    public boolean isMarker() {
        return this.annotation.isMarkerAnnotation();
    }

    public boolean isNormal() {
        return this.annotation.isNormalAnnotation();
    }

    public boolean isSingleValue() {
        return this.annotation.isSingleMemberAnnotation();
    }

    public AnnotationSource<O> removeAllValues() {
        this.convertTo(AnnotationType.MARKER);
        return this;
    }

    public AnnotationSource<O> removeValue(String name) {
        if (this.annotation.isNormalAnnotation()) {
            NormalAnnotation na = (NormalAnnotation)this.annotation;
            ArrayList<MemberValuePair> toBeRemoved = new ArrayList<MemberValuePair>();
            for (Object v : na.values()) {
                MemberValuePair pair;
                if (!(v instanceof MemberValuePair) || !(pair = (MemberValuePair)v).getName().toString().equals(name)) continue;
                toBeRemoved.add(pair);
            }
            na.values().removeAll(toBeRemoved);
            if (this.getLiteralValue() != null && this.getValues().size() == 1) {
                this.convertTo(AnnotationType.SINGLE);
            } else if (this.getValues().size() == 0) {
                this.convertTo(AnnotationType.MARKER);
            }
        } else if (this.annotation.isSingleMemberAnnotation()) {
            this.removeAllValues();
        }
        return this;
    }

    public AnnotationSource<O> setName(String className) {
        this.annotation.setTypeName(this.ast.newName(className));
        return this;
    }

    public AnnotationSource<O> setLiteralValue(String value) {
        Assert.notNull((Object)value, (String)"null not accepted");
        if (this.isMarker()) {
            this.convertTo(AnnotationType.SINGLE);
        }
        if (this.isSingleValue()) {
            SingleMemberAnnotation sa = (SingleMemberAnnotation)this.annotation;
            String stub = "@" + this.getName() + "(" + value + ") public class Stub { }";
            JavaClass temp = (JavaClass)Roaster.parse(JavaClass.class, (String)stub);
            SingleMemberAnnotation anno = (SingleMemberAnnotation)((Annotation)temp.getAnnotations().get(0)).getInternal();
            Expression expression = anno.getValue();
            sa.setValue((Expression)ASTNode.copySubtree(this.ast, expression));
        } else {
            this.setLiteralValue(DEFAULT_VALUE, value);
        }
        return this;
    }

    public AnnotationSource<O> setLiteralValue(String name, String value) {
        Assert.notNull((Object)value, (String)"null not accepted");
        if (!this.isNormal() && !DEFAULT_VALUE.equals(name)) {
            this.convertTo(AnnotationType.NORMAL);
        } else if (!this.isSingleValue() && !this.isNormal() && DEFAULT_VALUE.equals(name)) {
            this.convertTo(AnnotationType.SINGLE);
        }
        if (this.isSingleValue() && DEFAULT_VALUE.equals(name)) {
            return this.setLiteralValue(value);
        }
        NormalAnnotation na = (NormalAnnotation)this.annotation;
        String stub = "@" + this.getName() + "(" + name + "=" + value + " ) public class Stub { }";
        JavaClass temp = (JavaClass)Roaster.parse(JavaClass.class, (String)stub);
        NormalAnnotation anno = (NormalAnnotation)((Annotation)temp.getAnnotations().get(0)).getInternal();
        MemberValuePair mvp = (MemberValuePair)anno.values().get(0);
        List values = na.values();
        ListIterator<MemberValuePair> iter = values.listIterator();
        while (iter.hasNext()) {
            if (!((MemberValuePair)iter.next()).getName().getIdentifier().equals(name)) continue;
            iter.remove();
            break;
        }
        iter.add((MemberValuePair)ASTNode.copySubtree(this.annotation.getAST(), mvp));
        return this;
    }

    public AnnotationSource<O> setStringValue(String value) {
        return this.setLiteralValue(Strings.enquote((String)value));
    }

    public AnnotationSource<O> setStringValue(String name, String value) {
        return this.setLiteralValue(name, Strings.enquote((String)value));
    }

    public <E extends Enum<E>> E getEnumValue(Class<E> type) {
        String literalValue = this.getLiteralValue();
        return this.convertLiteralToEnum(type, literalValue);
    }

    public <E extends Enum<E>> E getEnumValue(Class<E> type, String name) {
        String literalValue = this.getLiteralValue(name);
        return this.convertLiteralToEnum(type, literalValue);
    }

    private <E extends Enum<E>> E convertLiteralToEnum(Class<E> type, String literalValue) {
        Enum[] constants;
        for (Enum inst : constants = (Enum[])type.getEnumConstants()) {
            String[] tokens = literalValue.split("\\.");
            if (tokens.length > 1) {
                literalValue = tokens[tokens.length - 1];
            }
            if (!inst.name().equals(literalValue)) continue;
            return (E)inst;
        }
        return null;
    }

    public AnnotationSource<O> setEnumValue(String name, Enum<?> value) {
        return this.setEnumArrayValue(name, value);
    }

    public AnnotationSource<O> setEnumValue(Enum<?> ... values) {
        return this.setEnumArrayValue(values);
    }

    public AnnotationSource<O> setEnumArrayValue(Enum<?> ... values) {
        return this.setEnumArrayValue(DEFAULT_VALUE, values);
    }

    public AnnotationSource<O> setEnumArrayValue(String name, Enum<?> ... values) {
        Assert.notNull(values, (String)"null array not accepted");
        ArrayList<String> literals = new ArrayList<String>();
        for (Enum<?> value : values) {
            Assert.notNull(value, (String)"null value not accepted");
            this.getOrigin().addImport(value.getDeclaringClass());
            literals.add(value.getDeclaringClass().getSimpleName() + "." + value.name());
        }
        return this.setLiteralValue(name, literals.size() == 1 ? (String)literals.get(0) : String.format("{%s}", Strings.join(literals, (String)",")));
    }

    public O getOrigin() {
        return (O)((JavaSource)this.parent.getOrigin());
    }

    public Object getInternal() {
        return this.annotation;
    }

    public String toString() {
        return this.annotation.toString();
    }

    protected void replace(org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.Annotation oldNode, org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.Annotation newNode) {
        List modifiers;
        ASTNode parentNode = oldNode.getParent();
        if (parentNode instanceof BodyDeclaration) {
            modifiers = ((BodyDeclaration)parentNode).modifiers();
        } else if (parentNode instanceof SingleVariableDeclaration) {
            modifiers = ((SingleVariableDeclaration)parentNode).modifiers();
        } else {
            throw new IllegalStateException("Cannot handle annotations attached to " + parentNode);
        }
        int pos = modifiers.indexOf(this.annotation);
        if (pos >= 0) {
            modifiers.set(pos, newNode);
        }
    }

    private void convertTo(AnnotationType type) {
        if (this.isMarker() && type != AnnotationType.MARKER || this.isSingleValue() && type != AnnotationType.SINGLE || this.isNormal() && type != AnnotationType.NORMAL) {
            String value = this.getLiteralValue();
            AnnotationImpl<O, T> na = new AnnotationImpl<O, T>(this.parent, type);
            na.setName(this.getName());
            this.replace(this.annotation, na.annotation);
            this.annotation = na.annotation;
            if (AnnotationType.MARKER != type && value != null) {
                this.setLiteralValue(value);
            }
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.annotation == null ? 0 : this.annotation.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AnnotationImpl other = (AnnotationImpl)obj;
        return !(this.annotation == null ? other.annotation != null : !this.annotation.equals(other.annotation));
    }

    public AnnotationSource<O> setAnnotationValue() {
        if (this.isMarker()) {
            this.convertTo(AnnotationType.SINGLE);
        }
        if (this.isSingleValue()) {
            Nested result = new Nested(this);
            ((SingleMemberAnnotation)this.annotation).setValue((Expression)result.getInternal());
            return result;
        }
        return this.setAnnotationValue(DEFAULT_VALUE);
    }

    public AnnotationSource<O> setAnnotationValue(String name) {
        if (!this.isNormal() && DEFAULT_VALUE.equals(name)) {
            return this.setAnnotationValue();
        }
        if (!this.isNormal()) {
            this.convertTo(AnnotationType.NORMAL);
        }
        Nested result = new Nested(this);
        String stub = "@" + this.getName() + "(" + name + "= 0 ) public class Stub { }";
        JavaClass temp = (JavaClass)Roaster.parse(JavaClass.class, (String)stub);
        NormalAnnotation anno = (NormalAnnotation)((Annotation)temp.getAnnotations().get(0)).getInternal();
        MemberValuePair mvp = (MemberValuePair)anno.values().get(0);
        List values = ((NormalAnnotation)this.annotation).values();
        ListIterator<MemberValuePair> iter = values.listIterator();
        while (iter.hasNext()) {
            if (!((MemberValuePair)iter.next()).getName().getIdentifier().equals(name)) continue;
            iter.remove();
            break;
        }
        MemberValuePair mvpCopy = (MemberValuePair)ASTNode.copySubtree(this.annotation.getAST(), mvp);
        mvpCopy.setValue((Expression)result.getInternal());
        iter.add(mvpCopy);
        return result;
    }

    public AnnotationSource<O> addAnnotationValue() {
        Expression expr;
        if (this.isNormal()) {
            return this.addAnnotationValue(DEFAULT_VALUE);
        }
        if (this.isMarker()) {
            this.convertTo(AnnotationType.SINGLE);
        }
        if ((expr = ((SingleMemberAnnotation)this.annotation).getValue()) instanceof org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.Annotation) {
            ArrayInitializer arrayInit = this.ast.newArrayInitializer();
            boolean junk = arrayInit.expressions().add(ASTNode.copySubtree(this.ast, expr));
            ((SingleMemberAnnotation)this.annotation).setValue(arrayInit);
            expr = arrayInit;
        }
        if (expr instanceof ArrayInitializer) {
            org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.Annotation arrayElement = AnnotationImpl.createAnnotation(this.parent, AnnotationType.MARKER);
            if (((ArrayInitializer)expr).expressions().isEmpty()) {
                ((SingleMemberAnnotation)this.annotation).setValue(arrayElement);
            } else {
                boolean bl = ((ArrayInitializer)expr).expressions().add(arrayElement);
            }
            return new Nested(this, arrayElement);
        }
        return this.setAnnotationValue();
    }

    public AnnotationSource<O> addAnnotationValue(String name) {
        if (!this.isNormal()) {
            if (DEFAULT_VALUE.equals(name)) {
                return this.addAnnotationValue();
            }
            this.convertTo(AnnotationType.NORMAL);
        }
        MemberValuePair memberValuePair = null;
        for (Object value : ((NormalAnnotation)this.annotation).values()) {
            if (!(value instanceof MemberValuePair) || !Strings.areEqual((String)name, (String)((MemberValuePair)value).getName().getIdentifier())) continue;
            memberValuePair = (MemberValuePair)value;
            break;
        }
        if (memberValuePair != null) {
            boolean junk;
            Expression expr = memberValuePair.getValue();
            if (expr instanceof org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.Annotation) {
                ArrayInitializer arrayInit = this.ast.newArrayInitializer();
                junk = arrayInit.expressions().add(ASTNode.copySubtree(this.ast, expr));
                memberValuePair.setValue(arrayInit);
                expr = arrayInit;
            }
            if (expr instanceof ArrayInitializer) {
                org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.Annotation arrayElement = AnnotationImpl.createAnnotation(this.parent, AnnotationType.MARKER);
                if (((ArrayInitializer)expr).expressions().isEmpty()) {
                    memberValuePair.setValue(arrayElement);
                } else {
                    junk = ((ArrayInitializer)expr).expressions().add(arrayElement);
                }
                return new Nested(this, arrayElement);
            }
        }
        return this.setAnnotationValue(name);
    }

    public AnnotationSource<O> addAnnotationValue(Class<? extends java.lang.annotation.Annotation> type) {
        if (!this.getOrigin().hasImport(type)) {
            this.getOrigin().addImport(type);
        }
        return this.addAnnotationValue().setName(type.getSimpleName());
    }

    public AnnotationSource<O> addAnnotationValue(String name, Class<? extends java.lang.annotation.Annotation> type) {
        if (!this.getOrigin().hasImport(type)) {
            this.getOrigin().addImport(type);
        }
        return this.addAnnotationValue(name).setName(type.getSimpleName());
    }

    public AnnotationSource<O> removeAnnotationValue(Annotation<O> element) {
        Assert.notNull(element, (String)"Cannot remove null element");
        if (this.isSingleValue()) {
            ArrayInitializer arrayInit;
            if (element.getInternal().equals(((SingleMemberAnnotation)this.annotation).getValue())) {
                this.convertTo(AnnotationType.MARKER);
            } else if (((SingleMemberAnnotation)this.annotation).getValue() instanceof ArrayInitializer && (arrayInit = (ArrayInitializer)((SingleMemberAnnotation)this.annotation).getValue()).expressions().remove(element.getInternal())) {
                if (arrayInit.expressions().isEmpty()) {
                    this.convertTo(AnnotationType.MARKER);
                } else if (arrayInit.expressions().size() == 1) {
                    ((SingleMemberAnnotation)this.annotation).setValue((Expression)ASTNode.copySubtree(this.ast, (ASTNode)arrayInit.expressions().get(0)));
                }
            }
            return this;
        }
        return this.removeAnnotationValue(DEFAULT_VALUE, element);
    }

    public AnnotationSource<O> removeAnnotationValue(String name, Annotation<O> element) {
        Assert.notNull(element, (String)"Cannot remove null element");
        if (this.isSingleValue() && Strings.areEqual((String)name, (String)DEFAULT_VALUE)) {
            return this.removeAnnotationValue(element);
        }
        if (this.isNormal()) {
            HashSet<String> identifiers = new HashSet<String>();
            Iterator values = ((NormalAnnotation)this.annotation).values().iterator();
            while (values.hasNext()) {
                Object value = values.next();
                if (!(value instanceof MemberValuePair)) continue;
                String identifier = ((MemberValuePair)value).getName().getIdentifier();
                identifiers.add(identifier);
                if (!Strings.areEqual((String)name, (String)identifier)) continue;
                Expression expr = ((MemberValuePair)value).getValue();
                if (element.getInternal().equals(expr)) {
                    values.remove();
                    identifiers.remove(identifier);
                    continue;
                }
                if (!(expr instanceof ArrayInitializer)) continue;
                ArrayInitializer arrayInit = (ArrayInitializer)expr;
                arrayInit.expressions().remove(element.getInternal());
                if (arrayInit.expressions().isEmpty()) {
                    values.remove();
                    identifiers.remove(identifier);
                    continue;
                }
                if (arrayInit.expressions().size() != 1) continue;
                ((MemberValuePair)value).setValue((Expression)ASTNode.copySubtree(this.ast, (ASTNode)arrayInit.expressions().get(0)));
            }
            if (identifiers.isEmpty()) {
                this.convertTo(AnnotationType.MARKER);
            } else if (identifiers.equals(Collections.singleton(DEFAULT_VALUE))) {
                this.convertTo(AnnotationType.SINGLE);
            }
        }
        return this;
    }

    public AnnotationSource<O> getAnnotationValue() {
        if (this.isSingleValue()) {
            SingleMemberAnnotation single = (SingleMemberAnnotation)this.annotation;
            Expression value = single.getValue();
            if (value instanceof org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.Annotation) {
                return new Nested(this, value);
            }
            if (value instanceof ArrayInitializer && ((ArrayInitializer)value).expressions().size() == 1 && (value = (Expression)((ArrayInitializer)value).expressions().get(0)) instanceof org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.Annotation) {
                return new Nested(this, value);
            }
        }
        if (this.isNormal()) {
            return this.getAnnotationValue(DEFAULT_VALUE);
        }
        return null;
    }

    public AnnotationSource<O> getAnnotationValue(String name) {
        if (this.isNormal()) {
            NormalAnnotation normal = (NormalAnnotation)this.annotation;
            List values = normal.values();
            for (MemberValuePair memberValuePair : values) {
                if (!Strings.areEqual((String)name, (String)memberValuePair.getName().getIdentifier())) continue;
                Expression value = memberValuePair.getValue();
                if (value instanceof org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.Annotation) {
                    return new Nested(this, value);
                }
                if (!(value instanceof ArrayInitializer) || ((ArrayInitializer)value).expressions().size() != 1 || !((value = (Expression)((ArrayInitializer)value).expressions().get(0)) instanceof org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.Annotation)) continue;
                return new Nested(this, value);
            }
        }
        if (this.isSingleValue() && DEFAULT_VALUE.equals(name)) {
            return this.getAnnotationValue();
        }
        return null;
    }

    public AnnotationSource<O>[] getAnnotationArrayValue() {
        return this.getAnnotationArrayValue(DEFAULT_VALUE);
    }

    public AnnotationSource<O>[] getAnnotationArrayValue(String name) {
        Object expr = this.getElementValueExpression(name);
        if (expr instanceof ArrayInitializer) {
            ArrayList<Nested> results = new ArrayList<Nested>();
            List arrayElements = ((ArrayInitializer)expr).expressions();
            for (Expression arrayElement : arrayElements) {
                Nested instance = new Nested(this, arrayElement);
                results.add(instance);
            }
            AnnotationSource[] result = new AnnotationSource[results.size()];
            return results.toArray(result);
        }
        AnnotationSource<O> annotationValue = this.getAnnotationValue(name);
        if (annotationValue != null) {
            AnnotationSource[] result = new AnnotationSource[]{annotationValue};
            return result;
        }
        return null;
    }

    public <E extends Enum<E>> E[] getEnumArrayValue(Class<E> type) {
        return this.getEnumArrayValue(type, DEFAULT_VALUE);
    }

    public <E extends Enum<E>> E[] getEnumArrayValue(Class<E> type, String name) {
        E instance;
        E expr = this.getElementValueExpression(name);
        if (expr instanceof ArrayInitializer) {
            ArrayList<E> results = new ArrayList<E>();
            List arrayElements = ((ArrayInitializer)expr).expressions();
            for (Expression arrayElement : arrayElements) {
                E instance2 = this.convertLiteralToEnum(type, arrayElement.toString());
                results.add(instance2);
            }
            Enum[] result = (Enum[])Array.newInstance(type, results.size());
            return results.toArray(result);
        }
        if (expr != null && type.isInstance(instance = this.convertLiteralToEnum(type, ((ASTNode)expr).toString()))) {
            Enum[] result = (Enum[])Array.newInstance(type, 1);
            result[0] = instance;
            return result;
        }
        return null;
    }

    public Class<?> getClassValue() {
        return this.getClassValue(DEFAULT_VALUE);
    }

    public Class<?> getClassValue(String name) {
        TypeLiteral typeLiteral = (TypeLiteral)this.getElementValueExpression(name);
        return this.resolveTypeLiteral(typeLiteral);
    }

    public Class<?>[] getClassArrayValue() {
        return this.getClassArrayValue(DEFAULT_VALUE);
    }

    public Class<?>[] getClassArrayValue(String name) {
        Object expr = this.getElementValueExpression(name);
        if (expr instanceof ArrayInitializer) {
            ArrayList result = new ArrayList();
            List arrayElements = ((ArrayInitializer)expr).expressions();
            for (Expression expression : arrayElements) {
                Class<?> type = this.resolveTypeLiteral((TypeLiteral)expression);
                result.add(type);
            }
            return result.toArray(new Class[result.size()]);
        }
        if (expr instanceof TypeLiteral) {
            return new Class[]{this.resolveTypeLiteral((TypeLiteral)expr)};
        }
        return null;
    }

    public String[] getStringArrayValue() {
        return this.getStringArrayValue(DEFAULT_VALUE);
    }

    public String[] getStringArrayValue(String name) {
        ArrayList<String> result = new ArrayList<String>();
        String literalValue = this.getLiteralValue(name);
        if (literalValue.startsWith("{") && literalValue.endsWith("}")) {
            literalValue = literalValue.substring(1, literalValue.length() - 1);
        }
        for (String value : literalValue.split(",")) {
            result.add(Strings.unquote((String)value));
        }
        return result.toArray(new String[result.size()]);
    }

    public AnnotationSource<O> setClassValue(String name, Class<?> value) {
        Assert.notNull(value, (String)"null not accepted");
        if (!value.isPrimitive()) {
            this.getOrigin().addImport(value);
        }
        return this.setLiteralValue(name, value.getSimpleName() + ".class");
    }

    public AnnotationSource<O> setClassValue(Class<?> value) {
        return this.setClassValue(DEFAULT_VALUE, value);
    }

    public AnnotationSource<O> setClassArrayValue(Class<?> ... values) {
        return this.setClassArrayValue(DEFAULT_VALUE, values);
    }

    public AnnotationSource<O> setStringArrayValue(String[] values) {
        return this.setStringArrayValue(DEFAULT_VALUE, values);
    }

    public AnnotationSource<O> setStringArrayValue(String name, String[] values) {
        Assert.notNull((Object)values, (String)"null array not accepted");
        ArrayList<String> literals = new ArrayList<String>();
        for (String value : values) {
            Assert.notNull((Object)value, (String)"null value not accepted");
            literals.add(Strings.enquote((String)value));
        }
        return this.setLiteralValue(name, literals.size() == 1 ? (String)literals.get(0) : String.format("{%s}", Strings.join(literals, (String)",")));
    }

    public AnnotationSource<O> setClassArrayValue(String name, Class<?> ... values) {
        Assert.notNull(values, (String)"null array not accepted");
        ArrayList<String> literals = new ArrayList<String>();
        for (Class<?> value : values) {
            Assert.notNull(value, (String)"null value not accepted");
            if (!value.isPrimitive()) {
                this.getOrigin().addImport(value);
            }
            literals.add(value.getSimpleName() + ".class");
        }
        return this.setLiteralValue(name, literals.size() == 1 ? (String)literals.get(0) : String.format("{%s}", Strings.join(literals, (String)",")));
    }

    private <E extends Expression> E getElementValueExpression(String name) {
        if (this.isSingleValue() && DEFAULT_VALUE.equals(name)) {
            Expression result = ((SingleMemberAnnotation)this.annotation).getValue();
            return (E)result;
        }
        if (this.isNormal()) {
            for (Object v : ((NormalAnnotation)this.annotation).values()) {
                MemberValuePair pair;
                if (!(v instanceof MemberValuePair) || !(pair = (MemberValuePair)v).getName().getFullyQualifiedName().equals(name)) continue;
                Expression result = pair.getValue();
                return (E)result;
            }
        }
        return null;
    }

    private Class<?> resolveTypeLiteral(TypeLiteral typeLiteral) {
        TypeImpl<O> type = new TypeImpl<O>(this.getOrigin(), typeLiteral.getType());
        if (type.isPrimitive()) {
            Class[] primitiveTypes;
            for (Class c : primitiveTypes = new Class[]{Boolean.TYPE, Byte.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE}) {
                if (!c.getSimpleName().equals(type.getName())) continue;
                return c;
            }
            return null;
        }
        String classname = type.getQualifiedName();
        try {
            return Class.forName(this.getOrigin().resolveType(classname));
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public boolean isTypeElementDefined(String name) {
        List<ValuePair> values = this.getValues();
        for (ValuePair pair : values) {
            if (!pair.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public static enum AnnotationType {
        MARKER,
        SINGLE,
        NORMAL;

    }

    private class Nested
    extends AnnotationImpl<O, T> {
        Nested(AnnotationImpl<O, T> owner) {
            super(owner.parent);
        }

        Nested(AnnotationImpl<O, T> owner, Object internal) {
            super(owner.parent, internal);
        }

        @Override
        protected void replace(org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.Annotation oldNode, org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.Annotation newNode) {
            if (oldNode.getParent() instanceof SingleMemberAnnotation) {
                ((SingleMemberAnnotation)oldNode.getParent()).setValue(newNode);
            } else if (oldNode.getParent() instanceof MemberValuePair) {
                ((MemberValuePair)oldNode.getParent()).setValue(newNode);
            } else if (oldNode.getParent() instanceof ArrayInitializer) {
                List expressions = ((ArrayInitializer)oldNode.getParent()).expressions();
                expressions.set(expressions.indexOf(oldNode), newNode);
            }
        }
    }
}

