/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.parser.java.ui;

import java.io.FileNotFoundException;
import java.util.List;
import javax.inject.Inject;
import org.jboss.forge.addon.convert.Converter;
import org.jboss.forge.addon.parser.java.beans.FieldOperations;
import org.jboss.forge.addon.parser.java.beans.ProjectOperations;
import org.jboss.forge.addon.parser.java.facets.JavaSourceFacet;
import org.jboss.forge.addon.parser.java.resources.JavaResource;
import org.jboss.forge.addon.parser.java.ui.JavaFieldCommand;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.projects.ProjectFactory;
import org.jboss.forge.addon.projects.ui.AbstractProjectCommand;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIContextProvider;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.context.UISelection;
import org.jboss.forge.addon.ui.input.UIInput;
import org.jboss.forge.addon.ui.input.UIPrompt;
import org.jboss.forge.addon.ui.input.UISelectOne;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.metadata.WithAttributes;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;
import org.jboss.forge.roaster.model.Field;
import org.jboss.forge.roaster.model.Visibility;
import org.jboss.forge.roaster.model.source.FieldSource;
import org.jboss.forge.roaster.model.source.JavaClassSource;
import org.jboss.forge.roaster.model.source.JavaSource;

public class JavaFieldCommandImpl
extends AbstractProjectCommand
implements JavaFieldCommand {
    @Inject
    @WithAttributes(label="Target Class", description="The class where the field will be created", required=true, type="org.jboss.forge.inputType.DROPDOWN")
    private UISelectOne<JavaResource> targetClass;
    @Inject
    @WithAttributes(label="Field Name", description="The field name to be created in this class", required=true)
    private UIInput<String> named;
    @Inject
    @WithAttributes(label="Field Type", description="The type intended to be used for this field", type="org.jboss.forge.inputType.JAVA_CLASS_PICKER", required=true, defaultValue="String")
    private UIInput<String> type;
    @Inject
    @WithAttributes(label="Access Type", description="The access type", type="org.jboss.forge.inputType.RADIO")
    private UISelectOne<Visibility> accessType;
    @Inject
    @WithAttributes(label="Generate Getter", description="Generate accessor method", defaultValue="true")
    private UIInput<Boolean> generateGetter;
    @Inject
    @WithAttributes(label="Generate Setter", description="Generate mutator method", defaultValue="true")
    private UIInput<Boolean> generateSetter;
    @Inject
    @WithAttributes(label="Update toString", description="Updates the toString method by adding the field", defaultValue="true")
    private UIInput<Boolean> updateToString;
    @Inject
    private FieldOperations fieldOperations;
    @Inject
    private ProjectOperations projectOperations;
    @Inject
    private ProjectFactory projectFactory;

    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.forCommand(((Object)((Object)this)).getClass()).name("Java: New Field").description("Creates a new field").category(Categories.create((String[])new String[]{"Java"}));
    }

    public void initializeUI(UIBuilder builder) throws Exception {
        this.setupTargetClass(builder.getUIContext());
        this.setupAccessType();
        builder.add(this.targetClass).add(this.named).add(this.type).add(this.accessType).add(this.generateGetter).add(this.generateSetter).add(this.updateToString);
    }

    public Result execute(UIExecutionContext context) throws Exception {
        String action;
        JavaResource javaResource = (JavaResource)this.targetClass.getValue();
        String fieldNameStr = (String)this.named.getValue();
        JavaClassSource targetClass = (JavaClassSource)javaResource.getJavaType();
        FieldSource field = targetClass.getField(fieldNameStr);
        String string = action = field == null ? "created" : "updated";
        if (field != null) {
            UIPrompt prompt = context.getPrompt();
            if (prompt.promptBoolean("Field '" + field.getName() + "' already exists. Do you want to overwrite it?")) {
                this.fieldOperations.removeField(targetClass, (Field)field);
            } else {
                return Results.fail((String)("Field '" + field.getName() + "' already exists."));
            }
        }
        String fieldType = (String)this.type.getValue();
        field = this.fieldOperations.addFieldTo(targetClass, fieldType, fieldNameStr, (Visibility)this.accessType.getValue(), ((Boolean)this.generateGetter.getValue()).booleanValue(), ((Boolean)this.generateSetter.getValue()).booleanValue(), ((Boolean)this.updateToString.getValue()).booleanValue(), new String[0]);
        this.setCurrentWorkingResource(context, javaResource, (Field<JavaClassSource>)field);
        return Results.success((String)("Field " + (String)this.named.getValue() + " " + action));
    }

    private void setupTargetClass(UIContext context) {
        UISelection selection = context.getInitialSelection();
        Project project = this.getSelectedProject(context);
        List entities = this.projectOperations.getProjectClasses(project);
        this.targetClass.setValueChoices((Iterable)entities);
        int idx = -1;
        if (!selection.isEmpty()) {
            idx = entities.indexOf(selection.get());
        }
        if (idx != -1) {
            this.targetClass.setDefaultValue(entities.get(idx));
        }
    }

    private void setupAccessType() {
        this.accessType.setItemLabelConverter((Converter)new Converter<Visibility, String>(){

            public String convert(Visibility source) {
                if (source == null) {
                    return null;
                }
                if (source == Visibility.PACKAGE_PRIVATE) {
                    return "default";
                }
                return source.toString();
            }
        });
        this.accessType.setDefaultValue((Object)Visibility.PRIVATE);
    }

    private void setCurrentWorkingResource(UIExecutionContext context, JavaResource javaResource, Field<JavaClassSource> field) throws FileNotFoundException {
        Project selectedProject = this.getSelectedProject((UIContextProvider)context);
        if (selectedProject != null) {
            JavaSourceFacet facet = (JavaSourceFacet)selectedProject.getFacet(JavaSourceFacet.class);
            facet.saveJavaSource((JavaSource)field.getOrigin());
        }
        context.getUIContext().setSelection((Object)javaResource);
    }

    protected boolean isProjectRequired() {
        return true;
    }

    protected ProjectFactory getProjectFactory() {
        return this.projectFactory;
    }
}

