/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.files.condition;

import com.googlecode.streamflyer.core.Modifier;
import com.googlecode.streamflyer.core.ModifyingReader;
import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.Variables;
import org.jboss.windup.config.condition.EvaluationStrategy;
import org.jboss.windup.config.condition.NoopEvaluationStrategy;
import org.jboss.windup.config.parameters.FrameContext;
import org.jboss.windup.config.parameters.FrameCreationContext;
import org.jboss.windup.config.parameters.ParameterizedGraphCondition;
import org.jboss.windup.graph.model.WindupVertexFrame;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.graph.service.FileService;
import org.jboss.windup.graph.service.GraphService;
import org.jboss.windup.rules.files.condition.FileContentMatches;
import org.jboss.windup.rules.files.condition.regex.StreamRegexMatchListener;
import org.jboss.windup.rules.files.condition.regex.StreamRegexMatchedEvent;
import org.jboss.windup.rules.files.condition.regex.StreamRegexMatcher;
import org.jboss.windup.rules.files.model.FileLocationModel;
import org.jboss.windup.util.Logging;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.event.Rewrite;
import org.ocpsoft.rewrite.param.DefaultParameterStore;
import org.ocpsoft.rewrite.param.ParameterStore;
import org.ocpsoft.rewrite.param.ParameterizedPatternResult;
import org.ocpsoft.rewrite.param.RegexParameterizedPatternParser;
import org.ocpsoft.rewrite.util.Maps;

public class FileContent
extends ParameterizedGraphCondition
implements FileContentMatches {
    private static Logger LOG = Logging.get(FileContent.class);
    private RegexParameterizedPatternParser contentPattern;
    private RegexParameterizedPatternParser filenamePattern;

    public FileContent(String contentPattern) {
        this.contentPattern = new RegexParameterizedPatternParser(contentPattern);
    }

    public static FileContentMatches matches(String contentPattern) {
        return new FileContent(contentPattern);
    }

    @Override
    public FileContent inFilesNamed(String filenamePattern) {
        this.filenamePattern = new RegexParameterizedPatternParser(filenamePattern);
        return this;
    }

    public Set<String> getRequiredParameterNames() {
        HashSet<String> result = new HashSet<String>(this.contentPattern.getRequiredParameterNames());
        if (this.filenamePattern != null) {
            result.addAll(this.filenamePattern.getRequiredParameterNames());
        }
        return result;
    }

    public void setParameterStore(ParameterStore store) {
        this.contentPattern.setParameterStore(store);
        if (this.filenamePattern != null) {
            this.filenamePattern.setParameterStore(store);
        }
    }

    protected String getVarname() {
        return this.getOutputVariablesName();
    }

    protected boolean evaluateAndPopulateValueStores(GraphRewrite event, EvaluationContext context, final FrameCreationContext frameCreationContext) {
        return this.evaluate(event, context, new EvaluationStrategy(){
            private LinkedHashMap<String, List<WindupVertexFrame>> variables;

            public void modelMatched() {
                this.variables = new LinkedHashMap();
                frameCreationContext.beginNew(this.variables);
            }

            public void modelSubmitted(WindupVertexFrame model) {
                Maps.addListValue(this.variables, (Object)FileContent.this.getVarname(), (Object)model);
            }

            public void modelSubmissionRejected() {
                frameCreationContext.rollback();
            }
        });
    }

    protected boolean evaluateWithValueStore(GraphRewrite event, EvaluationContext context, FrameContext frameContext) {
        boolean result = this.evaluate(event, context, (EvaluationStrategy)new NoopEvaluationStrategy());
        if (!result) {
            frameContext.reject();
        }
        return result;
    }

    private boolean evaluate(final GraphRewrite event, final EvaluationContext context, final EvaluationStrategy evaluationStrategy) {
        Iterable fileModels;
        ParameterStore store = DefaultParameterStore.getInstance((EvaluationContext)context);
        final GraphService fileLocationService = new GraphService(event.getGraphContext(), FileLocationModel.class);
        FileService fileModelService = new FileService(event.getGraphContext());
        if (this.filenamePattern != null) {
            Pattern filenameRegex = this.filenamePattern.getCompiledPattern(store);
            fileModels = fileModelService.findAllByPropertyMatchingRegex("fileName", new String[]{filenameRegex.pattern()});
        } else {
            fileModels = fileModelService.findAll();
        }
        final ArrayList results = new ArrayList();
        for (final FileModel fileModel : fileModels) {
            ParameterizedPatternResult filenamePatternResult;
            if (fileModel.isDirectory() || !(filenamePatternResult = this.filenamePattern.parse(fileModel.getFileName())).matches()) continue;
            try {
                FileReader reader = new FileReader(fileModel.asFile());
                Pattern fileContentsRegex = this.contentPattern.getCompiledPattern(store);
                StreamRegexMatchListener matchListener = new StreamRegexMatchListener(){

                    @Override
                    public void regexMatched(StreamRegexMatchedEvent matchEvent) {
                        String matchedStr = matchEvent.getMatch();
                        ParameterizedPatternResult contentPatternResult = FileContent.this.contentPattern.parse(matchedStr);
                        if (contentPatternResult.matches()) {
                            evaluationStrategy.modelMatched();
                            if (filenamePatternResult.submit((Rewrite)event, context) && contentPatternResult.submit((Rewrite)event, context)) {
                                FileLocationModel fileLocationModel = (FileLocationModel)fileLocationService.create();
                                fileLocationModel.setFile(fileModel);
                                fileLocationModel.setColumnNumber((int)matchEvent.getColumnNumber());
                                fileLocationModel.setLineNumber((int)matchEvent.getLineNumber());
                                fileLocationModel.setLength(matchedStr.length());
                                fileLocationModel.setSourceSnippit(matchedStr);
                                results.add(fileLocationModel);
                                evaluationStrategy.modelSubmitted((WindupVertexFrame)fileLocationModel);
                            } else {
                                evaluationStrategy.modelSubmissionRejected();
                            }
                        }
                    }
                };
                StreamRegexMatcher regexModifier = new StreamRegexMatcher(fileContentsRegex.pattern(), matchListener);
                ModifyingReader modifyingReader = new ModifyingReader((Reader)reader, (Modifier)regexModifier);
                Throwable throwable = null;
                try {
                    char[] buffer = new char[32768];
                    while (modifyingReader.read(buffer) != -1) {
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (modifyingReader == null) continue;
                    if (throwable != null) {
                        try {
                            modifyingReader.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                        continue;
                    }
                    modifyingReader.close();
                }
            }
            catch (Exception e) {
                LOG.log(Level.WARNING, "Error loading and matching contents for file: " + fileModel.getFilePath() + " due to: " + e.getMessage(), e);
            }
        }
        Variables.instance((GraphRewrite)event).setVariable(this.getVarname(), results);
        return !results.isEmpty();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName());
        builder.append(".matches(" + this.contentPattern + ")");
        builder.append(".inFilesNamed(" + this.filenamePattern + ")");
        builder.append(".as(" + this.getVarname() + ")");
        return builder.toString();
    }
}

