/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.files.condition.regex;

import com.googlecode.streamflyer.regex.MatchProcessor;
import com.googlecode.streamflyer.regex.MatchProcessorResult;
import com.googlecode.streamflyer.regex.OnStreamMatcher;
import com.googlecode.streamflyer.regex.OnStreamStandardMatcher;
import com.googlecode.streamflyer.regex.RegexModifier;
import com.googlecode.streamflyer.regex.addons.util.DoNothingProcessor;
import com.googlecode.streamflyer.util.ModificationFactory;
import com.googlecode.streamflyer.util.statistics.LineColumnAwareModificationFactory;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jboss.windup.rules.files.condition.regex.StreamRegexMatchListener;
import org.jboss.windup.rules.files.condition.regex.StreamRegexMatchedEvent;

public class StreamRegexMatcher
extends RegexModifier {
    private final StreamRegexMatchListener listener;

    public StreamRegexMatcher(String regex, StreamRegexMatchListener listener) {
        this.listener = listener;
        Matcher jdkMatcher = Pattern.compile(regex, 0).matcher("");
        jdkMatcher.useTransparentBounds(true);
        jdkMatcher.useAnchoringBounds(false);
        this.init((OnStreamMatcher)new OnStreamStandardMatcher(jdkMatcher), new StreamRegexMatcherProcessor(), 2048, 2048);
    }

    protected void init(OnStreamMatcher matcher, MatchProcessor matchProcessor, int minimumLengthOfLookBehind, int newNumberOfChars) {
        ModificationFactory modFactory = new ModificationFactory(minimumLengthOfLookBehind, newNumberOfChars);
        this.factory = new LineColumnAwareModificationFactory(modFactory);
        this.matchProcessor = matchProcessor;
        this.matcher = matcher;
        this.newNumberOfChars = newNumberOfChars;
    }

    private LineColumnAwareModificationFactory getMatchFactory() {
        return (LineColumnAwareModificationFactory)this.factory;
    }

    private class StreamRegexMatcherProcessor
    extends DoNothingProcessor
    implements MatchProcessor {
        private StreamRegexMatcherProcessor() {
        }

        public MatchProcessorResult process(StringBuilder characterBuffer, int firstModifiableCharacterInBuffer, MatchResult matchResult) {
            LineColumnAwareModificationFactory matchFactory = StreamRegexMatcher.this.getMatchFactory();
            long lineNumber = matchFactory.getCurrentLine();
            int startColumn = (int)matchFactory.getCurrentColumn() + matchResult.start() - firstModifiableCharacterInBuffer;
            boolean calculateStartColumn = false;
            int lastChar = 0;
            for (int i = 0; i < StreamRegexMatcher.this.matcher.start(); ++i) {
                char ch = characterBuffer.charAt(i);
                if (ch == '\r') {
                    startColumn = 0;
                    calculateStartColumn = true;
                    ++lineNumber;
                } else if (ch == '\n') {
                    if (lastChar != 13) {
                        startColumn = 0;
                        calculateStartColumn = true;
                        ++lineNumber;
                    }
                } else if (calculateStartColumn) {
                    ++startColumn;
                }
                lastChar = ch;
            }
            StreamRegexMatchedEvent event = new StreamRegexMatchedEvent(matchResult.group(), lineNumber, startColumn);
            StreamRegexMatcher.this.listener.regexMatched(event);
            MatchProcessorResult result = super.process(characterBuffer, firstModifiableCharacterInBuffer, matchResult);
            return result;
        }
    }
}

