/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.javaee.rules;

import java.util.HashMap;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.WindupRuleProvider;
import org.jboss.windup.config.operation.ruleelement.AbstractIterationOperation;
import org.jboss.windup.config.phase.ReportGeneration;
import org.jboss.windup.config.phase.RulePhase;
import org.jboss.windup.config.query.Query;
import org.jboss.windup.config.query.QueryBuilderFind;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.ProjectModel;
import org.jboss.windup.graph.model.WindupConfigurationModel;
import org.jboss.windup.graph.model.WindupVertexFrame;
import org.jboss.windup.graph.service.GraphService;
import org.jboss.windup.reporting.model.ApplicationReportModel;
import org.jboss.windup.reporting.model.ReportModel;
import org.jboss.windup.reporting.model.TemplateType;
import org.jboss.windup.reporting.model.WindupVertexListModel;
import org.jboss.windup.reporting.service.ApplicationReportService;
import org.jboss.windup.reporting.service.ReportService;
import org.jboss.windup.rules.apps.javaee.model.EjbBeanBaseModel;
import org.jboss.windup.rules.apps.javaee.model.EjbEntityBeanModel;
import org.jboss.windup.rules.apps.javaee.model.EjbMessageDrivenModel;
import org.jboss.windup.util.exception.WindupException;
import org.ocpsoft.rewrite.config.Condition;
import org.ocpsoft.rewrite.config.Configuration;
import org.ocpsoft.rewrite.config.ConfigurationBuilder;
import org.ocpsoft.rewrite.config.Operation;
import org.ocpsoft.rewrite.context.EvaluationContext;

public class CreateEJBReportRuleProvider
extends WindupRuleProvider {
    public static final String TEMPLATE_EJB_REPORT = "/reports/templates/ejb.ftl";

    public Class<? extends RulePhase> getPhase() {
        return ReportGeneration.class;
    }

    public Configuration getConfiguration(GraphContext context) {
        QueryBuilderFind applicationProjectModelsFound = Query.fromType(WindupConfigurationModel.class);
        AbstractIterationOperation<WindupConfigurationModel> addEJBReport = new AbstractIterationOperation<WindupConfigurationModel>(){

            public void perform(GraphRewrite event, EvaluationContext context, WindupConfigurationModel payload) {
                ProjectModel projectModel = payload.getInputPath().getProjectModel();
                if (projectModel == null) {
                    throw new WindupException("Error, no project found in: " + payload.getInputPath().getFilePath());
                }
                CreateEJBReportRuleProvider.this.createEJBReport(event.getGraphContext(), projectModel);
            }

            public String toString() {
                return "CreateEJBReport";
            }
        };
        return ConfigurationBuilder.begin().addRule().when((Condition)applicationProjectModelsFound).perform((Operation)addEJBReport);
    }

    private void createEJBReport(GraphContext context, ProjectModel projectModel) {
        ApplicationReportService applicationReportService = new ApplicationReportService(context);
        ApplicationReportModel applicationReportModel = applicationReportService.create();
        applicationReportModel.setReportPriority(300);
        applicationReportModel.setDisplayInApplicationReportIndex(Boolean.valueOf(true));
        applicationReportModel.setReportName("EJB Report");
        applicationReportModel.setProjectModel(projectModel);
        applicationReportModel.setTemplatePath(TEMPLATE_EJB_REPORT);
        applicationReportModel.setTemplateType(TemplateType.FREEMARKER);
        GraphService ejbService = new GraphService(context, EjbBeanBaseModel.class);
        GraphService listService = new GraphService(context, WindupVertexListModel.class);
        WindupVertexListModel entityList = (WindupVertexListModel)listService.create();
        WindupVertexListModel mdbList = (WindupVertexListModel)listService.create();
        WindupVertexListModel statelessList = (WindupVertexListModel)listService.create();
        WindupVertexListModel statefulList = (WindupVertexListModel)listService.create();
        for (EjbBeanBaseModel ejbModel : ejbService.findAll()) {
            if (ejbModel instanceof EjbMessageDrivenModel) {
                mdbList.addItem((WindupVertexFrame)ejbModel);
                continue;
            }
            if (ejbModel instanceof EjbEntityBeanModel) {
                entityList.addItem((WindupVertexFrame)ejbModel);
                continue;
            }
            if ("stateful".equalsIgnoreCase(ejbModel.getSessionType())) {
                statefulList.addItem((WindupVertexFrame)ejbModel);
                continue;
            }
            statelessList.addItem((WindupVertexFrame)ejbModel);
        }
        HashMap<String, WindupVertexListModel> additionalData = new HashMap<String, WindupVertexListModel>(4);
        additionalData.put("entity", entityList);
        additionalData.put("mdb", mdbList);
        additionalData.put("stateless", statelessList);
        additionalData.put("stateful", statefulList);
        applicationReportModel.setRelatedResource(additionalData);
        ReportService reportService = new ReportService(context);
        reportService.setUniqueFilename((ReportModel)applicationReportModel, "ejbreport_" + projectModel.getName(), "html");
    }
}

