/*
 * Decompiled with CFR 0.152.
 */
package net.fortytwo.sesametools;

import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFHandlerException;

public class SingleContextHandler
implements RDFHandler {
    private RDFHandler baseHandler;
    private ValueFactory valueFactory;
    private Resource context;

    public SingleContextHandler(RDFHandler base, ValueFactory vf, Resource singleContext) {
        this.baseHandler = base;
        this.valueFactory = vf;
        this.context = singleContext;
    }

    public void startRDF() throws RDFHandlerException {
        this.baseHandler.startRDF();
    }

    public void endRDF() throws RDFHandlerException {
        this.baseHandler.endRDF();
    }

    public void handleNamespace(String prefix, String uri) throws RDFHandlerException {
        this.baseHandler.handleNamespace(prefix, uri);
    }

    public void handleStatement(Statement st) throws RDFHandlerException {
        Resource subj = st.getSubject();
        URI pred = st.getPredicate();
        Value obj = st.getObject();
        Statement newSt = this.valueFactory.createStatement(subj, pred, obj, this.context);
        this.baseHandler.handleStatement(newSt);
    }

    public void handleComment(String comment) throws RDFHandlerException {
        this.baseHandler.handleComment(comment);
    }
}

