/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.decompiler.languages.java.ast.transforms;

import com.strobel.assembler.metadata.FieldDefinition;
import com.strobel.assembler.metadata.MethodDefinition;
import com.strobel.assembler.metadata.TypeDefinition;
import com.strobel.core.CollectionUtilities;
import com.strobel.core.Predicate;
import com.strobel.core.StringUtilities;
import com.strobel.decompiler.DecompilerContext;
import com.strobel.decompiler.languages.java.ast.AstBuilder;
import com.strobel.decompiler.languages.java.ast.BlockStatement;
import com.strobel.decompiler.languages.java.ast.CompilationUnit;
import com.strobel.decompiler.languages.java.ast.ConstructorDeclaration;
import com.strobel.decompiler.languages.java.ast.ContextTrackingVisitor;
import com.strobel.decompiler.languages.java.ast.Expression;
import com.strobel.decompiler.languages.java.ast.ExpressionStatement;
import com.strobel.decompiler.languages.java.ast.FieldDeclaration;
import com.strobel.decompiler.languages.java.ast.InvocationExpression;
import com.strobel.decompiler.languages.java.ast.Keys;
import com.strobel.decompiler.languages.java.ast.MethodDeclaration;
import com.strobel.decompiler.languages.java.ast.SuperReferenceExpression;
import com.strobel.decompiler.languages.java.ast.TypeDeclaration;
import com.strobel.decompiler.patterns.INode;

public class RemoveHiddenMembersTransform
extends ContextTrackingVisitor<Void> {
    private static final INode DEFAULT_CONSTRUCTOR_BODY = new BlockStatement(new ExpressionStatement(new InvocationExpression(-34, (Expression)new SuperReferenceExpression(-34), new Expression[0])));

    public RemoveHiddenMembersTransform(DecompilerContext context) {
        super(context);
    }

    @Override
    public Void visitTypeDeclaration(TypeDeclaration node, Void _) {
        TypeDefinition type;
        if (!(node.getParent() instanceof CompilationUnit) && (type = node.getUserData(Keys.TYPE_DEFINITION)) != null && AstBuilder.isMemberHidden(type, this.context)) {
            node.remove();
            return null;
        }
        return (Void)super.visitTypeDeclaration(node, _);
    }

    @Override
    public Void visitFieldDeclaration(FieldDeclaration node, Void data) {
        FieldDefinition field = node.getUserData(Keys.FIELD_DEFINITION);
        if (field != null && AstBuilder.isMemberHidden(field, this.context)) {
            node.remove();
            return null;
        }
        return (Void)super.visitFieldDeclaration(node, data);
    }

    @Override
    public Void visitMethodDeclaration(MethodDeclaration node, Void _) {
        MethodDefinition method = node.getUserData(Keys.METHOD_DEFINITION);
        if (method != null) {
            if (AstBuilder.isMemberHidden(method, this.context)) {
                node.remove();
                return null;
            }
            if (method.isTypeInitializer() && node.getBody().getStatements().isEmpty()) {
                node.remove();
                return null;
            }
        }
        return (Void)super.visitMethodDeclaration(node, _);
    }

    @Override
    public Void visitConstructorDeclaration(ConstructorDeclaration node, Void _) {
        final MethodDefinition method = node.getUserData(Keys.METHOD_DEFINITION);
        if (method != null) {
            boolean hasOtherConstructors;
            TypeDefinition declaringType;
            if (AstBuilder.isMemberHidden(method, this.context)) {
                if (method.getDeclaringType().isEnum() && method.getDeclaringType().isAnonymous() && !node.getBody().getStatements().isEmpty()) {
                    return (Void)super.visitConstructorDeclaration(node, _);
                }
                node.remove();
                return null;
            }
            if (!this.context.getSettings().getShowSyntheticMembers() && node.getParameters().isEmpty() && DEFAULT_CONSTRUCTOR_BODY.matches(node.getBody()) && (declaringType = method.getDeclaringType()) != null && !(hasOtherConstructors = CollectionUtilities.any(declaringType.getDeclaredMethods(), (Predicate)new Predicate<MethodDefinition>(){

                public boolean test(MethodDefinition m) {
                    return m.isConstructor() && !m.isSynthetic() && !StringUtilities.equals((String)m.getErasedSignature(), (String)method.getErasedSignature());
                }
            }))) {
                node.remove();
                return null;
            }
        }
        return (Void)super.visitConstructorDeclaration(node, _);
    }
}

