/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.bootstrap;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.jboss.forge.furnace.Furnace;
import org.jboss.forge.furnace.addons.AddonId;
import org.jboss.forge.furnace.impl.addons.AddonRepositoryImpl;
import org.jboss.forge.furnace.manager.impl.AddonManagerImpl;
import org.jboss.forge.furnace.manager.maven.addon.MavenAddonDependencyResolver;
import org.jboss.forge.furnace.manager.request.InstallRequest;
import org.jboss.forge.furnace.manager.request.RemoveRequest;
import org.jboss.forge.furnace.manager.spi.AddonDependencyResolver;
import org.jboss.forge.furnace.repositories.AddonRepository;
import org.jboss.forge.furnace.repositories.MutableAddonRepository;
import org.jboss.forge.furnace.versions.SingleVersion;
import org.jboss.forge.furnace.versions.Version;
import org.jboss.forge.furnace.versions.Versions;
import org.jboss.windup.bootstrap.Bootstrap;

public class BootstrapFurnaceService {
    private static final String FORGE_ADDON_GROUP_ID = "org.jboss.forge.addon:";
    private final Furnace furnace;

    public BootstrapFurnaceService(Furnace furnace) {
        this.furnace = furnace;
    }

    boolean list() {
        boolean exitAfter = true;
        try {
            for (AddonRepository repository : this.furnace.getRepositories()) {
                System.out.println(repository.getRootDirectory().getCanonicalPath() + ":");
                List addons = repository.listEnabled();
                for (AddonId addon : addons) {
                    System.out.println(addon.toCoordinates());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("> Forge version [" + AddonRepositoryImpl.getRuntimeAPIVersion() + "]");
            exitAfter = false;
        }
        return exitAfter;
    }

    private List<AddonId> getEnabledAddonIds() {
        ArrayList<AddonId> result = new ArrayList<AddonId>();
        for (AddonRepository repository : this.furnace.getRepositories()) {
            List addons = repository.listEnabled();
            result.addAll(addons);
        }
        return result;
    }

    void start(boolean exitAfter, boolean batchMode) throws InterruptedException, ExecutionException {
        String result;
        List<AddonId> addonIds;
        if (exitAfter) {
            return;
        }
        if (!batchMode && (addonIds = this.getEnabledAddonIds()).isEmpty() && !"n".equalsIgnoreCase((result = System.console().readLine("There are no addons installed; install core addons now? [Y,n] ", new Object[0])).trim())) {
            this.install("core", batchMode);
        }
        this.furnace.start();
    }

    boolean install(String addonCoordinates, boolean batchMode) {
        Version runtimeAPIVersion = AddonRepositoryImpl.getRuntimeAPIVersion();
        try {
            String result;
            AddonId addon;
            MavenAddonDependencyResolver resolver = new MavenAddonDependencyResolver();
            AddonManagerImpl addonManager = new AddonManagerImpl(this.furnace, (AddonDependencyResolver)resolver);
            if (addonCoordinates.contains(",")) {
                addon = addonCoordinates.contains(":") ? AddonId.fromCoordinates((String)addonCoordinates) : AddonId.fromCoordinates((String)(FORGE_ADDON_GROUP_ID + addonCoordinates));
            } else {
                AddonId[] versions;
                String coordinate;
                if (addonCoordinates.contains(":")) {
                    coordinate = addonCoordinates;
                    versions = (AddonId[])resolver.resolveVersions(addonCoordinates).get();
                } else {
                    coordinate = FORGE_ADDON_GROUP_ID + addonCoordinates;
                    versions = (AddonId[])resolver.resolveVersions(coordinate).get();
                }
                if (versions.length == 0) {
                    throw new IllegalArgumentException("No Artifact version found for " + coordinate);
                }
                AddonId selected = null;
                for (int i = versions.length - 1; selected == null && i >= 0; --i) {
                    String apiVersion = (String)resolver.resolveAPIVersion(versions[i]).get();
                    if (apiVersion == null || !Versions.isApiCompatible((Version)runtimeAPIVersion, (Version)new SingleVersion(apiVersion))) continue;
                    selected = versions[i];
                }
                if (selected == null) {
                    throw new IllegalArgumentException("No compatible addon API version found for " + coordinate + " for API " + runtimeAPIVersion);
                }
                addon = selected;
            }
            InstallRequest request = addonManager.install(addon);
            System.out.println(request);
            if (!batchMode && "n".equalsIgnoreCase((result = System.console().readLine("Confirm installation [Y/n]? ", new Object[0])).trim())) {
                System.out.println("Installation aborted.");
                return false;
            }
            request.perform();
            System.out.println("Installation completed successfully.");
            System.out.println();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("> Forge version [" + runtimeAPIVersion + "]");
        }
        return true;
    }

    boolean remove(String addonCoordinates, boolean batchMode) {
        try {
            String coordinates;
            MavenAddonDependencyResolver resolver = new MavenAddonDependencyResolver();
            AddonManagerImpl addonManager = new AddonManagerImpl(this.furnace, (AddonDependencyResolver)resolver);
            AddonId addon = null;
            if (addonCoordinates.contains(":")) {
                addonCoordinates = FORGE_ADDON_GROUP_ID + addonCoordinates;
            }
            if (addonCoordinates.contains(",")) {
                addon = AddonId.fromCoordinates((String)addonCoordinates);
                coordinates = addon.getName();
            } else {
                coordinates = addonCoordinates;
            }
            block2: for (AddonRepository repository : this.furnace.getRepositories()) {
                for (AddonId id : repository.listEnabled()) {
                    String result;
                    if (!coordinates.equals(id.getName())) continue;
                    addon = id;
                    if (!(repository instanceof MutableAddonRepository)) break block2;
                    RemoveRequest request = addonManager.remove(id, repository);
                    System.out.println(request);
                    if (!batchMode && "n".equalsIgnoreCase((result = System.console().readLine("Confirm uninstallation [Y/n]? ", new Object[0])).trim())) {
                        System.out.println("Uninstallation aborted.");
                        return false;
                    }
                    request.perform();
                    System.out.println("Uninstallation completed successfully.");
                    System.out.println();
                    break block2;
                }
            }
            if (addon == null) {
                throw new IllegalArgumentException("No addon exists with id " + coordinates);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println(Bootstrap.getVersionString());
        }
        return true;
    }

    Furnace getFurnace() {
        return this.furnace;
    }
}

