/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.core.util;

import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.diskstorage.configuration.ConfigOption;
import com.thinkaurelius.titan.graphdb.configuration.PreInitializeConfigOptions;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.TypeAnnotationsScanner;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReflectiveConfigOptionLoader {
    private static final Logger log = LoggerFactory.getLogger(ReflectiveConfigOptionLoader.class);
    private static boolean loaded = false;

    public static void load() {
        try {
            ReflectiveConfigOptionLoader.loadAllClassesUnsafe();
        }
        catch (Throwable t) {
            log.error("Failed to iterate over classpath using Reflections; this usually indicates a broken classpath/classloader", PreInitializeConfigOptions.class, (Object)t);
        }
    }

    private static void loadAllClassesUnsafe() {
        int loadCount = 0;
        int errorCount = 0;
        Set scanUrls = ClasspathHelper.forJavaClassPath();
        Iterator i = scanUrls.iterator();
        while (i.hasNext()) {
            File f = new File(((URL)i.next()).getPath());
            if (!f.exists() || !f.canRead()) {
                log.trace("Skipping nonexistent or unreadable classpath element {}", (Object)f);
                i.remove();
            }
            log.trace("Retaining classpath element {}", (Object)f);
        }
        ConfigurationBuilder rc = new ConfigurationBuilder().setUrls((Collection)scanUrls).setScanners(new Scanner[]{new TypeAnnotationsScanner()});
        Reflections reflections = new Reflections((Configuration)rc);
        for (Class c : reflections.getTypesAnnotatedWith(PreInitializeConfigOptions.class)) {
            try {
                loadCount += ReflectiveConfigOptionLoader.loadSingleClassUnsafe(c);
            }
            catch (Throwable t) {
                log.warn("Failed to load class {} or its referenced types; this usually indicates a broken classpath/classloader", (Object)c, (Object)t);
                ++errorCount;
            }
        }
        log.debug("Preloaded {} config option(s) via Reflections ({} class(es) with errors)", (Object)loadCount, (Object)errorCount);
    }

    private static int loadSingleClassUnsafe(Class<?> c) {
        int loadCount = 0;
        log.trace("Looking for ConfigOption public static fields on class {}", c);
        for (Field f : c.getDeclaredFields()) {
            boolean pub = Modifier.isPublic(f.getModifiers());
            boolean stat = Modifier.isStatic(f.getModifiers());
            boolean typeMatch = ConfigOption.class.isAssignableFrom(f.getType());
            log.trace("Properties for field \"{}\": public={} static={} assignable={}", new Object[]{f, pub, stat, typeMatch});
            if (!pub || !stat || !typeMatch) continue;
            try {
                Object o = f.get(null);
                Preconditions.checkNotNull((Object)o);
                log.debug("Initialized {}={}", (Object)f, o);
                ++loadCount;
            }
            catch (IllegalArgumentException e) {
                log.warn("ConfigOption initialization error", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                log.warn("ConfigOption initialization error", (Throwable)e);
            }
        }
        return loadCount;
    }

    public static synchronized void loadOnce() {
        if (loaded) {
            return;
        }
        ReflectiveConfigOptionLoader.load();
        loaded = true;
    }
}

