/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.database.serialize;

import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.core.TitanException;
import com.thinkaurelius.titan.core.attribute.AttributeSerializer;
import com.thinkaurelius.titan.diskstorage.ReadBuffer;
import com.thinkaurelius.titan.diskstorage.StaticBuffer;
import com.thinkaurelius.titan.diskstorage.WriteBuffer;
import com.thinkaurelius.titan.diskstorage.util.WriteByteBuffer;
import com.thinkaurelius.titan.graphdb.database.serialize.DataOutput;
import com.thinkaurelius.titan.graphdb.database.serialize.OrderPreservingSerializer;
import com.thinkaurelius.titan.graphdb.database.serialize.Serializer;
import com.thinkaurelius.titan.graphdb.database.serialize.StandardAttributeHandling;
import com.thinkaurelius.titan.graphdb.database.serialize.SupportsNullSerializer;
import com.thinkaurelius.titan.graphdb.database.serialize.kryo.KryoSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardSerializer
extends StandardAttributeHandling
implements Serializer {
    private static final Logger log = LoggerFactory.getLogger(StandardSerializer.class);
    private final KryoSerializer backupSerializer;

    public StandardSerializer(boolean allowCustomSerialization) {
        this.backupSerializer = new KryoSerializer(this.getDefaultRegistrations(), !allowCustomSerialization);
    }

    public StandardSerializer() {
        this(true);
    }

    private KryoSerializer getBackupSerializer() {
        assert (this.backupSerializer != null);
        return this.backupSerializer;
    }

    private boolean supportsNullSerialization(Class type) {
        return this.getSerializer(type) instanceof SupportsNullSerializer;
    }

    @Override
    public <T> T readObjectByteOrder(ReadBuffer buffer, Class<T> type) {
        return this.readObjectInternal(buffer, type, true);
    }

    @Override
    public <T> T readObject(ReadBuffer buffer, Class<T> type) {
        return this.readObjectInternal(buffer, type, false);
    }

    @Override
    public <T> T readObjectNotNull(ReadBuffer buffer, Class<T> type) {
        return this.readObjectNotNullInternal(buffer, type, false);
    }

    private <T> T readObjectInternal(ReadBuffer buffer, Class<T> type, boolean byteOrder) {
        if (this.supportsNullSerialization(type)) {
            AttributeSerializer<T> s = this.getSerializer(type);
            if (byteOrder) {
                return (T)((OrderPreservingSerializer)s).readByteOrder(buffer);
            }
            return s.read(buffer);
        }
        byte flag = buffer.getByte();
        if (flag == -1) {
            return null;
        }
        Preconditions.checkArgument((flag == 0 ? 1 : 0) != 0, (String)"Invalid flag encountered in serialization: %s. Corrupted data.", (Object[])new Object[]{flag});
        return this.readObjectNotNullInternal(buffer, type, byteOrder);
    }

    private <T> T readObjectNotNullInternal(ReadBuffer buffer, Class<T> type, boolean byteOrder) {
        AttributeSerializer<T> s = this.getSerializer(type);
        if (byteOrder) {
            Preconditions.checkArgument((s != null && s instanceof OrderPreservingSerializer ? 1 : 0) != 0, (String)"Invalid serializer for class: %s", (Object[])new Object[]{type});
            return (T)((OrderPreservingSerializer)s).readByteOrder(buffer);
        }
        if (s != null) {
            return s.read(buffer);
        }
        return this.getBackupSerializer().readObjectNotNull(buffer, type);
    }

    @Override
    public Object readClassAndObject(ReadBuffer buffer) {
        return this.getBackupSerializer().readClassAndObject(buffer);
    }

    @Override
    public DataOutput getDataOutput(int initialCapacity) {
        return new StandardDataOutput(initialCapacity);
    }

    private class StandardDataOutput
    extends WriteByteBuffer
    implements DataOutput {
        private StandardDataOutput(int initialCapacity) {
            super(initialCapacity);
        }

        public DataOutput writeObjectByteOrder(Object object, Class type) {
            Preconditions.checkArgument((boolean)StandardSerializer.this.isOrderPreservingDatatype(type), (String)"Invalid serializer for class: %s", (Object[])new Object[]{type});
            return this.writeObjectInternal(object, type, true);
        }

        public DataOutput writeObject(Object object, Class type) {
            return this.writeObjectInternal(object, type, false);
        }

        @Override
        public DataOutput writeObjectNotNull(Object object) {
            return this.writeObjectNotNullInternal(object, false);
        }

        private DataOutput writeObjectInternal(Object object, Class type, boolean byteOrder) {
            if (StandardSerializer.this.supportsNullSerialization(type)) {
                AttributeSerializer<Object> s = StandardSerializer.this.getSerializer(type);
                if (byteOrder) {
                    ((OrderPreservingSerializer)s).writeByteOrder(this, object);
                } else {
                    s.write(this, object);
                }
            } else if (object == null) {
                this.putByte((byte)-1);
            } else {
                this.putByte((byte)0);
                this.writeObjectNotNullInternal(object, byteOrder);
            }
            return this;
        }

        private DataOutput writeObjectNotNullInternal(Object object, boolean byteOrder) {
            Preconditions.checkNotNull((Object)object);
            AttributeSerializer<?> s = StandardSerializer.this.getSerializer(object.getClass());
            if (byteOrder) {
                Preconditions.checkArgument((s != null && s instanceof OrderPreservingSerializer ? 1 : 0) != 0, (String)"Invalid serializer for class: %s", (Object[])new Object[]{object.getClass()});
                ((OrderPreservingSerializer)s).writeByteOrder(this, object);
            } else if (s != null) {
                s.write(this, object);
            } else {
                try {
                    StandardSerializer.this.getBackupSerializer().writeObjectNotNull(this, object);
                }
                catch (Exception e) {
                    throw new TitanException("Serializer Restriction: Cannot serialize object of type: " + object.getClass(), e);
                }
            }
            return this;
        }

        @Override
        public DataOutput writeClassAndObject(Object object) {
            try {
                StandardSerializer.this.getBackupSerializer().writeClassAndObject(this, object);
            }
            catch (Exception e) {
                throw new TitanException("Serializer Restriction: Cannot serialize object of type: " + (object == null ? "null" : object.getClass()), e);
            }
            return this;
        }

        @Override
        public DataOutput putLong(long val) {
            super.putLong(val);
            return this;
        }

        @Override
        public DataOutput putInt(int val) {
            super.putInt(val);
            return this;
        }

        @Override
        public DataOutput putShort(short val) {
            super.putShort(val);
            return this;
        }

        @Override
        public WriteBuffer putBoolean(boolean val) {
            super.putBoolean(val);
            return this;
        }

        @Override
        public DataOutput putByte(byte val) {
            super.putByte(val);
            return this;
        }

        @Override
        public DataOutput putBytes(byte[] val) {
            super.putBytes(val);
            return this;
        }

        @Override
        public DataOutput putBytes(StaticBuffer val) {
            super.putBytes(val);
            return this;
        }

        @Override
        public DataOutput putChar(char val) {
            super.putChar(val);
            return this;
        }

        @Override
        public DataOutput putFloat(float val) {
            super.putFloat(val);
            return this;
        }

        @Override
        public DataOutput putDouble(double val) {
            super.putDouble(val);
            return this;
        }
    }
}

