/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.transaction;

import com.carrotsearch.hppc.LongArrayList;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.Weigher;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Sets;
import com.thinkaurelius.titan.core.Cardinality;
import com.thinkaurelius.titan.core.EdgeLabel;
import com.thinkaurelius.titan.core.Multiplicity;
import com.thinkaurelius.titan.core.PropertyKey;
import com.thinkaurelius.titan.core.RelationType;
import com.thinkaurelius.titan.core.TitanEdge;
import com.thinkaurelius.titan.core.TitanElement;
import com.thinkaurelius.titan.core.TitanException;
import com.thinkaurelius.titan.core.TitanIndexQuery;
import com.thinkaurelius.titan.core.TitanMultiVertexQuery;
import com.thinkaurelius.titan.core.TitanProperty;
import com.thinkaurelius.titan.core.TitanRelation;
import com.thinkaurelius.titan.core.TitanVertex;
import com.thinkaurelius.titan.core.VertexLabel;
import com.thinkaurelius.titan.core.attribute.Cmp;
import com.thinkaurelius.titan.core.attribute.Duration;
import com.thinkaurelius.titan.core.schema.EdgeLabelMaker;
import com.thinkaurelius.titan.core.schema.PropertyKeyMaker;
import com.thinkaurelius.titan.core.schema.TitanSchemaElement;
import com.thinkaurelius.titan.core.schema.VertexLabelMaker;
import com.thinkaurelius.titan.diskstorage.BackendException;
import com.thinkaurelius.titan.diskstorage.BackendTransaction;
import com.thinkaurelius.titan.diskstorage.EntryList;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.SliceQuery;
import com.thinkaurelius.titan.diskstorage.util.time.StandardDuration;
import com.thinkaurelius.titan.diskstorage.util.time.TimestampProvider;
import com.thinkaurelius.titan.graphdb.blueprints.TitanBlueprintsTransaction;
import com.thinkaurelius.titan.graphdb.database.EdgeSerializer;
import com.thinkaurelius.titan.graphdb.database.IndexSerializer;
import com.thinkaurelius.titan.graphdb.database.StandardTitanGraph;
import com.thinkaurelius.titan.graphdb.database.idassigner.IDPool;
import com.thinkaurelius.titan.graphdb.database.serialize.AttributeHandling;
import com.thinkaurelius.titan.graphdb.idmanagement.IDInspector;
import com.thinkaurelius.titan.graphdb.idmanagement.IDManager;
import com.thinkaurelius.titan.graphdb.internal.ElementCategory;
import com.thinkaurelius.titan.graphdb.internal.InternalRelation;
import com.thinkaurelius.titan.graphdb.internal.InternalRelationType;
import com.thinkaurelius.titan.graphdb.internal.InternalVertex;
import com.thinkaurelius.titan.graphdb.internal.InternalVertexLabel;
import com.thinkaurelius.titan.graphdb.internal.RelationCategory;
import com.thinkaurelius.titan.graphdb.internal.TitanSchemaCategory;
import com.thinkaurelius.titan.graphdb.query.MetricsQueryExecutor;
import com.thinkaurelius.titan.graphdb.query.QueryExecutor;
import com.thinkaurelius.titan.graphdb.query.QueryUtil;
import com.thinkaurelius.titan.graphdb.query.TitanPredicate;
import com.thinkaurelius.titan.graphdb.query.condition.And;
import com.thinkaurelius.titan.graphdb.query.condition.Condition;
import com.thinkaurelius.titan.graphdb.query.condition.ConditionUtil;
import com.thinkaurelius.titan.graphdb.query.condition.PredicateCondition;
import com.thinkaurelius.titan.graphdb.query.graph.GraphCentricQuery;
import com.thinkaurelius.titan.graphdb.query.graph.GraphCentricQueryBuilder;
import com.thinkaurelius.titan.graphdb.query.graph.IndexQueryBuilder;
import com.thinkaurelius.titan.graphdb.query.graph.JointIndexQuery;
import com.thinkaurelius.titan.graphdb.query.vertex.MultiVertexCentricQueryBuilder;
import com.thinkaurelius.titan.graphdb.query.vertex.VertexCentricQuery;
import com.thinkaurelius.titan.graphdb.query.vertex.VertexCentricQueryBuilder;
import com.thinkaurelius.titan.graphdb.relations.RelationIdentifier;
import com.thinkaurelius.titan.graphdb.relations.StandardEdge;
import com.thinkaurelius.titan.graphdb.relations.StandardProperty;
import com.thinkaurelius.titan.graphdb.transaction.RelationConstructor;
import com.thinkaurelius.titan.graphdb.transaction.TransactionConfiguration;
import com.thinkaurelius.titan.graphdb.transaction.VertexFactory;
import com.thinkaurelius.titan.graphdb.transaction.VertexIterable;
import com.thinkaurelius.titan.graphdb.transaction.addedrelations.AddedRelationsContainer;
import com.thinkaurelius.titan.graphdb.transaction.addedrelations.ConcurrentBufferAddedRelations;
import com.thinkaurelius.titan.graphdb.transaction.addedrelations.SimpleBufferAddedRelations;
import com.thinkaurelius.titan.graphdb.transaction.indexcache.ConcurrentIndexCache;
import com.thinkaurelius.titan.graphdb.transaction.indexcache.IndexCache;
import com.thinkaurelius.titan.graphdb.transaction.indexcache.SimpleIndexCache;
import com.thinkaurelius.titan.graphdb.transaction.lock.CombinerLock;
import com.thinkaurelius.titan.graphdb.transaction.lock.FakeLock;
import com.thinkaurelius.titan.graphdb.transaction.lock.IndexLockTuple;
import com.thinkaurelius.titan.graphdb.transaction.lock.LockTuple;
import com.thinkaurelius.titan.graphdb.transaction.lock.ReentrantTransactionLock;
import com.thinkaurelius.titan.graphdb.transaction.lock.TransactionLock;
import com.thinkaurelius.titan.graphdb.transaction.vertexcache.GuavaVertexCache;
import com.thinkaurelius.titan.graphdb.transaction.vertexcache.VertexCache;
import com.thinkaurelius.titan.graphdb.types.CompositeIndexType;
import com.thinkaurelius.titan.graphdb.types.StandardEdgeLabelMaker;
import com.thinkaurelius.titan.graphdb.types.StandardPropertyKeyMaker;
import com.thinkaurelius.titan.graphdb.types.StandardVertexLabelMaker;
import com.thinkaurelius.titan.graphdb.types.TypeDefinitionCategory;
import com.thinkaurelius.titan.graphdb.types.TypeDefinitionDescription;
import com.thinkaurelius.titan.graphdb.types.TypeDefinitionMap;
import com.thinkaurelius.titan.graphdb.types.TypeInspector;
import com.thinkaurelius.titan.graphdb.types.TypeSource;
import com.thinkaurelius.titan.graphdb.types.TypeUtil;
import com.thinkaurelius.titan.graphdb.types.VertexLabelVertex;
import com.thinkaurelius.titan.graphdb.types.system.BaseKey;
import com.thinkaurelius.titan.graphdb.types.system.BaseLabel;
import com.thinkaurelius.titan.graphdb.types.system.BaseVertexLabel;
import com.thinkaurelius.titan.graphdb.types.system.ImplicitKey;
import com.thinkaurelius.titan.graphdb.types.system.SystemRelationType;
import com.thinkaurelius.titan.graphdb.types.system.SystemTypeManager;
import com.thinkaurelius.titan.graphdb.types.vertices.EdgeLabelVertex;
import com.thinkaurelius.titan.graphdb.types.vertices.PropertyKeyVertex;
import com.thinkaurelius.titan.graphdb.types.vertices.TitanSchemaVertex;
import com.thinkaurelius.titan.graphdb.util.IndexHelper;
import com.thinkaurelius.titan.graphdb.util.VertexCentricEdgeIterable;
import com.thinkaurelius.titan.graphdb.vertices.CacheVertex;
import com.thinkaurelius.titan.graphdb.vertices.StandardVertex;
import com.thinkaurelius.titan.util.datastructures.Retriever;
import com.thinkaurelius.titan.util.stats.MetricManager;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Vertex;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.cliffc.high_scale_lib.NonBlockingHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardTitanTx
extends TitanBlueprintsTransaction
implements TypeInspector,
TypeSource,
VertexFactory {
    private static final Logger log = LoggerFactory.getLogger(StandardTitanTx.class);
    private static final Map<Long, InternalRelation> EMPTY_DELETED_RELATIONS = ImmutableMap.of();
    private static final ConcurrentMap<LockTuple, TransactionLock> UNINITIALIZED_LOCKS = null;
    private static final Duration LOCK_TIMEOUT = new StandardDuration(5000L, TimeUnit.MILLISECONDS);
    private final StandardTitanGraph graph;
    private final TransactionConfiguration config;
    private final IDManager idManager;
    private final IDInspector idInspector;
    private final AttributeHandling attributeHandler;
    private BackendTransaction txHandle;
    private final EdgeSerializer edgeSerializer;
    private final IndexSerializer indexSerializer;
    private final VertexCache vertexCache;
    private final AddedRelationsContainer addedRelations;
    private Map<Long, InternalRelation> deletedRelations;
    private final Cache<JointIndexQuery.Subquery, List<Object>> indexCache;
    private final IndexCache newVertexIndexEntries;
    private ConcurrentMap<LockTuple, TransactionLock> uniqueLocks;
    private final Map<String, Long> newTypeCache;
    private final IDPool temporaryIds;
    private final TimestampProvider times;
    private boolean isOpen;
    private final Retriever<Long, InternalVertex> existingVertexRetriever = new VertexConstructor(false);
    private final Retriever<Long, InternalVertex> externalVertexRetriever;
    private final Retriever<Long, InternalVertex> internalVertexRetriever;
    public final QueryExecutor<VertexCentricQuery, TitanRelation, SliceQuery> edgeProcessor;
    public final QueryExecutor<VertexCentricQuery, TitanRelation, SliceQuery> edgeProcessorImpl = new QueryExecutor<VertexCentricQuery, TitanRelation, SliceQuery>(){

        @Override
        public Iterator<TitanRelation> getNew(final VertexCentricQuery query) {
            InternalVertex vertex = query.getVertex();
            if (vertex.isNew() || vertex.hasAddedRelations()) {
                return vertex.getAddedRelations(new Predicate<InternalRelation>(){
                    private TitanRelation previous = null;

                    public boolean apply(@Nullable InternalRelation relation) {
                        if (relation instanceof TitanEdge && relation.isLoop() && query.getDirection() != Direction.BOTH) {
                            if (relation.equals(this.previous)) {
                                return false;
                            }
                            this.previous = relation;
                        }
                        return query.matches(relation);
                    }
                }).iterator();
            }
            return Iterators.emptyIterator();
        }

        @Override
        public boolean hasDeletions(VertexCentricQuery query) {
            return !StandardTitanTx.this.deletedRelations.isEmpty() && !query.getVertex().isNew() && query.getVertex().hasRemovedRelations();
        }

        @Override
        public boolean isDeleted(VertexCentricQuery query, TitanRelation result) {
            return StandardTitanTx.this.deletedRelations.containsKey(result.getLongId()) || result != ((InternalRelation)result).it();
        }

        @Override
        public Iterator<TitanRelation> execute(VertexCentricQuery query, SliceQuery sq, Object exeInfo) {
            assert (exeInfo == null);
            if (query.getVertex().isNew()) {
                return Iterators.emptyIterator();
            }
            final InternalVertex v = query.getVertex();
            EntryList iter = v.loadRelations(sq, new Retriever<SliceQuery, EntryList>(){

                @Override
                public EntryList get(SliceQuery query) {
                    return StandardTitanTx.this.graph.edgeQuery(v.getLongId(), query, StandardTitanTx.this.txHandle);
                }
            });
            return RelationConstructor.readRelation(v, iter, StandardTitanTx.this).iterator();
        }
    };
    public final QueryExecutor<GraphCentricQuery, TitanElement, JointIndexQuery> elementProcessor;
    public final QueryExecutor<GraphCentricQuery, TitanElement, JointIndexQuery> elementProcessorImpl = new QueryExecutor<GraphCentricQuery, TitanElement, JointIndexQuery>(){

        private PredicateCondition<PropertyKey, TitanElement> getEqualityCondition(Condition<TitanElement> condition) {
            if (condition instanceof PredicateCondition) {
                PredicateCondition pc = (PredicateCondition)condition;
                if (pc.getPredicate() == Cmp.EQUAL && TypeUtil.hasSimpleInternalVertexKeyIndex((PropertyKey)pc.getKey())) {
                    return pc;
                }
            } else if (condition instanceof And) {
                for (Condition<TitanElement> condition2 : ((And)condition).getChildren()) {
                    PredicateCondition<PropertyKey, TitanElement> p = this.getEqualityCondition(condition2);
                    if (p == null) continue;
                    return p;
                }
            }
            return null;
        }

        @Override
        public Iterator<TitanElement> getNew(final GraphCentricQuery query) {
            if (query.numSubQueries() == 1 && query.getSubQuery(0).getBackendQuery().isEmpty()) {
                return Iterators.emptyIterator();
            }
            Preconditions.checkArgument((boolean)query.getCondition().hasChildren(), (Object)"If the query is non-empty it needs to have a condition");
            if (query.getResultType() == ElementCategory.VERTEX && StandardTitanTx.this.hasModifications()) {
                Iterator vertices;
                Preconditions.checkArgument((boolean)QueryUtil.isQueryNormalForm(query.getCondition()));
                PredicateCondition<PropertyKey, TitanElement> standardIndexKey = this.getEqualityCondition(query.getCondition());
                if (standardIndexKey == null) {
                    final HashSet keys = Sets.newHashSet();
                    ConditionUtil.traversal(query.getCondition(), new Predicate<Condition<TitanElement>>(){

                        public boolean apply(@Nullable Condition<TitanElement> cond) {
                            Preconditions.checkArgument((cond.getType() != Condition.Type.LITERAL || cond instanceof PredicateCondition ? 1 : 0) != 0);
                            if (cond instanceof PredicateCondition) {
                                keys.add(((PredicateCondition)cond).getKey());
                            }
                            return true;
                        }
                    });
                    Preconditions.checkArgument((!keys.isEmpty() ? 1 : 0) != 0, (String)"Invalid query condition: %s", (Object[])new Object[]{query.getCondition()});
                    HashSet vertexSet = Sets.newHashSet();
                    for (TitanRelation titanRelation : StandardTitanTx.this.addedRelations.getView(new Predicate<InternalRelation>(){

                        public boolean apply(@Nullable InternalRelation relation) {
                            return keys.contains(relation.getType());
                        }
                    })) {
                        vertexSet.add(((TitanProperty)titanRelation).getVertex());
                    }
                    for (TitanRelation titanRelation : StandardTitanTx.this.deletedRelations.values()) {
                        TitanVertex v;
                        if (!keys.contains(titanRelation.getType()) || (v = ((TitanProperty)titanRelation).getVertex()).isRemoved()) continue;
                        vertexSet.add(v);
                    }
                    vertices = vertexSet.iterator();
                } else {
                    vertices = Iterators.transform(StandardTitanTx.this.newVertexIndexEntries.get(standardIndexKey.getValue(), standardIndexKey.getKey()).iterator(), (Function)new Function<TitanProperty, TitanVertex>(){

                        @Nullable
                        public TitanVertex apply(@Nullable TitanProperty o) {
                            return o.getVertex();
                        }
                    });
                }
                return Iterators.filter((Iterator)vertices, (Predicate)new Predicate<TitanVertex>(){

                    public boolean apply(@Nullable TitanVertex vertex) {
                        return query.matches(vertex);
                    }
                });
            }
            if (!(query.getResultType() != ElementCategory.EDGE && query.getResultType() != ElementCategory.PROPERTY || StandardTitanTx.this.addedRelations.isEmpty())) {
                return StandardTitanTx.this.addedRelations.getView(new Predicate<InternalRelation>(){

                    public boolean apply(@Nullable InternalRelation relation) {
                        return query.getResultType().isInstance(relation) && !relation.isHidden() && query.matches(relation);
                    }
                }).iterator();
            }
            return Iterators.emptyIterator();
        }

        @Override
        public boolean hasDeletions(GraphCentricQuery query) {
            return StandardTitanTx.this.hasModifications();
        }

        @Override
        public boolean isDeleted(GraphCentricQuery query, TitanElement result) {
            if (result == null || result.isRemoved()) {
                return true;
            }
            if (query.getResultType() == ElementCategory.VERTEX) {
                Preconditions.checkArgument((boolean)(result instanceof InternalVertex));
                InternalVertex v = ((InternalVertex)result).it();
                if (v.hasAddedRelations() || v.hasRemovedRelations()) {
                    return !query.matches(result);
                }
                return false;
            }
            if (query.getResultType() == ElementCategory.EDGE || query.getResultType() == ElementCategory.PROPERTY) {
                Preconditions.checkArgument((result.isLoaded() || result.isNew() ? 1 : 0) != 0);
                return result.isNew() && !query.matches(result);
            }
            throw new IllegalArgumentException("Unexpected type: " + (Object)((Object)query.getResultType()));
        }

        @Override
        public Iterator<TitanElement> execute(GraphCentricQuery query, JointIndexQuery indexQuery, Object exeInfo) {
            ArrayList retrievals;
            if (!indexQuery.isEmpty()) {
                retrievals = new ArrayList();
                for (int i = 0; i < indexQuery.size(); ++i) {
                    final JointIndexQuery.Subquery subquery = indexQuery.getQuery(i);
                    retrievals.add(new QueryUtil.IndexCall<Object>(){

                        @Override
                        public Collection<Object> call(int limit) {
                            final JointIndexQuery.Subquery adjustedQuery = subquery.updateLimit(limit);
                            try {
                                return (Collection)StandardTitanTx.this.indexCache.get((Object)adjustedQuery, (Callable)new Callable<List<Object>>(){

                                    @Override
                                    public List<Object> call() throws Exception {
                                        return StandardTitanTx.this.indexSerializer.query(adjustedQuery, StandardTitanTx.this.txHandle);
                                    }
                                });
                            }
                            catch (Exception e) {
                                throw new TitanException("Could not call index", e.getCause());
                            }
                        }
                    });
                }
            } else {
                if (StandardTitanTx.this.config.hasForceIndexUsage()) {
                    throw new TitanException("Could not find a suitable index to answer graph query and graph scans are disabled: " + query);
                }
                log.warn("Query requires iterating over all vertices [{}]. For better performance, use indexes", query.getCondition());
                switch (query.getResultType()) {
                    case VERTEX: {
                        return StandardTitanTx.this.getVertices().iterator();
                    }
                    case EDGE: {
                        return StandardTitanTx.this.getEdges().iterator();
                    }
                    case PROPERTY: {
                        return new VertexCentricEdgeIterable(StandardTitanTx.this.getInternalVertices(), RelationCategory.PROPERTY).iterator();
                    }
                }
                throw new IllegalArgumentException("Unexpected type: " + (Object)((Object)query.getResultType()));
            }
            List resultSet = QueryUtil.processIntersectingRetrievals(retrievals, indexQuery.getLimit());
            Iterator iter = Iterators.transform(resultSet.iterator(), StandardTitanTx.this.getConversionFunction(query.getResultType()));
            return iter;
        }
    };
    private final Function<Object, TitanVertex> vertexIDConversionFct = new Function<Object, TitanVertex>(){

        public TitanVertex apply(@Nullable Object id) {
            Preconditions.checkNotNull((Object)id);
            Preconditions.checkArgument((boolean)(id instanceof Long));
            return StandardTitanTx.this.getInternalVertex((Long)id);
        }
    };
    private final Function<Object, TitanEdge> edgeIDConversionFct = new Function<Object, TitanEdge>(){

        public TitanEdge apply(@Nullable Object id) {
            Preconditions.checkNotNull((Object)id);
            Preconditions.checkArgument((boolean)(id instanceof RelationIdentifier));
            return ((RelationIdentifier)id).findEdge(StandardTitanTx.this);
        }
    };
    private final Function<Object, TitanProperty> propertyIDConversionFct = new Function<Object, TitanProperty>(){

        public TitanProperty apply(@Nullable Object id) {
            Preconditions.checkNotNull((Object)id);
            Preconditions.checkArgument((boolean)(id instanceof RelationIdentifier));
            return ((RelationIdentifier)id).findProperty(StandardTitanTx.this);
        }
    };

    public StandardTitanTx(StandardTitanGraph graph, TransactionConfiguration config) {
        int concurrencyLevel;
        Preconditions.checkNotNull((Object)graph);
        Preconditions.checkArgument((boolean)graph.isOpen());
        Preconditions.checkNotNull((Object)config);
        this.graph = graph;
        this.times = graph.getConfiguration().getTimestampProvider();
        this.config = config;
        this.idManager = graph.getIDManager();
        this.idInspector = this.idManager.getIdInspector();
        this.attributeHandler = graph.getDataSerializer();
        this.edgeSerializer = graph.getEdgeSerializer();
        this.indexSerializer = graph.getIndexSerializer();
        this.temporaryIds = new IDPool(){
            private final AtomicLong counter = new AtomicLong(1L);

            @Override
            public long nextID() {
                return this.counter.getAndIncrement();
            }

            @Override
            public void close() {
            }
        };
        if (config.isSingleThreaded()) {
            this.addedRelations = new SimpleBufferAddedRelations();
            concurrencyLevel = 1;
            this.newTypeCache = new HashMap<String, Long>();
            this.newVertexIndexEntries = new SimpleIndexCache();
        } else {
            this.addedRelations = new ConcurrentBufferAddedRelations();
            concurrencyLevel = 1;
            this.newTypeCache = new NonBlockingHashMap();
            this.newVertexIndexEntries = new ConcurrentIndexCache();
        }
        this.externalVertexRetriever = new VertexConstructor(config.hasVerifyExternalVertexExistence());
        this.internalVertexRetriever = new VertexConstructor(config.hasVerifyInternalVertexExistence());
        this.vertexCache = new GuavaVertexCache(config.getVertexCacheSize(), concurrencyLevel, config.getDirtyVertexSize());
        this.indexCache = CacheBuilder.newBuilder().weigher((Weigher)new Weigher<JointIndexQuery.Subquery, List<Object>>(){

            public int weigh(JointIndexQuery.Subquery q, List<Object> r) {
                return 2 + r.size();
            }
        }).concurrencyLevel(concurrencyLevel).maximumWeight(config.getIndexCacheWeight()).build();
        this.uniqueLocks = UNINITIALIZED_LOCKS;
        this.deletedRelations = EMPTY_DELETED_RELATIONS;
        this.isOpen = true;
        if (null != config.getGroupName()) {
            MetricManager.INSTANCE.getCounter(config.getGroupName(), "tx", "begin").inc();
            this.elementProcessor = new MetricsQueryExecutor<GraphCentricQuery, TitanElement, JointIndexQuery>(config.getGroupName(), "graph", this.elementProcessorImpl);
            this.edgeProcessor = new MetricsQueryExecutor<VertexCentricQuery, TitanRelation, SliceQuery>(config.getGroupName(), "vertex", this.edgeProcessorImpl);
        } else {
            this.elementProcessor = this.elementProcessorImpl;
            this.edgeProcessor = this.edgeProcessorImpl;
        }
    }

    public void setBackendTransaction(BackendTransaction txHandle) {
        Preconditions.checkArgument((this.txHandle == null && txHandle != null ? 1 : 0) != 0);
        this.txHandle = txHandle;
    }

    private void verifyWriteAccess(TitanVertex ... vertices) {
        if (this.config.isReadOnly()) {
            throw new UnsupportedOperationException("Cannot create new entities in read-only transaction");
        }
        for (TitanVertex v : vertices) {
            if (!v.hasId() || !this.idInspector.isUnmodifiableVertex(v.getLongId()) || v.isNew()) continue;
            throw new IllegalArgumentException("Cannot modify unmodifiable vertex: " + v);
        }
        this.verifyAccess(vertices);
    }

    public final void verifyAccess(TitanVertex ... vertices) {
        this.verifyOpen();
        for (TitanVertex v : vertices) {
            Preconditions.checkArgument((boolean)(v instanceof InternalVertex), (String)"Invalid vertex: %s", (Object[])new Object[]{v});
            if (!(v instanceof SystemRelationType) && this != ((InternalVertex)v).tx()) {
                throw new IllegalArgumentException("The vertex or type is not associated with this transaction [" + v + "]");
            }
            if (!v.isRemoved()) continue;
            throw new IllegalArgumentException("The vertex or type has been removed [" + v + "]");
        }
    }

    private void verifyOpen() {
        if (this.isClosed()) {
            throw new IllegalStateException("Operation cannot be executed because the enclosing transaction is closed");
        }
    }

    public StandardTitanTx getNextTx() {
        Preconditions.checkArgument((boolean)this.isClosed());
        if (!this.config.isThreadBound()) {
            throw new IllegalStateException("Cannot access element because its enclosing transaction is closed and unbound");
        }
        return (StandardTitanTx)this.graph.getCurrentThreadTx();
    }

    public TransactionConfiguration getConfiguration() {
        return this.config;
    }

    @Override
    public StandardTitanGraph getGraph() {
        return this.graph;
    }

    public BackendTransaction getTxHandle() {
        return this.txHandle;
    }

    public EdgeSerializer getEdgeSerializer() {
        return this.edgeSerializer;
    }

    public IDInspector getIdInspector() {
        return this.idInspector;
    }

    public boolean isPartitionedVertex(TitanVertex vertex) {
        return vertex.hasId() && this.idInspector.isPartitionedVertex(vertex.getLongId());
    }

    public InternalVertex getCanonicalVertex(InternalVertex partitionedVertex) {
        Preconditions.checkArgument((boolean)this.isPartitionedVertex(partitionedVertex));
        long canonicalId = this.idManager.getCanonicalVertexId(partitionedVertex.getLongId());
        if (canonicalId == partitionedVertex.getLongId()) {
            return partitionedVertex;
        }
        return this.getExistingVertex(canonicalId);
    }

    public InternalVertex getOtherPartitionVertex(TitanVertex partitionedVertex, long otherPartition) {
        Preconditions.checkArgument((boolean)this.isPartitionedVertex(partitionedVertex));
        return this.getExistingVertex(this.idManager.getPartitionedVertexId(partitionedVertex.getLongId(), otherPartition));
    }

    public InternalVertex[] getAllRepresentatives(TitanVertex partitionedVertex, boolean restrict2Partitions) {
        int i;
        long[] ids;
        Preconditions.checkArgument((boolean)this.isPartitionedVertex(partitionedVertex));
        if (!restrict2Partitions || !this.config.hasRestrictedPartitions()) {
            ids = this.idManager.getPartitionedVertexRepresentatives(partitionedVertex.getLongId());
        } else {
            int[] restrictedParititions = this.config.getRestrictedPartitions();
            ids = new long[restrictedParititions.length];
            for (i = 0; i < ids.length; ++i) {
                ids[i] = this.idManager.getPartitionedVertexId(partitionedVertex.getLongId(), restrictedParititions[i]);
            }
        }
        Preconditions.checkArgument((ids.length > 0 ? 1 : 0) != 0);
        InternalVertex[] vertices = new InternalVertex[ids.length];
        for (i = 0; i < ids.length; ++i) {
            vertices[i] = this.getExistingVertex(ids[i]);
        }
        return vertices;
    }

    @Override
    public boolean containsVertex(long vertexid) {
        return this.getVertex(vertexid) != null;
    }

    @Override
    public TitanVertex getVertex(long vertexid) {
        InternalVertex v;
        this.verifyOpen();
        if (vertexid <= 0L || !this.idInspector.isSchemaVertexId(vertexid) && !this.idInspector.isUserVertexId(vertexid)) {
            return null;
        }
        if (this.idInspector.isPartitionedVertex(vertexid)) {
            vertexid = this.idManager.getCanonicalVertexId(vertexid);
        }
        if (null != this.config.getGroupName()) {
            MetricManager.INSTANCE.getCounter(this.config.getGroupName(), "db", "getVertexByID").inc();
        }
        return (v = this.vertexCache.get(vertexid, this.externalVertexRetriever)).isRemoved() ? null : v;
    }

    private InternalVertex getExistingVertex(long vertexid) {
        return this.vertexCache.get(vertexid, this.existingVertexRetriever);
    }

    @Override
    public InternalVertex getInternalVertex(long vertexid) {
        return this.vertexCache.get(vertexid, this.internalVertexRetriever);
    }

    @Override
    public TitanVertex addVertex(Long vertexId, VertexLabel label) {
        this.verifyWriteAccess(new TitanVertex[0]);
        if (label == null) {
            label = BaseVertexLabel.DEFAULT_VERTEXLABEL;
        }
        if (vertexId != null && !this.graph.getConfiguration().allowVertexIdSetting()) {
            log.info("Provided vertex id [{}] is ignored because vertex id setting is not enabled", (Object)vertexId);
            vertexId = null;
        }
        Preconditions.checkArgument((vertexId != null || !this.graph.getConfiguration().allowVertexIdSetting() ? 1 : 0) != 0, (Object)"Must provide vertex id");
        Preconditions.checkArgument((vertexId == null || IDManager.VertexIDType.NormalVertex.is(vertexId) ? 1 : 0) != 0, (String)"Not a valid vertex id: %s", (Object[])new Object[]{vertexId});
        Preconditions.checkArgument((vertexId == null || ((InternalVertexLabel)label).hasDefaultConfiguration() ? 1 : 0) != 0, (String)"Cannot only use default vertex labels: %s", (Object[])new Object[]{label});
        Preconditions.checkArgument((vertexId == null || !this.config.hasVerifyExternalVertexExistence() || !this.containsVertex(vertexId) ? 1 : 0) != 0, (String)"Vertex with given id already exists: %s", (Object[])new Object[]{vertexId});
        StandardVertex vertex = new StandardVertex(this, IDManager.getTemporaryVertexID(IDManager.VertexIDType.NormalVertex, this.temporaryIds.nextID()), 1);
        if (vertexId != null) {
            vertex.setId(vertexId);
        } else if (this.config.hasAssignIDsImmediately() || label.isPartitioned()) {
            this.graph.assignID(vertex, label);
        }
        this.addProperty((TitanVertex)vertex, BaseKey.VertexExists, (Object)Boolean.TRUE);
        if (label != BaseVertexLabel.DEFAULT_VERTEXLABEL) {
            Preconditions.checkArgument((boolean)(label instanceof VertexLabelVertex));
            this.addEdge((TitanVertex)vertex, (TitanVertex)((VertexLabelVertex)label), BaseLabel.VertexLabelEdge);
        }
        this.vertexCache.add(vertex, vertex.getLongId());
        return vertex;
    }

    @Override
    public TitanVertex addVertex() {
        return this.addVertexWithLabel(BaseVertexLabel.DEFAULT_VERTEXLABEL);
    }

    @Override
    public TitanVertex addVertexWithLabel(String vertexLabel) {
        return this.addVertexWithLabel(this.getVertexLabel(vertexLabel));
    }

    @Override
    public TitanVertex addVertexWithLabel(VertexLabel vertexLabel) {
        return this.addVertex(null, vertexLabel);
    }

    private Iterable<InternalVertex> getInternalVertices() {
        Iterable<InternalVertex> allVertices;
        if (!this.addedRelations.isEmpty()) {
            List<InternalVertex> newVs = this.vertexCache.getAllNew();
            Iterator<InternalVertex> viter = newVs.iterator();
            while (viter.hasNext()) {
                if (!(viter.next() instanceof TitanSchemaElement)) continue;
                viter.remove();
            }
            allVertices = Iterables.concat(newVs, (Iterable)new VertexIterable(this.graph, this));
        } else {
            allVertices = new VertexIterable(this.graph, this);
        }
        return Iterables.filter((Iterable)allVertices, (Predicate)new Predicate<InternalVertex>(){

            public boolean apply(@Nullable InternalVertex internalVertex) {
                return !StandardTitanTx.this.isPartitionedVertex(internalVertex) || internalVertex.getLongId() == StandardTitanTx.this.idInspector.getCanonicalVertexId(internalVertex.getLongId());
            }
        });
    }

    public Iterable<Vertex> getVertices() {
        return this.getInternalVertices();
    }

    public final Object verifyAttribute(PropertyKey key, Object attribute) {
        Preconditions.checkNotNull((Object)attribute, (Object)"Property value cannot be null");
        Class<?> datatype = key.getDataType();
        if (datatype.equals(Object.class)) {
            return attribute;
        }
        if (!attribute.getClass().equals(datatype)) {
            Object converted = this.attributeHandler.convert(datatype, attribute);
            Preconditions.checkArgument((converted != null ? 1 : 0) != 0, (String)"Value [%s] is not an instance of the expected data type for property key [%s] and cannot be converted. Expected: %s, found: %s", (Object[])new Object[]{attribute, key.getName(), datatype, attribute.getClass()});
            attribute = converted;
        }
        Preconditions.checkState((boolean)attribute.getClass().equals(datatype));
        this.attributeHandler.verifyAttribute(datatype, attribute);
        return attribute;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRelation(InternalRelation relation) {
        int i;
        Preconditions.checkArgument((!relation.isRemoved() ? 1 : 0) != 0);
        relation = relation.it();
        for (i = 0; i < relation.getLen(); ++i) {
            this.verifyWriteAccess(relation.getVertex(i));
        }
        for (i = 0; i < relation.getLen(); ++i) {
            relation.getVertex(i).removeRelation(relation);
        }
        if (relation.isNew()) {
            this.addedRelations.remove(relation);
            if (TypeUtil.hasSimpleInternalVertexKeyIndex(relation)) {
                this.newVertexIndexEntries.remove((TitanProperty)((Object)relation));
            }
        } else {
            Preconditions.checkArgument((boolean)relation.isLoaded());
            if (this.deletedRelations == EMPTY_DELETED_RELATIONS) {
                if (this.config.isSingleThreaded()) {
                    this.deletedRelations = new HashMap<Long, InternalRelation>();
                } else {
                    StandardTitanTx standardTitanTx = this;
                    synchronized (standardTitanTx) {
                        if (this.deletedRelations == EMPTY_DELETED_RELATIONS) {
                            this.deletedRelations = new ConcurrentHashMap<Long, InternalRelation>();
                        }
                    }
                }
            }
            this.deletedRelations.put(relation.getLongId(), relation);
        }
    }

    public boolean isRemovedRelation(Long relationId) {
        return this.deletedRelations.containsKey(relationId);
    }

    private TransactionLock getLock(Object ... tuple) {
        return this.getLock(new LockTuple(tuple));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TransactionLock getLock(LockTuple la) {
        ReentrantTransactionLock lock;
        TransactionLock existingLock;
        if (this.config.isSingleThreaded()) {
            return FakeLock.INSTANCE;
        }
        if (this.uniqueLocks == UNINITIALIZED_LOCKS) {
            Preconditions.checkArgument((!this.config.isSingleThreaded() ? 1 : 0) != 0);
            StandardTitanTx standardTitanTx = this;
            synchronized (standardTitanTx) {
                if (this.uniqueLocks == UNINITIALIZED_LOCKS) {
                    this.uniqueLocks = new ConcurrentHashMap<LockTuple, TransactionLock>();
                }
            }
        }
        return (existingLock = this.uniqueLocks.putIfAbsent(la, lock = new ReentrantTransactionLock())) == null ? lock : existingLock;
    }

    private TransactionLock getUniquenessLock(TitanVertex out, InternalRelationType type, Object in) {
        Multiplicity multiplicity = type.getMultiplicity();
        TransactionLock uniqueLock = FakeLock.INSTANCE;
        if (this.config.hasVerifyUniqueness() && multiplicity.isConstrained()) {
            uniqueLock = null;
            if (multiplicity == Multiplicity.SIMPLE) {
                uniqueLock = this.getLock(out, type, in);
            } else {
                for (Direction dir : Direction.proper) {
                    if (!multiplicity.isUnique(dir)) continue;
                    TransactionLock lock = this.getLock(dir == Direction.OUT ? out : in, type, dir);
                    uniqueLock = uniqueLock == null ? lock : new CombinerLock(uniqueLock, lock, this.times);
                }
            }
        }
        assert (uniqueLock != null);
        return uniqueLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TitanEdge addEdge(TitanVertex outVertex, TitanVertex inVertex, EdgeLabel label) {
        this.verifyWriteAccess(outVertex, inVertex);
        outVertex = ((InternalVertex)outVertex).it();
        inVertex = ((InternalVertex)inVertex).it();
        Preconditions.checkNotNull((Object)label);
        Multiplicity multiplicity = label.getMultiplicity();
        TransactionLock uniqueLock = this.getUniquenessLock(outVertex, (InternalRelationType)((Object)label), inVertex);
        uniqueLock.lock(LOCK_TIMEOUT);
        try {
            if (this.config.hasVerifyUniqueness()) {
                if (multiplicity == Multiplicity.SIMPLE) {
                    Preconditions.checkArgument((boolean)Iterables.isEmpty(((VertexCentricQueryBuilder)((VertexCentricQueryBuilder)((VertexCentricQueryBuilder)this.query(outVertex).type(label)).direction(Direction.OUT)).adjacent(inVertex)).titanEdges()), (String)"An edge with the given label already exists between the pair of vertices and the label [%s] is simple", (Object[])new Object[]{label.getName()});
                }
                if (multiplicity.isUnique(Direction.OUT)) {
                    Preconditions.checkArgument((boolean)Iterables.isEmpty(((VertexCentricQueryBuilder)((VertexCentricQueryBuilder)this.query(outVertex).type(label)).direction(Direction.OUT)).titanEdges()), (String)"An edge with the given label already exists on the out-vertex and the label [%s] is out-unique", (Object[])new Object[]{label.getName()});
                }
                if (multiplicity.isUnique(Direction.IN)) {
                    Preconditions.checkArgument((boolean)Iterables.isEmpty(((VertexCentricQueryBuilder)((VertexCentricQueryBuilder)this.query(inVertex).type(label)).direction(Direction.IN)).titanEdges()), (String)"An edge with the given label already exists on the in-vertex and the label [%s] is in-unique", (Object[])new Object[]{label.getName()});
                }
            }
            StandardEdge edge = new StandardEdge(IDManager.getTemporaryRelationID(this.temporaryIds.nextID()), label, (InternalVertex)outVertex, (InternalVertex)inVertex, 1);
            if (this.config.hasAssignIDsImmediately()) {
                this.graph.assignID(edge);
            }
            this.connectRelation(edge);
            StandardEdge standardEdge = edge;
            return standardEdge;
        }
        finally {
            uniqueLock.unlock();
        }
    }

    private void connectRelation(InternalRelation r) {
        for (int i = 0; i < r.getLen(); ++i) {
            boolean success = r.getVertex(i).addRelation(r);
            if (!success) {
                throw new AssertionError((Object)("Could not connect relation: " + r));
            }
        }
        this.addedRelations.add(r);
        for (int pos = 0; pos < r.getLen(); ++pos) {
            this.vertexCache.add(r.getVertex(pos), r.getVertex(pos).getLongId());
        }
        if (TypeUtil.hasSimpleInternalVertexKeyIndex(r)) {
            this.newVertexIndexEntries.add((TitanProperty)((Object)r));
        }
    }

    @Override
    public TitanProperty addProperty(TitanVertex vertex, PropertyKey key, Object value) {
        if (key.getCardinality() == Cardinality.SINGLE) {
            return this.setProperty(vertex, key, value);
        }
        return this.addPropertyInternal(vertex, key, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TitanProperty addPropertyInternal(TitanVertex vertex, PropertyKey key, Object value) {
        this.verifyWriteAccess(vertex);
        Preconditions.checkArgument((!(key instanceof ImplicitKey) ? 1 : 0) != 0, (String)"Cannot create a property of implicit type: %s", (Object[])new Object[]{key.getName()});
        vertex = ((InternalVertex)vertex).it();
        Preconditions.checkNotNull((Object)key);
        final Object normalizedValue = this.verifyAttribute(key, value);
        Cardinality cardinality = key.getCardinality();
        ArrayList<IndexLockTuple> uniqueIndexTuples = new ArrayList<IndexLockTuple>();
        for (CompositeIndexType index : TypeUtil.getUniqueIndexes(key)) {
            IndexSerializer.IndexRecords matches = IndexSerializer.indexMatches(vertex, index, key, normalizedValue);
            for (Object[] match : matches.getRecordValues()) {
                uniqueIndexTuples.add(new IndexLockTuple(index, match));
            }
        }
        TransactionLock uniqueLock = this.getUniquenessLock(vertex, (InternalRelationType)((Object)key), normalizedValue);
        for (IndexLockTuple lockTuple : uniqueIndexTuples) {
            uniqueLock = new CombinerLock(uniqueLock, this.getLock(lockTuple), this.times);
        }
        uniqueLock.lock(LOCK_TIMEOUT);
        try {
            if (this.config.hasVerifyUniqueness()) {
                if (cardinality == Cardinality.SINGLE) {
                    Preconditions.checkArgument((boolean)Iterables.isEmpty(((VertexCentricQueryBuilder)this.query(vertex).type(key)).properties()), (String)"A property with the given key [%s] already exists on the vertex [%s] and the property key is defined as single-valued", (Object[])new Object[]{key.getName(), vertex});
                }
                if (cardinality == Cardinality.SET) {
                    Preconditions.checkArgument((boolean)Iterables.isEmpty((Iterable)Iterables.filter(((VertexCentricQueryBuilder)this.query(vertex).type(key)).properties(), (Predicate)new Predicate<TitanProperty>(){

                        public boolean apply(@Nullable TitanProperty titanProperty) {
                            return normalizedValue.equals(titanProperty.getValue());
                        }
                    })), (String)"A property with the given key [%s] and value [%s] already exists on the vertex and the property key is defined as set-valued", (Object[])new Object[]{key.getName(), normalizedValue});
                }
                for (IndexLockTuple lockTuple : uniqueIndexTuples) {
                    Preconditions.checkArgument((boolean)Iterables.isEmpty(IndexHelper.getQueryResults(lockTuple.getIndex(), lockTuple.getAll(), this)), (String)"Adding this property for key [%s] and value [%s] violates a uniqueness constraint [%s]", (Object[])new Object[]{key.getName(), normalizedValue, lockTuple.getIndex()});
                }
            }
            StandardProperty prop = new StandardProperty(IDManager.getTemporaryRelationID(this.temporaryIds.nextID()), key, (InternalVertex)vertex, normalizedValue, 1);
            if (this.config.hasAssignIDsImmediately()) {
                this.graph.assignID(prop);
            }
            this.connectRelation(prop);
            StandardProperty standardProperty = prop;
            return standardProperty;
        }
        finally {
            uniqueLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TitanProperty setProperty(TitanVertex vertex, final PropertyKey key, Object value) {
        this.verifyWriteAccess(vertex);
        Preconditions.checkNotNull((Object)key);
        Preconditions.checkArgument((key.getCardinality() == Cardinality.SINGLE ? 1 : 0) != 0, (String)"Not an single key: %s. Use addProperty instead", (Object[])new Object[]{key.getName()});
        TransactionLock uniqueLock = FakeLock.INSTANCE;
        try {
            if (this.config.hasVerifyUniqueness()) {
                uniqueLock = this.getLock(vertex, key, Direction.OUT);
                uniqueLock.lock(LOCK_TIMEOUT);
                vertex.removeProperty(key);
            } else {
                InternalVertex v = (InternalVertex)vertex;
                for (InternalRelation r : v.it().getAddedRelations(new Predicate<InternalRelation>(){

                    public boolean apply(@Nullable InternalRelation p) {
                        return p.getType().equals(key);
                    }
                })) {
                    r.remove();
                }
            }
            TitanProperty titanProperty = this.addPropertyInternal(vertex, key, value);
            return titanProperty;
        }
        finally {
            uniqueLock.unlock();
        }
    }

    public Iterable<Edge> getEdges() {
        return new VertexCentricEdgeIterable<Edge>(this.getInternalVertices(), RelationCategory.EDGE);
    }

    public final TitanSchemaVertex makeSchemaVertex(TitanSchemaCategory schemaCategory, String name, TypeDefinitionMap definition) {
        TitanSchemaVertex schemaVertex;
        this.verifyOpen();
        Preconditions.checkArgument((!schemaCategory.hasName() || StringUtils.isNotBlank((String)name) ? 1 : 0) != 0, (String)"Need to provide a valid name for type [%s]", (Object[])new Object[]{schemaCategory});
        schemaCategory.verifyValidDefinition(definition);
        if (schemaCategory.isRelationType()) {
            if (schemaCategory == TitanSchemaCategory.PROPERTYKEY) {
                schemaVertex = new PropertyKeyVertex(this, IDManager.getTemporaryVertexID(IDManager.VertexIDType.UserPropertyKey, this.temporaryIds.nextID()), 1);
            } else {
                assert (schemaCategory == TitanSchemaCategory.EDGELABEL);
                schemaVertex = new EdgeLabelVertex(this, IDManager.getTemporaryVertexID(IDManager.VertexIDType.UserEdgeLabel, this.temporaryIds.nextID()), 1);
            }
        } else {
            schemaVertex = schemaCategory == TitanSchemaCategory.VERTEXLABEL ? new VertexLabelVertex(this, IDManager.getTemporaryVertexID(IDManager.VertexIDType.GenericSchemaType, this.temporaryIds.nextID()), 1) : new TitanSchemaVertex(this, IDManager.getTemporaryVertexID(IDManager.VertexIDType.GenericSchemaType, this.temporaryIds.nextID()), 1);
        }
        this.graph.assignID(schemaVertex, BaseVertexLabel.DEFAULT_VERTEXLABEL);
        Preconditions.checkArgument((schemaVertex.getLongId() > 0L ? 1 : 0) != 0);
        if (schemaCategory.hasName()) {
            this.addProperty((TitanVertex)schemaVertex, BaseKey.SchemaName, (Object)schemaCategory.getSchemaName(name));
        }
        this.addProperty((TitanVertex)schemaVertex, BaseKey.VertexExists, (Object)Boolean.TRUE);
        this.addProperty((TitanVertex)schemaVertex, BaseKey.SchemaCategory, (Object)schemaCategory);
        for (Map.Entry def : definition.entrySet()) {
            TitanProperty p = this.addProperty((TitanVertex)schemaVertex, BaseKey.SchemaDefinitionProperty, def.getValue());
            p.setProperty(BaseKey.SchemaDefinitionDesc, (Object)TypeDefinitionDescription.of((TypeDefinitionCategory)((Object)def.getKey())));
        }
        this.vertexCache.add(schemaVertex, schemaVertex.getLongId());
        if (schemaCategory.hasName()) {
            this.newTypeCache.put(schemaCategory.getSchemaName(name), schemaVertex.getLongId());
        }
        return schemaVertex;
    }

    public PropertyKey makePropertyKey(String name, TypeDefinitionMap definition) {
        return (PropertyKey)((Object)this.makeSchemaVertex(TitanSchemaCategory.PROPERTYKEY, name, definition));
    }

    public EdgeLabel makeEdgeLabel(String name, TypeDefinitionMap definition) {
        return (EdgeLabel)((Object)this.makeSchemaVertex(TitanSchemaCategory.EDGELABEL, name, definition));
    }

    @Override
    public boolean containsRelationType(String name) {
        this.verifyOpen();
        if (SystemTypeManager.isSystemType(name)) {
            return true;
        }
        return this.getSchemaVertex(TitanSchemaCategory.getRelationTypeName(name)) != null;
    }

    public TitanSchemaVertex getSchemaVertex(String schemaName) {
        Long schemaId = this.newTypeCache.get(schemaName);
        if (schemaId == null) {
            schemaId = this.graph.getSchemaCache().getSchemaId(schemaName, this);
        }
        if (schemaId != null) {
            InternalVertex typeVertex = this.vertexCache.get(schemaId, this.existingVertexRetriever);
            assert (typeVertex != null);
            return (TitanSchemaVertex)typeVertex;
        }
        return null;
    }

    @Override
    public RelationType getRelationType(String name) {
        this.verifyOpen();
        SystemRelationType type = SystemTypeManager.getSystemType(name);
        if (type != null) {
            return type;
        }
        return (RelationType)((Object)this.getSchemaVertex(TitanSchemaCategory.getRelationTypeName(name)));
    }

    @Override
    public RelationType getExistingRelationType(long typeid) {
        assert (this.idInspector.isRelationTypeId(typeid));
        if (this.idInspector.isSystemRelationTypeId(typeid)) {
            return SystemTypeManager.getSystemType(typeid);
        }
        InternalVertex v = this.getInternalVertex(typeid);
        return (RelationType)((Object)v);
    }

    @Override
    public PropertyKey getPropertyKey(String name) {
        RelationType et = this.getRelationType(name);
        if (et == null) {
            return this.config.getAutoSchemaMaker().makePropertyKey(this.makePropertyKey(name));
        }
        if (et.isPropertyKey()) {
            return (PropertyKey)et;
        }
        throw new IllegalArgumentException("The type of given name is not a key: " + name);
    }

    @Override
    public EdgeLabel getEdgeLabel(String name) {
        RelationType et = this.getRelationType(name);
        if (et == null) {
            return this.config.getAutoSchemaMaker().makeEdgeLabel(this.makeEdgeLabel(name));
        }
        if (et.isEdgeLabel()) {
            return (EdgeLabel)et;
        }
        throw new IllegalArgumentException("The type of given name is not a label: " + name);
    }

    @Override
    public PropertyKeyMaker makePropertyKey(String name) {
        StandardPropertyKeyMaker maker = new StandardPropertyKeyMaker(this, this.indexSerializer, this.attributeHandler);
        maker.name(name);
        return maker;
    }

    @Override
    public EdgeLabelMaker makeEdgeLabel(String name) {
        StandardEdgeLabelMaker maker = new StandardEdgeLabelMaker(this, this.indexSerializer, this.attributeHandler);
        maker.name(name);
        return maker;
    }

    @Override
    public VertexLabel getExistingVertexLabel(long id) {
        assert (this.idInspector.isVertexLabelVertexId(id));
        InternalVertex v = this.getInternalVertex(id);
        return (VertexLabelVertex)v;
    }

    @Override
    public boolean containsVertexLabel(String name) {
        this.verifyOpen();
        if (BaseVertexLabel.DEFAULT_VERTEXLABEL.getName().equals(name)) {
            return true;
        }
        return this.getSchemaVertex(TitanSchemaCategory.VERTEXLABEL.getSchemaName(name)) != null;
    }

    @Override
    public VertexLabel getVertexLabel(String name) {
        this.verifyOpen();
        if (BaseVertexLabel.DEFAULT_VERTEXLABEL.getName().equals(name)) {
            return BaseVertexLabel.DEFAULT_VERTEXLABEL;
        }
        VertexLabel vlabel = (VertexLabel)((Object)this.getSchemaVertex(TitanSchemaCategory.VERTEXLABEL.getSchemaName(name)));
        if (vlabel == null) {
            vlabel = this.config.getAutoSchemaMaker().makeVertexLabel(this.makeVertexLabel(name));
        }
        return vlabel;
    }

    @Override
    public VertexLabelMaker makeVertexLabel(String name) {
        StandardVertexLabelMaker maker = new StandardVertexLabelMaker(this);
        maker.name(name);
        return maker;
    }

    public VertexCentricQueryBuilder query(TitanVertex vertex) {
        return new VertexCentricQueryBuilder(((InternalVertex)vertex).it());
    }

    public TitanMultiVertexQuery multiQuery(TitanVertex ... vertices) {
        MultiVertexCentricQueryBuilder builder = new MultiVertexCentricQueryBuilder(this);
        for (TitanVertex v : vertices) {
            builder.addVertex(v);
        }
        return builder;
    }

    public TitanMultiVertexQuery multiQuery(Collection<TitanVertex> vertices) {
        MultiVertexCentricQueryBuilder builder = new MultiVertexCentricQueryBuilder(this);
        builder.addAllVertices(vertices);
        return builder;
    }

    public void executeMultiQuery(Collection<InternalVertex> vertices, SliceQuery sq) {
        LongArrayList vids = new LongArrayList(vertices.size());
        for (InternalVertex v : vertices) {
            if (v.isNew() || !v.hasId() || !(v instanceof CacheVertex) || v.hasLoadedRelations(sq)) continue;
            vids.add(v.getLongId());
        }
        if (!vids.isEmpty()) {
            List<EntryList> results = this.graph.edgeMultiQuery(vids, sq, this.txHandle);
            int pos = 0;
            for (TitanVertex titanVertex : vertices) {
                if (pos >= vids.size() || vids.get(pos) != titanVertex.getLongId()) continue;
                final EntryList vresults = results.get(pos);
                ((CacheVertex)titanVertex).loadRelations(sq, new Retriever<SliceQuery, EntryList>(){

                    @Override
                    public EntryList get(SliceQuery query) {
                        return vresults;
                    }
                });
                ++pos;
            }
        }
    }

    public Function<Object, ? extends TitanElement> getConversionFunction(ElementCategory elementCategory) {
        switch (elementCategory) {
            case VERTEX: {
                return this.vertexIDConversionFct;
            }
            case EDGE: {
                return this.edgeIDConversionFct;
            }
            case PROPERTY: {
                return this.propertyIDConversionFct;
            }
        }
        throw new IllegalArgumentException("Unexpected result type: " + (Object)((Object)elementCategory));
    }

    public GraphCentricQueryBuilder query() {
        return new GraphCentricQueryBuilder(this, this.graph.getIndexSerializer());
    }

    @Override
    public TitanIndexQuery indexQuery(String indexName, String query) {
        return new IndexQueryBuilder(this, this.indexSerializer).setIndex(indexName).setQuery(query);
    }

    @Override
    public Iterable<TitanVertex> getVertices(PropertyKey key, Object attribute) {
        Preconditions.checkNotNull((Object)key);
        Preconditions.checkNotNull((Object)attribute);
        return this.query().has(key, (TitanPredicate)Cmp.EQUAL, attribute).vertices();
    }

    @Override
    public Iterable<TitanEdge> getEdges(PropertyKey key, Object attribute) {
        Preconditions.checkNotNull((Object)key);
        Preconditions.checkNotNull((Object)attribute);
        return this.query().has(key, (TitanPredicate)Cmp.EQUAL, attribute).edges();
    }

    @Override
    public synchronized void commit() {
        Preconditions.checkArgument((boolean)this.isOpen(), (Object)"The transaction has already been closed");
        boolean success = false;
        if (null != this.config.getGroupName()) {
            MetricManager.INSTANCE.getCounter(this.config.getGroupName(), "tx", "commit").inc();
        }
        try {
            if (this.hasModifications()) {
                this.graph.commit(this.addedRelations.getAll(), this.deletedRelations.values(), this);
            } else {
                this.txHandle.commit();
            }
            success = true;
            this.close();
        }
        catch (Exception e) {
            try {
                try {
                    this.txHandle.rollback();
                }
                catch (BackendException e1) {
                    throw new TitanException("Could not rollback after a failed commit", e);
                }
                throw new TitanException("Could not commit transaction due to exception during persistence", e);
            }
            catch (Throwable throwable) {
                this.close();
                if (null != this.config.getGroupName() && !success) {
                    MetricManager.INSTANCE.getCounter(this.config.getGroupName(), "tx", "commit.exceptions").inc();
                }
                throw throwable;
            }
        }
        if (null != this.config.getGroupName() && !success) {
            MetricManager.INSTANCE.getCounter(this.config.getGroupName(), "tx", "commit.exceptions").inc();
        }
    }

    @Override
    public synchronized void rollback() {
        Preconditions.checkArgument((boolean)this.isOpen(), (Object)"The transaction has already been closed");
        boolean success = false;
        if (null != this.config.getGroupName()) {
            MetricManager.INSTANCE.getCounter(this.config.getGroupName(), "tx", "rollback").inc();
        }
        try {
            this.txHandle.rollback();
            success = true;
            this.close();
        }
        catch (Exception e) {
            try {
                throw new TitanException("Could not rollback transaction due to exception", e);
            }
            catch (Throwable throwable) {
                this.close();
                if (null != this.config.getGroupName() && !success) {
                    MetricManager.INSTANCE.getCounter(this.config.getGroupName(), "tx", "rollback.exceptions").inc();
                }
                throw throwable;
            }
        }
        if (null != this.config.getGroupName() && !success) {
            MetricManager.INSTANCE.getCounter(this.config.getGroupName(), "tx", "rollback.exceptions").inc();
        }
    }

    private void close() {
        this.isOpen = false;
        this.graph.closeTransaction(this);
        this.vertexCache.close();
    }

    @Override
    public boolean isOpen() {
        return this.isOpen;
    }

    @Override
    public boolean isClosed() {
        return !this.isOpen;
    }

    @Override
    public boolean hasModifications() {
        return !this.addedRelations.isEmpty() || !this.deletedRelations.isEmpty();
    }

    private class VertexConstructor
    implements Retriever<Long, InternalVertex> {
        private final boolean verifyExistence;

        private VertexConstructor(boolean verifyExistence) {
            this.verifyExistence = verifyExistence;
        }

        @Override
        public InternalVertex get(Long vertexid) {
            long canonicalVertexId;
            Preconditions.checkNotNull((Object)vertexid);
            Preconditions.checkArgument((vertexid > 0L ? 1 : 0) != 0);
            Preconditions.checkArgument((StandardTitanTx.this.idInspector.isSchemaVertexId(vertexid) || StandardTitanTx.this.idInspector.isUserVertexId(vertexid) ? 1 : 0) != 0, (String)"Not a valid vertex id: %s", (Object[])new Object[]{vertexid});
            byte lifecycle = 2;
            long l = canonicalVertexId = StandardTitanTx.this.idInspector.isPartitionedVertex(vertexid) ? StandardTitanTx.this.idManager.getCanonicalVertexId(vertexid) : vertexid.longValue();
            if (this.verifyExistence && StandardTitanTx.this.graph.edgeQuery(canonicalVertexId, ((StandardTitanTx)StandardTitanTx.this).graph.vertexExistenceQuery, StandardTitanTx.this.txHandle).isEmpty()) {
                lifecycle = 6;
            }
            if (canonicalVertexId != vertexid) {
                lifecycle = StandardTitanTx.this.getExistingVertex(canonicalVertexId).getLifeCycle();
            }
            InternalVertex vertex = null;
            if (StandardTitanTx.this.idInspector.isRelationTypeId(vertexid)) {
                if (StandardTitanTx.this.idInspector.isPropertyKeyId(vertexid)) {
                    vertex = StandardTitanTx.this.idInspector.isSystemRelationTypeId(vertexid) ? SystemTypeManager.getSystemType(vertexid) : new PropertyKeyVertex(StandardTitanTx.this, vertexid, lifecycle);
                } else {
                    assert (StandardTitanTx.this.idInspector.isEdgeLabelId(vertexid));
                    vertex = StandardTitanTx.this.idInspector.isSystemRelationTypeId(vertexid) ? SystemTypeManager.getSystemType(vertexid) : new EdgeLabelVertex(StandardTitanTx.this, vertexid, lifecycle);
                }
            } else if (StandardTitanTx.this.idInspector.isVertexLabelVertexId(vertexid)) {
                vertex = new VertexLabelVertex(StandardTitanTx.this, vertexid, lifecycle);
            } else if (StandardTitanTx.this.idInspector.isGenericSchemaVertexId(vertexid)) {
                vertex = new TitanSchemaVertex(StandardTitanTx.this, vertexid, lifecycle);
            } else if (StandardTitanTx.this.idInspector.isUserVertexId(vertexid)) {
                vertex = new CacheVertex(StandardTitanTx.this, vertexid, lifecycle);
            } else {
                throw new IllegalArgumentException("ID could not be recognized");
            }
            return vertex;
        }
    }
}

