/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.reporting.ruleexecution;

import freemarker.ext.beans.StringModel;
import freemarker.template.TemplateModelException;
import java.util.List;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.WindupRuleProvider;
import org.jboss.windup.reporting.freemarker.WindupFreeMarkerMethod;
import org.jboss.windup.reporting.ruleexecution.RuleExecutionInformation;
import org.jboss.windup.reporting.ruleexecution.RuleExecutionResultsListener;
import org.jboss.windup.util.ExecutionStatistics;

public class GetRuleExecutionResults
implements WindupFreeMarkerMethod {
    public static final String NAME = "getRuleExecutionResults";
    private GraphRewrite event;

    public String getMethodName() {
        return NAME;
    }

    public String getDescription() {
        return "Takes a parameter of type " + WindupRuleProvider.class.getSimpleName() + " and returns a List<" + RuleExecutionInformation.class.getSimpleName() + "> containing metadata related to the current Windup execution.";
    }

    public Object exec(List arguments) throws TemplateModelException {
        ExecutionStatistics.get().begin(NAME);
        if (arguments.size() != 1) {
            throw new TemplateModelException("Error, method expects one argument (WindupRuleProvider)");
        }
        StringModel stringModelArg = (StringModel)arguments.get(0);
        WindupRuleProvider ruleProvider = (WindupRuleProvider)stringModelArg.getWrappedObject();
        List<RuleExecutionInformation> result = RuleExecutionResultsListener.instance(this.event).getRuleExecutionInformation(ruleProvider);
        ExecutionStatistics.get().begin(NAME);
        return result;
    }

    public void setContext(GraphRewrite event) {
        this.event = event;
    }
}

