/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.reporting.rules.rendering;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.apache.commons.io.FileUtils;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.WindupRuleProvider;
import org.jboss.windup.config.operation.GraphOperation;
import org.jboss.windup.config.phase.PostFinalize;
import org.jboss.windup.config.phase.RulePhase;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.WindupConfigurationModel;
import org.jboss.windup.graph.model.performance.RulePhaseExecutionStatisticsModel;
import org.jboss.windup.graph.model.performance.RuleProviderExecutionStatisticsModel;
import org.jboss.windup.graph.service.GraphService;
import org.jboss.windup.graph.service.RuleProviderExecutionStatisticsService;
import org.jboss.windup.graph.service.WindupConfigurationService;
import org.jboss.windup.util.ExecutionStatistics;
import org.jboss.windup.util.exception.WindupException;
import org.ocpsoft.rewrite.config.Configuration;
import org.ocpsoft.rewrite.config.ConfigurationBuilder;
import org.ocpsoft.rewrite.config.Operation;
import org.ocpsoft.rewrite.context.EvaluationContext;

public class ExecutionTimeReportRuleProvider
extends WindupRuleProvider {
    public Class<? extends RulePhase> getPhase() {
        return PostFinalize.class;
    }

    public Configuration getConfiguration(GraphContext context) {
        return ConfigurationBuilder.begin().addRule().perform((Operation)new GraphOperation(){

            public void perform(GraphRewrite event, EvaluationContext context) {
                WindupConfigurationModel cfg = WindupConfigurationService.getConfigurationModel((GraphContext)event.getGraphContext());
                String outputDir = cfg.getOutputPath().getFilePath();
                Path statsDir = Paths.get(outputDir, "stats");
                FileUtils.deleteQuietly((File)statsDir.toFile());
                try {
                    Files.createDirectories(statsDir, new FileAttribute[0]);
                }
                catch (IOException e) {
                    throw new WindupException("Error creating output folder: " + outputDir + " due to: " + e.getMessage(), (Throwable)e);
                }
                Path detailedExecutionStatsOutputPath = statsDir.resolve("detailed_stats.csv");
                ExecutionStatistics.get().serializeTimingData(detailedExecutionStatsOutputPath);
                Path ruleTimingOutputPath = statsDir.resolve("timing.txt");
                try (FileWriter fw = new FileWriter(ruleTimingOutputPath.toFile());){
                    RuleProviderExecutionStatisticsService statsByRuleProviderService = new RuleProviderExecutionStatisticsService(event.getGraphContext());
                    Iterable ruleProviderStatModels = statsByRuleProviderService.findAllOrderedByIndex();
                    fw.write("-----------------------------------------------------------\n");
                    fw.write("Rule execution timings:\n\n");
                    for (RuleProviderExecutionStatisticsModel model : ruleProviderStatModels) {
                        fw.write(model.getRuleProviderID());
                        fw.write(": ");
                        fw.write(String.valueOf(model.getTimeTaken()));
                        fw.write(" ms");
                        fw.write(" (");
                        fw.write(String.valueOf(model.getTimeTaken() / 1000));
                        fw.write(" seconds)");
                        fw.write("\n");
                    }
                    fw.write("-----------------------------------------------------------\n\n");
                    fw.write("Phase execution timings:\n\n");
                    GraphService statsByPhaseService = new GraphService(event.getGraphContext(), RulePhaseExecutionStatisticsModel.class);
                    Iterable rulePhaseStatModelIterable = statsByPhaseService.findAll();
                    ArrayList<RulePhaseExecutionStatisticsModel> rulePhaseStatModelList = new ArrayList<RulePhaseExecutionStatisticsModel>();
                    for (RulePhaseExecutionStatisticsModel model : rulePhaseStatModelIterable) {
                        rulePhaseStatModelList.add(model);
                    }
                    Collections.sort(rulePhaseStatModelList, new Comparator<RulePhaseExecutionStatisticsModel>(){

                        @Override
                        public int compare(RulePhaseExecutionStatisticsModel o1, RulePhaseExecutionStatisticsModel o2) {
                            return o1.getOrderExecuted() - o2.getOrderExecuted();
                        }
                    });
                    for (RulePhaseExecutionStatisticsModel model : rulePhaseStatModelList) {
                        fw.write(model.getRulePhase());
                        fw.write(": ");
                        fw.write(String.valueOf(model.getTimeTaken()));
                        fw.write(" ms");
                        fw.write(" (");
                        fw.write(String.valueOf(model.getTimeTaken() / 1000));
                        fw.write(" seconds)");
                        fw.write("\n");
                    }
                    fw.write("-----------------------------------------------------------\n");
                }
                catch (IOException e) {
                    throw new WindupException("Error creating output file: " + ruleTimingOutputPath.toString() + " due to: " + e.getMessage(), (Throwable)e);
                }
            }

            public String toString() {
                return "RenderRuleExecutionTimeReport";
            }
        });
    }
}

