/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.reporting.xml;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.jboss.windup.config.exception.ConfigurationException;
import org.jboss.windup.config.parser.ElementHandler;
import org.jboss.windup.config.parser.NamespaceElementHandler;
import org.jboss.windup.config.parser.ParserContext;
import org.jboss.windup.reporting.config.Hint;
import org.jboss.windup.reporting.config.Link;
import org.jboss.windup.util.exception.WindupException;
import org.joox.JOOX;
import org.w3c.dom.Element;

@NamespaceElementHandler(elementName="hint", namespace="http://windup.jboss.org/v1/xml")
public class HintHandler
implements ElementHandler<Hint> {
    public Hint processElement(ParserContext handlerManager, Element element) throws ConfigurationException {
        String message = JOOX.$((Element)element).attr("message");
        String in = JOOX.$((Element)element).attr("in");
        if (StringUtils.isBlank((String)message)) {
            List children = JOOX.$((Element)element).children().get();
            for (Element child : children) {
                if (!child.getNodeName().equals("message")) continue;
                message = (String)handlerManager.processElement(child);
            }
        }
        if (StringUtils.isBlank((String)message)) {
            throw new WindupException("Error, 'hint' element must have a non-empty 'message' attribute or element");
        }
        String effortStr = JOOX.$((Element)element).attr("effort");
        Hint hint = Hint.in((String)in).withText(message);
        if (!StringUtils.isBlank((String)effortStr)) {
            try {
                int effort = Integer.parseInt(effortStr);
                hint.withEffort(effort);
            }
            catch (NumberFormatException e) {
                throw new WindupException("Could not parse effort level: " + effortStr + " as an integer!");
            }
        }
        List children = JOOX.$((Element)element).children().get();
        for (Element child : children) {
            if (!child.getNodeName().equals("link")) continue;
            Link link = (Link)handlerManager.processElement(child);
            hint.with(link);
        }
        return hint;
    }
}

