/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.shell.aesh;

import java.util.Set;
import java.util.TreeSet;
import org.jboss.aesh.cl.parser.CommandLineParser;
import org.jboss.aesh.console.command.Command;
import org.jboss.aesh.console.command.CommandNotFoundException;
import org.jboss.aesh.console.command.container.CommandContainer;
import org.jboss.aesh.console.command.registry.AeshCommandRegistryBuilder;
import org.jboss.aesh.console.command.registry.CommandRegistry;
import org.jboss.aesh.console.helper.ManProvider;
import org.jboss.aesh.console.man.Man;
import org.jboss.aesh.extensions.grep.Grep;
import org.jboss.aesh.extensions.less.aesh.Less;
import org.jboss.aesh.extensions.more.aesh.More;
import org.jboss.forge.addon.shell.ShellImpl;
import org.jboss.forge.addon.shell.aesh.AbstractShellInteraction;
import org.jboss.forge.addon.shell.aesh.CommandAdapter;
import org.jboss.forge.addon.shell.aesh.CommandLineUtil;
import org.jboss.forge.addon.shell.aesh.ForgeCommandContainer;
import org.jboss.forge.addon.shell.aesh.ForgeManProvider;
import org.jboss.forge.addon.shell.aesh.ShellSingleCommand;
import org.jboss.forge.addon.shell.aesh.ShellWizard;
import org.jboss.forge.addon.shell.ui.AeshUICommand;
import org.jboss.forge.addon.shell.ui.ShellContext;
import org.jboss.forge.addon.shell.ui.ShellContextImpl;
import org.jboss.forge.addon.ui.UIRuntime;
import org.jboss.forge.addon.ui.command.CommandFactory;
import org.jboss.forge.addon.ui.command.UICommand;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.controller.CommandController;
import org.jboss.forge.addon.ui.controller.CommandControllerFactory;
import org.jboss.forge.addon.ui.controller.SingleCommandController;
import org.jboss.forge.addon.ui.controller.WizardCommandController;
import org.jboss.forge.furnace.Furnace;
import org.jboss.forge.furnace.addons.AddonRegistry;
import org.jboss.forge.furnace.exception.ContainerException;

public class ForgeCommandRegistry
implements CommandRegistry {
    private Furnace furnace;
    private final ShellImpl shell;
    private final CommandFactory commandFactory;
    private final CommandRegistry aeshCommandRegistry;
    private final AddonRegistry addonRegistry;
    private CommandLineUtil commandLineUtil;
    private final CommandControllerFactory commandControllerFactory;

    public ForgeCommandRegistry(Furnace furnace, ShellImpl shell, AddonRegistry addonRegistry) {
        this.furnace = furnace;
        this.shell = shell;
        this.addonRegistry = addonRegistry;
        this.commandFactory = (CommandFactory)addonRegistry.getServices(CommandFactory.class).get();
        this.commandControllerFactory = (CommandControllerFactory)addonRegistry.getServices(CommandControllerFactory.class).get();
        Man manCommand = new Man((ManProvider)new ForgeManProvider(shell, this.commandFactory));
        this.aeshCommandRegistry = new AeshCommandRegistryBuilder().command(Grep.class).command(Less.class).command(More.class).command((Command)manCommand).create();
        manCommand.setRegistry((CommandRegistry)this);
    }

    public CommandContainer getCommand(String name, String completeLine) throws CommandNotFoundException {
        this.waitUntilStarted();
        ShellContextImpl shellContext = this.shell.createUIContext();
        try {
            return this.getForgeCommand(shellContext, name, completeLine);
        }
        catch (CommandNotFoundException cnfe) {
            CommandContainer nativeCommand = this.aeshCommandRegistry.getCommand(name, completeLine);
            AeshUICommand aeshCommand = new AeshUICommand(nativeCommand);
            SingleCommandController controller = this.commandControllerFactory.createSingleController((UIContext)shellContext, (UIRuntime)this.shell, (UICommand)aeshCommand);
            try {
                controller.initialize();
            }
            catch (Exception e) {
                // empty catch block
            }
            ShellSingleCommand cmd = new ShellSingleCommand((CommandController)controller, shellContext, this.getCommandLineUtil());
            CommandAdapter commandAdapter = new CommandAdapter(this.shell, shellContext, cmd);
            return new ForgeCommandContainer(shellContext, aeshCommand.getCommandLineParser(), commandAdapter);
        }
    }

    private CommandContainer getForgeCommand(ShellContextImpl shellContext, String name, String completeLine) throws CommandNotFoundException {
        AbstractShellInteraction cmd = this.findCommand(shellContext, name);
        if (cmd == null || !cmd.getController().isEnabled()) {
            throw new CommandNotFoundException(name);
        }
        try {
            CommandLineParser parser = cmd.getParser(shellContext, completeLine == null ? name : completeLine);
            CommandAdapter command = new CommandAdapter(this.shell, shellContext, cmd);
            return new ForgeCommandContainer(shellContext, parser, command);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Error while creating parser: " + e.getMessage(), e);
        }
    }

    private AbstractShellInteraction findCommand(ShellContext shellContext, String commandName) {
        AbstractShellInteraction result = null;
        CommandLineUtil cmdLineUtil = this.getCommandLineUtil();
        UICommand cmd = this.commandFactory.getNewCommandByName((UIContext)shellContext, commandName);
        if (cmd != null) {
            CommandController controller = this.commandControllerFactory.createController((UIContext)shellContext, (UIRuntime)this.shell, cmd);
            result = controller instanceof WizardCommandController ? new ShellWizard((WizardCommandController)controller, shellContext, cmdLineUtil, this) : new ShellSingleCommand(controller, shellContext, cmdLineUtil);
        }
        return result;
    }

    private CommandLineUtil getCommandLineUtil() {
        if (this.commandLineUtil == null) {
            this.commandLineUtil = new CommandLineUtil(this.addonRegistry);
        }
        return this.commandLineUtil;
    }

    public Set<String> getAllCommandNames() {
        this.waitUntilStarted();
        TreeSet<String> allCommands = new TreeSet<String>();
        allCommands.addAll(this.getForgeCommandNames());
        allCommands.addAll(this.aeshCommandRegistry.getAllCommandNames());
        return allCommands;
    }

    public void waitUntilStarted() {
        while (this.furnace.getStatus().isStarting()) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                throw new ContainerException("Interrputed while waiting for STARTED state.", (Throwable)e);
            }
        }
    }

    private Set<String> getForgeCommandNames() {
        try (ShellContextImpl newShellContext = this.shell.createUIContext();){
            Set set = this.commandFactory.getEnabledCommandNames((UIContext)newShellContext);
            return set;
        }
    }
}

