/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.shell.aesh.completion;

import java.io.File;
import org.jboss.aesh.cl.completer.FileOptionCompleter;
import org.jboss.aesh.cl.completer.OptionCompleter;
import org.jboss.aesh.console.command.completer.CompleterInvocation;
import org.jboss.aesh.io.filter.AllResourceFilter;
import org.jboss.aesh.io.filter.DirectoryResourceFilter;
import org.jboss.aesh.io.filter.ResourceFilter;
import org.jboss.forge.addon.convert.ConverterFactory;
import org.jboss.forge.addon.resource.FileResource;
import org.jboss.forge.addon.resource.Resource;
import org.jboss.forge.addon.shell.aesh.completion.SelectComponentOptionCompleter;
import org.jboss.forge.addon.shell.aesh.completion.UICompleterOptionCompleter;
import org.jboss.forge.addon.shell.ui.ShellContext;
import org.jboss.forge.addon.ui.context.UISelection;
import org.jboss.forge.addon.ui.facets.HintsFacet;
import org.jboss.forge.addon.ui.input.InputComponent;
import org.jboss.forge.addon.ui.input.SelectComponent;

public class OptionCompleterFactory {
    public static OptionCompleter<CompleterInvocation> getCompletionFor(InputComponent<?, ?> component, ShellContext context, ConverterFactory converterFactory) {
        UISelection selection = context.getInitialSelection();
        Resource selectedResource = (Resource)selection.get();
        File cwd = null;
        if (selectedResource instanceof FileResource) {
            cwd = (File)((FileResource)selectedResource).getUnderlyingResourceObject();
        }
        String inputType = ((HintsFacet)component.getFacet(HintsFacet.class)).getInputType();
        Object strategy = null;
        if ("org.jboss.forge.inputType.FILE_PICKER".equals(inputType) && cwd != null && cwd.isDirectory()) {
            strategy = new FileOptionCompleter((ResourceFilter)new AllResourceFilter());
        } else if ("org.jboss.forge.inputType.DIRECTORY_PICKER".equals(inputType) && cwd != null && cwd.isDirectory()) {
            strategy = new FileOptionCompleter((ResourceFilter)new DirectoryResourceFilter());
        } else if (component instanceof SelectComponent) {
            strategy = new SelectComponentOptionCompleter((SelectComponent)component, converterFactory);
        } else if (Resource.class.isAssignableFrom(component.getValueType())) {
            strategy = new FileOptionCompleter((ResourceFilter)new AllResourceFilter());
        }
        strategy = new UICompleterOptionCompleter((OptionCompleter<CompleterInvocation>)strategy, context, component, converterFactory);
        return strategy;
    }
}

