/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.shell.aesh.completion;

import java.util.ArrayList;
import org.jboss.aesh.cl.completer.OptionCompleter;
import org.jboss.aesh.console.command.completer.CompleterInvocation;
import org.jboss.forge.addon.convert.Converter;
import org.jboss.forge.addon.convert.ConverterFactory;
import org.jboss.forge.addon.shell.ui.ShellContext;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.input.InputComponent;
import org.jboss.forge.addon.ui.input.ManyValued;
import org.jboss.forge.addon.ui.input.SelectComponent;
import org.jboss.forge.addon.ui.input.UICompleter;
import org.jboss.forge.addon.ui.util.InputComponents;

class UICompleterOptionCompleter
implements OptionCompleter<CompleterInvocation> {
    private final OptionCompleter<CompleterInvocation> fallback;
    private final InputComponent<?, Object> input;
    private final ConverterFactory converterFactory;
    private final ShellContext context;

    public UICompleterOptionCompleter(OptionCompleter<CompleterInvocation> fallback, ShellContext context, InputComponent<?, ?> input, ConverterFactory converterFactory) {
        this.fallback = fallback;
        this.context = context;
        this.input = input;
        this.converterFactory = converterFactory;
    }

    public void complete(CompleterInvocation completerData) {
        String completeValue = completerData.getGivenCompleteValue();
        UICompleter completer = InputComponents.getCompleterFor(this.input);
        if (completer != null) {
            Object value;
            Converter converter = this.input instanceof SelectComponent ? InputComponents.getItemLabelConverter((ConverterFactory)this.converterFactory, (SelectComponent)((SelectComponent)this.input)) : this.converterFactory.getConverter(this.input.getValueType(), String.class);
            ArrayList<String> choices = new ArrayList<String>();
            for (Object proposal : completer.getCompletionProposals((UIContext)this.context, this.input, completeValue)) {
                if (proposal == null) continue;
                String convertedValue = (String)converter.convert(proposal);
                choices.add(convertedValue);
            }
            if (this.input instanceof ManyValued && (value = InputComponents.getValueFor(this.input)) != null) {
                if (value instanceof Iterable) {
                    for (Object next : (Iterable)value) {
                        String convert = (String)converter.convert(next);
                        choices.remove(convert);
                    }
                } else {
                    String convert = (String)converter.convert(value);
                    choices.remove(convert);
                }
            }
            completerData.addAllCompleterValues(choices);
        } else if (this.fallback != null) {
            this.fallback.complete(completerData);
        }
    }
}

