/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.streamflyer.core;

import com.googlecode.streamflyer.core.AfterModification;
import com.googlecode.streamflyer.core.FaultyModifierException;
import com.googlecode.streamflyer.core.Modifier;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;

public class ModifyingWriter
extends Writer {
    protected Writer delegate;
    private Modifier modifier;
    private StringBuilder characterBuffer;
    private int firstModifiableCharacterInBuffer;
    private int minimumLengthOfLookBehind;
    private int requestedNumCharactersInBuffer;
    private int numberOfCharactersToSkip;
    private boolean endOfStreamHit = false;
    private AfterModification lastAfterModificationForDebuggingOnly = null;

    public ModifyingWriter(Writer writer, Modifier modifier) {
        super((Object)writer);
        this.modifier = modifier;
        this.delegate = writer;
        this.numberOfCharactersToSkip = 0;
        this.minimumLengthOfLookBehind = 0;
        this.firstModifiableCharacterInBuffer = 0;
        this.requestedNumCharactersInBuffer = 1;
        this.characterBuffer = new StringBuilder(this.requestedNumCharactersInBuffer);
    }

    @Override
    public void flush() throws IOException {
        this.delegate.flush();
    }

    @Override
    public void close() throws IOException {
        this.endOfStreamHit = true;
        while (this.modify()) {
        }
        this.delegate.append(this.characterBuffer, this.firstModifiableCharacterInBuffer, this.characterBuffer.length());
        this.characterBuffer = null;
        this.flush();
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        if (this.endOfStreamHit) {
            throw new IOException("the stream is already closed");
        }
        while (len > 0) {
            int numberOfCharactersToAppend = len > this.requestedNumCharactersInBuffer - this.characterBuffer.length() ? this.requestedNumCharactersInBuffer - this.characterBuffer.length() : len;
            this.characterBuffer.append(cbuf, off, numberOfCharactersToAppend);
            off += numberOfCharactersToAppend;
            len -= numberOfCharactersToAppend;
            while (this.characterBuffer.length() >= this.requestedNumCharactersInBuffer && this.modify()) {
            }
        }
    }

    private boolean modify() throws IOException {
        AfterModification afterModification;
        this.lastAfterModificationForDebuggingOnly = afterModification = this.modifier.modify(this.characterBuffer, this.firstModifiableCharacterInBuffer, this.endOfStreamHit);
        this.numberOfCharactersToSkip = afterModification.getNumberOfCharactersToSkip();
        boolean someCharactersSkippedOrModifyAgainImmediately = false;
        if (afterModification.isModifyAgainImmediately()) {
            if (this.endOfStreamHit) {
                // empty if block
            }
            someCharactersSkippedOrModifyAgainImmediately = true;
        } else if (this.numberOfCharactersToSkip > 0) {
            int end = this.firstModifiableCharacterInBuffer + this.numberOfCharactersToSkip;
            if (end > this.characterBuffer.length()) {
                this.onFaultyModifier(-51, String.format("You try to skip characters that you have not seen yet(%s %s %s %s)", this.firstModifiableCharacterInBuffer, this.numberOfCharactersToSkip, this.characterBuffer.length(), this.characterBuffer));
            }
            this.delegate.append(this.characterBuffer, this.firstModifiableCharacterInBuffer, end);
            someCharactersSkippedOrModifyAgainImmediately = true;
            this.firstModifiableCharacterInBuffer = end;
        }
        this.minimumLengthOfLookBehind = afterModification.getNewMinimumLengthOfLookBehind();
        if (this.minimumLengthOfLookBehind > this.firstModifiableCharacterInBuffer) {
            this.onFaultyModifier(-11, "Requested Look Behind is impossible because there are not enough characters in the stream.");
        }
        this.requestedNumCharactersInBuffer = this.minimumLengthOfLookBehind + afterModification.getNewNumberOfChars();
        if (this.requestedNumCharactersInBuffer < this.minimumLengthOfLookBehind + 1) {
            this.onFaultyModifier(-13, "Requested Capacity is two small because there must at least one unread characters available after the look behind characters characters in the stream.");
        }
        this.updateBuffer();
        return someCharactersSkippedOrModifyAgainImmediately;
    }

    private void updateBuffer() {
        this.removeCharactersInBufferNotNeededAnyLonger();
        this.adjustCapacityOfBuffer();
    }

    private void removeCharactersInBufferNotNeededAnyLonger() {
        int charactersToDelete = this.firstModifiableCharacterInBuffer - this.minimumLengthOfLookBehind;
        if (charactersToDelete > 0) {
            this.characterBuffer.delete(0, charactersToDelete);
            this.firstModifiableCharacterInBuffer -= charactersToDelete;
        } else if (charactersToDelete < 0) {
            this.onFaultyModifier(-52, charactersToDelete + " characters to delete but this is not possible (" + this.firstModifiableCharacterInBuffer + "," + this.minimumLengthOfLookBehind + ")");
        }
    }

    private void adjustCapacityOfBuffer() {
        if (this.characterBuffer.capacity() < this.requestedNumCharactersInBuffer) {
            this.characterBuffer.ensureCapacity(this.requestedNumCharactersInBuffer);
        }
    }

    protected void onFaultyModifier(int errorCode, String errorMessage) {
        HashMap<String, Object> description = new HashMap<String, Object>();
        description.put("argument errorCode", errorCode);
        description.put("argument errorMessage", errorMessage);
        description.put("this", this);
        ArrayList keys = new ArrayList(description.keySet());
        Collections.sort(keys);
        StringBuilder sb = new StringBuilder();
        for (String key : keys) {
            sb.append("\n" + key + ": " + description.get(key));
        }
        throw new FaultyModifierException(sb.toString(), description);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ModifyingWriter [\ndelegate=");
        builder.append(this.delegate);
        builder.append(", \nmodifier=");
        builder.append(this.modifier);
        builder.append(", \ncharacterBuffer=");
        builder.append((CharSequence)this.characterBuffer);
        builder.append(", \nnextUnreadCharacterInBuffer=");
        builder.append(this.firstModifiableCharacterInBuffer);
        builder.append(", \nminimumLengthOfLookBehind=");
        builder.append(this.minimumLengthOfLookBehind);
        builder.append(", \nrequestedCapacityOfCharacterBuffer=");
        builder.append(this.requestedNumCharactersInBuffer);
        builder.append(", \nlockedCharacters=");
        builder.append(this.numberOfCharactersToSkip);
        builder.append(", \nendOfStreamHit=");
        builder.append(this.endOfStreamHit);
        builder.append(", \nlastModificationForDebuggingOnly=");
        builder.append(this.lastAfterModificationForDebuggingOnly);
        builder.append("]");
        return builder.toString();
    }
}

