/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.streamflyer.regex;

import com.googlecode.streamflyer.regex.OnStreamMatcher;
import java.util.regex.Matcher;

public class OnStreamStandardMatcher
implements OnStreamMatcher {
    protected Matcher matcher;
    protected CharSequence input;
    protected int lastFrom;

    public OnStreamStandardMatcher(Matcher matcher) {
        this.matcher = matcher;
    }

    @Override
    public void reset(CharSequence input_) {
        this.matcher.reset(input_);
        this.input = input_;
    }

    @Override
    public boolean findUnlessHitEnd(int minFrom, int maxFrom) {
        this.lastFrom = minFrom;
        boolean result = false;
        while (this.lastFrom <= maxFrom) {
            this.matcher.region(this.lastFrom, this.input.length());
            result = this.matcher.lookingAt();
            if (result || this.matcher.hitEnd()) break;
            ++this.lastFrom;
        }
        return result;
    }

    @Override
    public int lastFrom() {
        return this.lastFrom;
    }

    @Override
    public boolean hitEnd() {
        return this.matcher.hitEnd();
    }

    @Override
    public boolean requireEnd() {
        return this.matcher.requireEnd();
    }

    @Override
    public int start() {
        return this.matcher.start();
    }

    @Override
    public int start(int group) {
        return this.matcher.start(group);
    }

    @Override
    public int end() {
        return this.matcher.end();
    }

    @Override
    public int end(int group) {
        return this.matcher.end(group);
    }

    @Override
    public String group() {
        return this.matcher.group();
    }

    @Override
    public String group(int group) {
        return this.matcher.group(group);
    }

    @Override
    public int groupCount() {
        return this.matcher.groupCount();
    }
}

