/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.streamflyer.regex.addons.tokens;

import java.util.regex.MatchResult;

public class MatchResultWithOffset
implements MatchResult {
    private MatchResult delegate;
    private int groupOffset;
    private Integer groupCount;

    public MatchResultWithOffset(MatchResult delegate, int groupOffset) {
        if (groupOffset > delegate.groupCount() || groupOffset < 0) {
            throw new IndexOutOfBoundsException("No group " + groupOffset);
        }
        this.delegate = delegate;
        this.groupOffset = groupOffset;
    }

    @Override
    public int start() {
        return this.delegate.start(this.groupOffset);
    }

    @Override
    public int start(int group) {
        return this.delegate.start(this.groupOffset + group);
    }

    @Override
    public int end() {
        return this.delegate.end(this.groupOffset);
    }

    @Override
    public int end(int group) {
        return this.delegate.end(this.groupOffset + group);
    }

    @Override
    public String group() {
        return this.delegate.group(this.groupOffset);
    }

    @Override
    public String group(int group) {
        return this.delegate.group(this.groupOffset + group);
    }

    @Override
    public int groupCount() {
        if (this.groupCount == null) {
            int groupIndex;
            for (groupIndex = this.groupOffset + 1; groupIndex <= this.delegate.groupCount() && this.delegate.end(groupIndex) <= this.delegate.end(this.groupOffset); ++groupIndex) {
            }
            this.groupCount = groupIndex - 1 - this.groupOffset;
        }
        return this.groupCount;
    }

    public String toString() {
        return "MatchResultWithOffset [delegate=" + this.delegate + ", groupOffset=" + this.groupOffset + ", groupCount=" + this.groupCount + "]";
    }
}

