/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.streamflyer.util.statistics;

import com.googlecode.streamflyer.core.AfterModification;
import com.googlecode.streamflyer.util.ModificationFactory;
import com.googlecode.streamflyer.util.statistics.ModificationFactoryDecorator;

public class StatisticsModificationFactory
extends ModificationFactoryDecorator {
    protected int numAllModifications = 0;
    protected int numModifyAgainImmediately = 0;
    protected int numMoreInputThanDefault;
    protected int maxRequestedNewNumberOfChars;

    public StatisticsModificationFactory(ModificationFactory delegate) {
        super(delegate);
    }

    @Override
    public AfterModification modifyAgainImmediately(int newNumberOfChars, int firstModifiableCharacterInBuffer) {
        return this.count(super.modifyAgainImmediately(newNumberOfChars, firstModifiableCharacterInBuffer));
    }

    @Override
    public AfterModification fetchMoreInput(int numberOfCharactersToSkip, StringBuilder characterBuffer, int firstModifiableCharacterInBuffer, boolean endOfStreamHit) {
        return this.count(super.fetchMoreInput(numberOfCharactersToSkip, characterBuffer, firstModifiableCharacterInBuffer, endOfStreamHit));
    }

    @Override
    public AfterModification skipOrStop(int numberOfCharactersToSkip, StringBuilder characterBuffer, int firstModifiableCharacterInBuffer, boolean endOfStreamHit) {
        return this.count(super.skipOrStop(numberOfCharactersToSkip, characterBuffer, firstModifiableCharacterInBuffer, endOfStreamHit));
    }

    @Override
    public AfterModification skip(int numberOfCharactersToSkip, StringBuilder characterBuffer, int firstModifiableCharacterInBuffer, boolean endOfStreamHit) {
        return this.count(super.skip(numberOfCharactersToSkip, characterBuffer, firstModifiableCharacterInBuffer, endOfStreamHit));
    }

    @Override
    public AfterModification skipEntireBuffer(StringBuilder characterBuffer, int firstModifiableCharacterInBuffer, boolean endOfStreamHit) {
        return this.count(super.skipEntireBuffer(characterBuffer, firstModifiableCharacterInBuffer, endOfStreamHit));
    }

    @Override
    public AfterModification stop(StringBuilder characterBuffer, int firstModifiableCharacterInBuffer, boolean endOfStreamHit) {
        return this.count(super.stop(characterBuffer, firstModifiableCharacterInBuffer, endOfStreamHit));
    }

    protected AfterModification count(AfterModification afterModification) {
        ++this.numAllModifications;
        if (afterModification.isModifyAgainImmediately()) {
            ++this.numModifyAgainImmediately;
        }
        if (this.maxRequestedNewNumberOfChars < afterModification.getNewNumberOfChars()) {
            this.maxRequestedNewNumberOfChars = afterModification.getNewNumberOfChars();
        }
        if (afterModification.getNewNumberOfChars() < afterModification.getNewNumberOfChars()) {
            ++this.numMoreInputThanDefault;
        }
        return afterModification;
    }

    public int getNumAllModifications() {
        return this.numAllModifications;
    }

    public int getNumModifyAgainImmediately() {
        return this.numModifyAgainImmediately;
    }

    public int getNumMoreInputThanDefault() {
        return this.numMoreInputThanDefault;
    }

    public int getMaxRequestedNewNumberOfChars() {
        return this.maxRequestedNewNumberOfChars;
    }
}

