/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.extensions.cd;

import java.io.IOException;
import java.util.List;
import org.jboss.aesh.cl.Arguments;
import org.jboss.aesh.cl.CommandDefinition;
import org.jboss.aesh.cl.Option;
import org.jboss.aesh.console.Config;
import org.jboss.aesh.console.command.Command;
import org.jboss.aesh.console.command.CommandResult;
import org.jboss.aesh.console.command.invocation.CommandInvocation;
import org.jboss.aesh.io.Resource;

@CommandDefinition(name="cd", description="change directory [dir]")
public class Cd
implements Command<CommandInvocation> {
    @Option(shortName=104, name="help", hasValue=false, description="display this help and exit")
    private boolean help;
    @Arguments
    private List<Resource> arguments;

    public CommandResult execute(CommandInvocation commandInvocation) throws IOException {
        if (this.help) {
            commandInvocation.getShell().out().print(commandInvocation.getHelpInfo("cd"));
            return CommandResult.SUCCESS;
        }
        if (this.arguments == null) {
            this.updatePrompt(commandInvocation, commandInvocation.getAeshContext().getCurrentWorkingDirectory().newInstance(Config.getHomeDir()));
        } else {
            List files = this.arguments.get(0).resolve(commandInvocation.getAeshContext().getCurrentWorkingDirectory());
            if (((Resource)files.get(0)).isDirectory()) {
                this.updatePrompt(commandInvocation, (Resource)files.get(0));
            }
        }
        return CommandResult.SUCCESS;
    }

    private void updatePrompt(CommandInvocation commandInvocation, Resource file) {
        commandInvocation.getAeshContext().setCurrentWorkingDirectory(file);
    }
}

